
-- Weld constraint.
function Constraint_Weld( owner )
    -- Pop the entities.
    local ents = VMFSaver:PopEntities( 1, "phys_constraint" );
    
    -- Make sure our entity is valid.
    if( table.getn( ents ) ~= 1 ) then
        return;
    end
    if( _EntGetType( ents[1] ) ~= "phys_constraint" ) then
        return;
    end
    
    -- Apply the entity keyvalues to it.
    local entity_a, _ = VMFSaver:GetSelectedEntity( owner, true );
    local entity_b, _ = VMFSaver:GetSelectedEntity( owner, false );
    
    -- Add keyvalues.
    VMFSaver:AddKV( ents[1], "attach1", VMFSaver:GetEntityName( entity_a ) );
    VMFSaver:AddKV( ents[1], "attach2", VMFSaver:GetEntityName( entity_b ) );
    VMFSaver:AddKV( ents[1], "forcelimit", VMFSaver:GetAttrb( owner, "gmd_weld_weld_forcelimit" ) );
    if( VMFSaver:GetAttrb( owner, "gmd_weld_weld_nocollide" ) == 1 ) then
        VMFSaver:AddKV( ents[1], "spawnflags", "1" );
    end
    
    -- Add data.
    VMFSaver:AddData( ents[1], "attach1", entity_a );
    VMFSaver:AddData( ents[1], "attach2", entity_b );
    
    -- Debug shit.
    if( GLOBAL_DEBUG ) then
        VMFSaver:PrintEntity( ents[1] );
    end
    
    -- Clear constraint.
    VMFSaver:ClearConstraint();
end

function Constraint_Weld_Detect( owner, key )
    local ret = VMFSaver:DoEntitySelect( owner );
    
    -- Act on the return value.
    if( ret == 2 ) then
        VMFSaver:SetConstraint( owner, WELD );
        VMFSaver:ResetSelection( owner );
    end
end

-- Hook the weld constraint.
VMFSaver:HookConstraint( WELD, Constraint_Weld, Constraint_Weld_Detect );
