

-- This is the base SWEP (Scripted Weapon).
-- DO NOT change this file.
-- When making a new weapon you only need to override what you need.

_OpenScript( "includes/defines.lua" );
_OpenScript( "includes/vector3.lua" );
_OpenScript( "includes/misc.lua" );
_OpenScript( "includes/backcompat.lua" );


-- These variables are passed by the engine
-- Don't re-define them in your SWEP.
MyIndex			=	0; -- Weapon's entity index.
Owner			= 	0; -- The player that owns this weapon
CurrentTime		=	0; -- The current game time

POINT_ONE = vector3( 0, 0, 0 );
POINT_TWO = vector3( 0, 0, 0 );
HEIGHT = 0;
SELECTED_POINT1 = false;
SELECTED_POINT2 = false;
SELECTED_HEIGHT = false;
QUAD_UPDATE = _CurTime() + 0.15;


-- Called when the weapon is created.
	function onInit( )
        _SWEPSetSound( MyIndex, "single_shot", "Weapon_Pistol.Single" );
	end
	
	
-- Called when player picks up weapon
	function onPickup( playerid )
	end
	
	
-- Called when player drops weapon
	function onDrop( playerid )
	end


-- Weapon is about to be destroyed.
	function onRemove( )
	end


-- Called every frame
	function onThink( )
        -- Update quads if we have the 2 points selected.
        if( SELECTED_POINT1 and SELECTED_POINT2 and not SELECTED_HEIGHT and QUAD_UPDATE <= _CurTime() ) then
            QUAD_UPDATE = _CurTime() + 0.15;
            
            PlayerLookTrace( Owner, 4096 );
            HEIGHT = _TraceEndPos().z;
            
            -- Draw all 6 sides.
            _GModQuad_Start( "gmod/wireframe" );
            _GModQuad_SetVector( 0, vector3( POINT_ONE.x, POINT_ONE.y, POINT_ONE.z ) );
            _GModQuad_SetVector( 1, vector3( POINT_ONE.x, POINT_TWO.y, POINT_ONE.z ) );
            _GModQuad_SetVector( 2, vector3( POINT_ONE.x, POINT_TWO.y, HEIGHT) );
            _GModQuad_SetVector( 3, vector3( POINT_ONE.x, POINT_ONE.y, HEIGHT ) );
            _GModQuad_SetTimings( 0, 0, 30, 0 );
            _GModQuad_Send( Owner, 50 + Owner );
            
            _GModQuad_Start( "gmod/wireframe" );
            _GModQuad_SetVector( 0, vector3( POINT_TWO.x, POINT_ONE.y, POINT_ONE.z ) );
            _GModQuad_SetVector( 1, vector3( POINT_TWO.x, POINT_TWO.y, POINT_ONE.z ) );
            _GModQuad_SetVector( 2, vector3( POINT_TWO.x, POINT_TWO.y, HEIGHT) );
            _GModQuad_SetVector( 3, vector3( POINT_TWO.x, POINT_ONE.y, HEIGHT ) );
            _GModQuad_SetTimings( 0, 0, 30, 0 );
            _GModQuad_Send( Owner, 100 + Owner );
            
            _GModQuad_Start( "gmod/wireframe" );
            _GModQuad_SetVector( 0, vector3( POINT_ONE.x, POINT_ONE.y, POINT_ONE.z ) );
            _GModQuad_SetVector( 1, vector3( POINT_TWO.x, POINT_ONE.y, POINT_ONE.z ) );
            _GModQuad_SetVector( 2, vector3( POINT_TWO.x, POINT_ONE.y, HEIGHT ) );
            _GModQuad_SetVector( 3, vector3( POINT_ONE.x, POINT_ONE.y, HEIGHT ) );
            _GModQuad_SetTimings( 0, 0, 30, 0 );
            _GModQuad_Send( Owner, 150 + Owner );
            
            _GModQuad_Start( "gmod/wireframe" );
            _GModQuad_SetVector( 0, vector3( POINT_ONE.x, POINT_TWO.y, POINT_ONE.z ) );
            _GModQuad_SetVector( 1, vector3( POINT_TWO.x, POINT_TWO.y, POINT_ONE.z ) );
            _GModQuad_SetVector( 2, vector3( POINT_TWO.x, POINT_TWO.y, HEIGHT ) );
            _GModQuad_SetVector( 3, vector3( POINT_ONE.x, POINT_TWO.y, HEIGHT ) );
            _GModQuad_SetTimings( 0, 0, 30, 0 );
            _GModQuad_Send( Owner, 200 + Owner );
            
            _GModQuad_Start( "gmod/wireframe" );
            _GModQuad_SetVector( 0, vector3( POINT_TWO.x, POINT_TWO.y, POINT_ONE.z ) );
            _GModQuad_SetVector( 1, vector3( POINT_ONE.x, POINT_TWO.y, POINT_ONE.z ) );
            _GModQuad_SetVector( 2, vector3( POINT_ONE.x, POINT_ONE.y, POINT_ONE.z ) );
            _GModQuad_SetVector( 3, vector3( POINT_TWO.x, POINT_ONE.y, POINT_ONE.z ) );
            _GModQuad_SetTimings( 0, 0, 30, 0 );
            _GModQuad_Send( Owner, 250 + Owner );
            
            _GModQuad_Start( "gmod/wireframe" );
            _GModQuad_SetVector( 0, vector3( POINT_TWO.x, POINT_TWO.y, HEIGHT ) );
            _GModQuad_SetVector( 1, vector3( POINT_ONE.x, POINT_TWO.y, HEIGHT ) );
            _GModQuad_SetVector( 2, vector3( POINT_ONE.x, POINT_ONE.y, HEIGHT ) );
            _GModQuad_SetVector( 3, vector3( POINT_TWO.x, POINT_ONE.y, HEIGHT ) );
            _GModQuad_SetTimings( 0, 0, 30, 0 );
            _GModQuad_Send( Owner, 300 + Owner );
        end
	end
	

-- When the player presses left mouse button
	function onPrimaryAttack( )
        PlayerLookTrace( Owner, 4096 );
        if( not SELECTED_POINT1 ) then
            POINT_ONE = vecAdd( _TraceEndPos(), vector3( 0, 0, 1 ) );
            SELECTED_POINT1 = true;
        elseif( not SELECTED_POINT2 ) then
            POINT_TWO = vecAdd( _TraceEndPos(), vector3( 0, 0, 1 ) );
            SELECTED_POINT2 = true;
        elseif( not SELECTED_HEIGHT ) then
            SELECTED_HEIGHT = true;
            
            -- Create the lowest vector, and the highest vector.
            local highvec = vector3( math.max( POINT_ONE.x, POINT_TWO.x ), math.max( POINT_ONE.y, POINT_TWO.y ), math.max( POINT_ONE.z, POINT_TWO.z ) );
            local lowvec = vector3( math.min( POINT_ONE.x, POINT_TWO.x ), math.min( POINT_ONE.y, POINT_TWO.y ), math.min( POINT_ONE.z, POINT_TWO.z ) );
            
            -- Find entities in vec.
            local ents = _util.EntsInBox( lowvec, highvec );
            for _, entity in ents do
                if( not IsPlayer( entity ) ) then
                
                -- Select it.
                _RunString(
                [[
                    VMFSaver:SelectEntity( ]] .. Owner .. [[, ]] .. entity .. [[ );
                ]] );
                
                -- Draw invisible entities.
                if( string.find( _EntGetType( entity ), "prop_" ) == nil ) then
                    -- Draw a box around it.
                    local pos = _EntGetPos( entity );
                    _GModQuad_Start( "gmod/wireframe" );
                    _GModQuad_SetVector( 0, vector3( pos.x - 4, pos.y - 4, pos.z - 4 ) );
                    _GModQuad_SetVector( 1, vector3( pos.x + 4, pos.y - 4, pos.z - 4 ) );
                    _GModQuad_SetVector( 2, vector3( pos.x + 4, pos.y + 4, pos.z - 4 ) );
                    _GModQuad_SetVector( 3, vector3( pos.x - 4, pos.y + 4, pos.z - 4 ) );
                    _GModQuad_SetTimings( 0, 0, 30, 0 );
                    _GModQuad_Send( Owner, 10000 + entity );
                    
                    -- Draw a box around it.
                    _GModQuad_Start( "gmod/wireframe" );
                    _GModQuad_SetVector( 0, vector3( pos.x - 4, pos.y - 4, pos.z + 4 ) );
                    _GModQuad_SetVector( 1, vector3( pos.x + 4, pos.y - 4, pos.z + 4 ) );
                    _GModQuad_SetVector( 2, vector3( pos.x + 4, pos.y + 4, pos.z + 4 ) );
                    _GModQuad_SetVector( 3, vector3( pos.x - 4, pos.y + 4, pos.z + 4 ) );
                    _GModQuad_SetTimings( 0, 0, 30, 0 );
                    _GModQuad_Send( Owner, 13000 + entity );
                    
                    _GModQuad_Start( "gmod/wireframe" );
                    _GModQuad_SetVector( 0, vector3( pos.x - 4, pos.y - 4, pos.z + 4 ) );
                    _GModQuad_SetVector( 1, vector3( pos.x - 4, pos.y - 4, pos.z - 4 ) );
                    _GModQuad_SetVector( 2, vector3( pos.x + 4, pos.y - 4, pos.z - 4 ) );
                    _GModQuad_SetVector( 3, vector3( pos.x + 4, pos.y - 4, pos.z + 4 ) );
                    _GModQuad_SetTimings( 0, 0, 30, 0 );
                    _GModQuad_Send( Owner, 16000 + entity );
                    
                    _GModQuad_Start( "gmod/wireframe" );
                    _GModQuad_SetVector( 0, vector3( pos.x - 4, pos.y + 4, pos.z + 4 ) );
                    _GModQuad_SetVector( 1, vector3( pos.x - 4, pos.y + 4, pos.z - 4 ) );
                    _GModQuad_SetVector( 2, vector3( pos.x + 4, pos.y + 4, pos.z - 4 ) );
                    _GModQuad_SetVector( 3, vector3( pos.x + 4, pos.y + 4, pos.z + 4 ) );
                    _GModQuad_SetTimings( 0, 0, 30, 0 );
                    _GModQuad_Send( Owner, 19000 + entity );
                    
                    _GModQuad_Start( "gmod/wireframe" );
                    _GModQuad_SetVector( 0, vector3( pos.x - 4, pos.y - 4, pos.z - 4 ) );
                    _GModQuad_SetVector( 1, vector3( pos.x - 4, pos.y + 4, pos.z - 4 ) );
                    _GModQuad_SetVector( 2, vector3( pos.x - 4, pos.y + 4, pos.z + 4 ) );
                    _GModQuad_SetVector( 3, vector3( pos.x - 4, pos.y - 4, pos.z + 4 ) );
                    _GModQuad_SetTimings( 0, 0, 30, 0 );
                    _GModQuad_Send( Owner, 22000 + entity );
                    
                    _GModQuad_Start( "gmod/wireframe" );
                    _GModQuad_SetVector( 0, vector3( pos.x + 4, pos.y - 4, pos.z - 4 ) );
                    _GModQuad_SetVector( 1, vector3( pos.x + 4, pos.y + 4, pos.z - 4 ) );
                    _GModQuad_SetVector( 2, vector3( pos.x + 4, pos.y + 4, pos.z + 4 ) );
                    _GModQuad_SetVector( 3, vector3( pos.x + 4, pos.y - 4, pos.z + 4 ) );
                    _GModQuad_SetTimings( 0, 0, 30, 0 );
                    _GModQuad_Send( Owner, 25000 + entity );
                end
                
                end
            end
            
            _GModQuad_HideAll( Owner );
        
            SELECTED_POINT1 = false;
            SELECTED_POINT2 = false;
            SELECTED_HEIGHT = false;
        end
        
        
	end

	

-- When the player presses right mouse button
	function onSecondaryAttack( )	
	end


-- When Weapon is swapped to
	function Deploy( )
	end
	
	
-- When weapon swapped away from
	function Holster( )        
        _GModQuad_HideAll( Owner );
        
        SELECTED_POINT1 = false;
        SELECTED_POINT2 = false;
        SELECTED_HEIGHT = false;
	end
	

-- When player presses reload. Returning false means DON'T RELOAD. Although this will hitch on the client.
	function onReload( )
		return true;
	end



-- Primary Attack Settings
	function getDamage()
		return 0;
	end

	function getPrimaryShotDelay()
		return 0.2;
	end

	function getPrimaryIsAutomatic()
		return false;
	end

	function getBulletSpread()
		return vector3( 0.00, 0.00, 0.00 );
	end

	function getViewKick()
		return vector3( 0.0, 0.0, 0.0);
	end

	function getViewKickRandom()
		return vector3( 0.0, 0.0, 0.0 );
	end

	function getNumShotsPrimary()
		return 1;
	end

	function getPrimaryAmmoType()
		return "pistol";
	end

	function getMaxClipPrimary() -- return -1 if it doesn't use clips
		return 50;
	end
	
	function getDefClipPrimary() -- ammo in gun by default
		return 50;
	end
	
	function getTracerFreqPrimary() -- 0 = none, 1 = every bullet, 2 = every 2nd bullet etc
		return 0;
	end
	
	
-- Secondary attack Settings

	function getDamageSecondary()
		return 0;
	end

	function getSecondaryShotDelay()
		return 0.2;
	end

	function getSecondaryIsAutomatic()
		return true;
	end

	function getBulletSpreadSecondary()
		return vector3( 0.00, 0.00, 0.00 );
	end

	function getViewKickSecondary()
		return vector3( 0.0, 0.0, 0.0);
	end

	function getViewKickRandomSecondary()
		return vector3( 0.0, 0.0, 0.0 );
	end

	function getNumShotsSecondary()
		return 1;
	end

	function getSecondaryAmmoType()
		return "pistol";
	end

	function getMaxClipSecondary() -- return -1 if it doesn't use clips
		return -1;
	end

	function getDefClipSecondary()
		return 0;
	end
	
	function getTracerFreqSecondary()
		return 0;
	end
	
	
-- Weapon Configuration
	
	function getViewModel( )
		return "models/weapons/v_pistol.mdl";
	end

	function getWorldModel( )
		return "models/weapons/w_pistol.mdl";
	end

	function getClassName() 
		return "weapon_quadselect";
	end

	function getHUDMaterial( )
		return "gmod/SWEP/default";
	end

	function getDeathIcon( )
		return "swep_default";
	end

	function getWeaponSwapHands()
		return false	
	end

	function getWeaponFOV()
		return 58;
	end

	function getWeaponSlot()
		return -1	
	end

	function getWeaponSlotPos()
		return -1
	end

	function getFiresUnderwater()
		return true
	end

	function getReloadsSingly()
		return false
	end
	
	-- How the player model holds the weapon: 
	-- pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade
	function getAnimPrefix() 
		return "pistol";
	end

	function getPrintName()
		return "VMF Loader - Quad-Select Tool";
	end

	-- 0 = Don't override, shoot bullets, make sound and flash
	-- 1 = Don't shoot bullets but do make flash/sounds
	-- 2 = Only play animations
	-- 3 = Don't do anything
	function getPrimaryScriptOverride()
		return 1;
	end

	function getSecondaryScriptOverride()
		return 2;
	end



