-- VMF Loader Addons.
----------------------------------
VMFAddon = {};

-- Create an addon.
function VMFAddon:create( name )
    -- Make object.
    local obj = {};
    setmetatable( obj, self );
    self.__index = self;
    
    -- Set name.
    obj.name = name;
    obj.enabled = true;
    obj.player = nil;
    
    -- return object.
    return obj;
end

-- Disable/enable.
function VMFAddon:disable( )
    self.enabled = false;
end

function VMFAddon:enable( )
    self.enabled = true;
end

-- Virtual Functions.
function VMFAddon:Keyvalues( keyvalues )
    -- Handle keyvalues here.
end

function VMFAddon:Connections( connections )
    -- Handle connections here.
end

function VMFAddon:CreateEntity( entity )
    -- Handle entity creation here.
end

function VMFAddon:SpawnEntity( entity, keyvalues, connections )
    -- Handle entity spawning here.
end

function VMFAddon:MetaData( keyvalues )
    -- Handle vmf meta data here, ( this is not called when no metadata exists. )
end

function VMFAddon:LoadFile( filename )
    -- Handle file loading here.
end

function VMFAddon:LoadComplete( entities, worldkeys, luakeys )
    -- Handle loaded information here.
end

function VMFAddon:SpawningComplete( entitylist )
    -- Handle spawned entities here.
end

-- Install Addon.
function VMFAddon:install( )
    table.insert( Addon.Addons, self );
end

-- Get calling player.
function VMFAddon:getCallingPlayer( )
    return self.player;
end

-- Set calling player.
function VMFAddon:setCallingPlayer( player )
    self.player = player;
end

-- Addons.
---------------------------------
Addon = {};
Addon.Addons = {};

-- Events.
Addon.EVENT_KEYVALUES = 1;
Addon.EVENT_CONNECTIONS = 2;
Addon.EVENT_SPAWN_ENTITY = 3;
Addon.EVENT_LOAD_FILE = 4;
Addon.EVENT_LOAD_COMPLETE = 5;
Addon.EVENT_SPAWNING_COMPLETE = 6;
Addon.EVENT_ENTITY_CREATED = 7;
Addon.EVENT_META_DATA = 8;

function Addon:CallEvent( player, event, ... )
    -- Return value.
    local ret = false;
            
    -- Handle events.
    for _, addon in Addon.Addons do
        if( addon.enabled ) then
            -- Set calling player.
            addon:setCallingPlayer( player );
            
            -- Events.
            if( event == Addon.EVENT_KEYVALUES ) then
                if( addon:Keyvalues( unpack( arg ) ) ) then
                    ret = true;
                end
            elseif( event == Addon.EVENT_CONNECTIONS ) then
                if( addon:Connections( unpack( arg ) ) ) then
                    ret = true;
                end
            elseif( event == Addon.EVENT_SPAWN_ENTITY ) then
                if( addon:SpawnEntity( unpack( arg ) ) ) then
                    ret = true;
                end
            elseif( event == Addon.EVENT_LOAD_FILE ) then
                if( addon:LoadFile( unpack( arg ) ) ) then
                    ret = true;
                end
            elseif( event == Addon.EVENT_LOAD_COMPLETE ) then
                if( addon:LoadComplete( unpack( arg ) ) ) then
                    ret = true;
                end
            elseif( event == Addon.EVENT_SPAWNING_COMPLETE ) then
                if( addon:SpawningComplete( unpack( arg ) ) ) then
                    ret = true;
                end
            elseif( event == Addon.EVENT_ENTITY_CREATED ) then
                if( addon:CreateEntity( unpack( arg ) ) ) then
                    ret = true;
                end
            elseif( event == Addon.EVENT_META_DATA ) then
                if( addon:MetaData( unpack( arg ) ) ) then
                    ret = true;
                end
            end
        end
    end
    
    -- return the value.
    return ret;
end

-- Load filters.
Addon.Files = _file.Find( "lua/vmfloader/addons/*.lua" );
for _, file in Addon.Files do
    _OpenScript( "vmfloader/addons/" .. file );
end
