-- VMF Loader Utility Functions
----------------------------------------------
function VMFLoader:StringToVector( s )
    local x = string.sub( s, 1, string.find( s, " " ) - 1 );
    s = string.sub( s, string.find( s, " " ) + 1 );
    local y = string.sub( s, 1, string.find( s, " " ) - 1 );
    s = string.sub( s, string.find( s, " " ) + 1 );
    local z = s;
    return vector3( tonumber( x ), tonumber( y ), tonumber( z ) );
end

function VMFLoader:Clamp( num, min, max )
    local n = num;
    if( n < min ) then
        n = min;
    end
    if( n > max ) then
        n = max;
    end
    return n;
end

function VMFLoader:AngleBetweenPoints( p1, p2 )
    return math.deg( math.atan2( p2.y - p1.y, p2.x - p1.x ) );
end

function VMFLoader:CopyVector( vec )
    return vector3( vec.x, vec.y, vec.z );
end

function string.blowup( stringtoblowup, delimeter )
    local ret = {};
    local buffer = stringtoblowup;
    
    while( string.find( buffer, delimeter ) ~= nil ) do
        table.insert( ret, string.sub( buffer, 1, string.find( buffer, delimeter ) - 1 ) );
        buffer = string.sub( buffer, string.find( buffer, delimeter ) + 1 );
    end
    
    table.insert( ret, buffer );
    
    return ret;
end

function string.lastfind( str, find, start )
    local pos = string.find( str, find, start or 1 );
    local lastvalid = nil;
    while( pos ~= nil ) do
        lastvalid = pos;
        pos = string.find( str, find, pos + 1 );
    end
    return lastvalid;
end

