
-- VMF Saving.
------------------------------
VMFSaver = {};

-- Start debug.
GLOBAL_DEBUG = true;

-- Constants.
WELD = 2;
ROPE = 0;
ELASTIC = 1;
BALLSOCKET = 3;
PULLEY = 4;
EASY_WELD = 5;
EASY_BALLSOCKET = 6;
AXIS = 7;
SLIDER = 8;
NAIL = 9;
MAGNET = 17;
NOCOLLIDE = 18;
THRUSTER = 23;
BALLOON = 24;
WHEEL = 29;
MATERIAL = 20;
PAINT = 14;
COLOR = 16;
SPRITE = 28;
NONE = -1;

-- Globals.
VMFSaver.Entities = {};
VMFSaver.NewEntities = {};
VMFSaver.ConstraintMade = NONE;
VMFSaver.BelongsToPlayer = NONE;
VMFSaver.ConstraintHooks = {};

-- Init entity list.
for i = 1, 2048 do
    VMFSaver.Entities[i] = {};
    VMFSaver.Entities[i].exists = false;
    VMFSaver.Entities[i].keyvalues = {};
    VMFSaver.Entities[i].connections = {};
    VMFSaver.Entities[i].data = {};
end

-- Open scripts.
_OpenScript( "vmfloader/beta2/saver/utility.lua" );
_OpenScript( "vmfloader/beta2/saver/detection.lua" );

-- Hook constraint detector.
function VMFSaver:HookConstraint( ctype, callback )
    table.insert( VMFSaver.ConstraintHooks, { constraint_type = ctype, func = callback } );
end

-- Call hooks for constraint.
function VMFSaver:CallHooksForConstraint( constraint )
    for _, hook in VMFSaver.ConstraintHooks do
        if( hook.constraint_type == constraint ) then
            hook.func( VMFSaver.BelongsToPlayer );
        end
    end
end

-- Process constraints.
function VMFSaver:ProcessConstraints( )

end
