-- Token Reader.
-----------------------------------------------------
TokenReader = {};

TokenReader.TOKENSTRINGTOOLONG = -4;
TokenReader.TOKENERROR = -3;
TokenReader.TOKENNONE = -2;
TokenReader.TOKENEOF = -1;
TokenReader.OPERATOR = 0;
TokenReader.INTEGER = 1;
TokenReader.TSTRING = 2;
TokenReader.IDENT = 3;

TokenReader.g_sFileData = "";
TokenReader.g_iReaderPos = 1;

function TokenReader:SkipWhiteSpace( )
    local bContinue = false;
    while( true ) do
    
        bContinue = false;
        
        if( TokenReader.g_iReaderPos >= string.len( TokenReader.g_sFileData ) ) then
            return;
        end
        
        local ch = string.sub( TokenReader.g_sFileData, TokenReader.g_iReaderPos, TokenReader.g_iReaderPos );
        TokenReader.g_iReaderPos = TokenReader.g_iReaderPos + 1;
        
        if( ch == " " or ch == "\t" or ch == "\r" or ch == "\0" or ch == "\n" ) then
            bContinue = true;
        end
        
        -- If this is a comment skip to the end of the line then continue.
        if( ch == "/" ) then
            ch = string.sub( TokenReader.g_sFileData, TokenReader.g_iReaderPos, TokenReader.g_iReaderPos );
            TokenReader.g_iReaderPos = TokenReader.g_iReaderPos + 1;
            
            if( TokenReader.g_iReaderPos >= string.len( TokenReader.g_sFileData ) ) then
                return;
            end
                
            if( ch == "/" ) then
                -- Loop till end of line.
                while( ch ~= "\n" ) do
                    if( TokenReader.g_iReaderPos >= string.len( TokenReader.g_sFileData ) ) then
                        return;
                    end
                    
                    ch = string.sub( TokenReader.g_sFileData, TokenReader.g_iReaderPos, TokenReader.g_iReaderPos );
                    TokenReader.g_iReaderPos = TokenReader.g_iReaderPos + 1;
                end
                
                ch = string.sub( TokenReader.g_sFileData, TokenReader.g_iReaderPos, TokenReader.g_iReaderPos );
                TokenReader.g_iReaderPos = TokenReader.g_iReaderPos + 1;
                    
                if( ch == " " or ch == "\t" or ch == "\r" or ch == "\0" or ch == "\n" ) then
                    bContinue = true;
                end
            end
        end
        
        if( not bContinue ) then
            -- Worthy, put back.
            TokenReader.g_iReaderPos = TokenReader.g_iReaderPos - 1;
            return;
        end
    end
end

function TokenReader:IsAlpha( ch )
    local chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    if( string.find( chars, ch ) ~= nil ) then
        return true;
    end
    return false;
end

function TokenReader:IsDigit( ch )
    local digits = "0123456789";
    if( string.find( digits, ch ) ~= nil ) then
        return true;
    end
    return false;
end

function TokenReader:GetString( )
    if( TokenReader.g_iReaderPos >= string.len( TokenReader.g_sFileData ) ) then
        return nil;
    end
    
    local ch = string.sub( TokenReader.g_sFileData, TokenReader.g_iReaderPos, TokenReader.g_iReaderPos );
    TokenReader.g_iReaderPos = TokenReader.g_iReaderPos + 1;
    
    local buffer = "";
    
    while( ch ~= "\"" ) do
        buffer = buffer .. ch;
        
        prevchar = ch;
        
        ch = string.sub( TokenReader.g_sFileData, TokenReader.g_iReaderPos, TokenReader.g_iReaderPos );
        TokenReader.g_iReaderPos = TokenReader.g_iReaderPos + 1;
        
        if( TokenReader.g_iReaderPos >= string.len( TokenReader.g_sFileData ) ) then
            return buffer;
        end
    end
    
    return buffer;
end

function TokenReader:ReadToken( )
    TokenReader:SkipWhiteSpace();
    
    local ch = string.sub( TokenReader.g_sFileData, TokenReader.g_iReaderPos, TokenReader.g_iReaderPos );
    TokenReader.g_iReaderPos = TokenReader.g_iReaderPos + 1;
     
    if( TokenReader.g_iReaderPos >= string.len( TokenReader.g_sFileData ) ) then
        return TokenReader.TOKENEOF, nil;
    end
    
    local operators = "@,!+&*$.=:[](){}\\";
    if( string.find( operators, ch ) ~= nil ) then
        return TokenReader.OPERATOR, ch;
    end
    
    if( ch == "\"" ) then
        return TokenReader.TSTRING, TokenReader:GetString();
    end
    
    local buffer = "";
    if( TokenReader:IsDigit(ch) or ch == "-" ) then
        while( TokenReader:IsDigit(ch) ) do
            
            buffer = buffer .. ch;
        
            ch = string.sub( TokenReader.g_sFileData, TokenReader.g_iReaderPos, TokenReader.g_iReaderPos );
            TokenReader.g_iReaderPos = TokenReader.g_iReaderPos + 1;
            
            if( ch == "-" ) then
                return TokenReader.TOKENERROR, nil;
            end
        end
        
        if( TokenReader:IsAlpha(ch) or ch == "_" ) then
            return TokenReader.TOKENERROR, nil;
        end
        
        TokenReader.g_iReaderPos = TokenReader.g_iReaderPos - 1;
        return TokenReader.INTEGER, buffer;
    end
    
    buffer = "";
    while( TokenReader:IsAlpha(ch) or TokenReader:IsDigit(ch) or ch == "_" ) do
        buffer = buffer .. ch;
        
        ch = string.sub( TokenReader.g_sFileData, TokenReader.g_iReaderPos, TokenReader.g_iReaderPos );
        TokenReader.g_iReaderPos = TokenReader.g_iReaderPos + 1;
        
        if( TokenReader.g_iReaderPos >= string.len(TokenReader.g_sFileData) ) then
            return TokenReader.IDENT, buffer;
        end
    end
    
    TokenReader.g_iReaderPos = TokenReader.g_iReaderPos - 1;
    return TokenReader.IDENT, buffer;
end
