-- VMF Loader Admin System
----------------------------------------
Admin = {};

-- Admins.
Admin.Admins = {};

-- Add admin.
function Admin:Add( steamid, access )
    local tAdmin = {};
    tAdmin.steamid = steamid;
    tAdmin.access = access;
    table.insert( Admin.Admins, tAdmin );
end

-- Check access.
function Admin:CheckAccess( player, access )
    -- If admin is disabled, then everything passes.
    if( not Admin.Enabled ) then
        return true;
    end
    
    -- Player 1 on listen servers get admin.
    if( player == 1 and not _IsDedicatedServer() ) then
        return true;
    end
    
    -- Player 1 on single player gets admin.
    if( player == 1 and _MaxPlayers() == 1 ) then
        return true;
    end
    
    -- ULX Support.
    if( Admin.ULX ) then
        return hasAccess( player, access );
    else
        -- Check for access.
        local steamid = _PlayerInfo( player, "networkid" );
        for _, admin in Admin.Admins do
            if( string.lower( admin.steamid ) == string.lower( steamid ) ) then
                if( string.find( admin.access, access ) ~= nil ) then
                    return true;
                end
            end
        end
    end
    
    -- Catchall >:D NOoo!!!!
    return false;
end
