-- VMF Loader Commands.
--------------------------------------

-- Say commands.
--------------------------------------
VMFLoader.SayCommands = {};

-- VMFSayCommand object.
--------------------------------------
VMFSayCommand = {};

-- Create a new say cmd.
function VMFSayCommand:create( trigger )
    local obj = {};
    setmetatable( obj, self );
    self.__index = self;
    
    obj.trigger = trigger;
    
    return obj;
end

-- Say cmd execute.
function VMFSayCommand:execute( player, arguments )
    -- Virtual method.
end

-- Say cmd install.
function VMFSayCommand:install( )
    table.insert( VMFLoader.SayCommands, self );
end 

-- Handler.
function VMFLoader.SayCommandHandler( player, text, team )
    -- Get chat commands.
    local cmdargs = string.blowup( string.gsub( text, _PlayerInfo( player, "name" ) .. ": ", "" ), " " );
    local keyword = cmdargs[1];
    table.remove( cmdargs, 1 );
    
    -- Process.
    for _, cmd in VMFLoader.SayCommands do
        if( string.lower( "!" .. cmd.trigger ) == string.lower( keyword ) ) then
            cmd:execute( player, cmdargs );
        end
    end
end
HookEvent( "eventPlayerSay", VMFLoader.SayCommandHandler );

-- Load commands.
VMFLoader.CmdFiles = _file.Find( "lua/vmfloader/commands/*.lua" );
for _, file in VMFLoader.CmdFiles do
    _OpenScript( "vmfloader/commands/" .. file );
end
