gProps = {}
gUserProps = {}
gUserPropTimes = {}
gPropids = {}
gRestrictedProps = {}

function ulx_playerSpawnProp( userid, propname )
	if hasAccess( userid, ACCESS_PROP_PROTECT ) == true then -- If they have access to avoid this, let them spawn
		return true
	end
	
	propname = string.lower( propname )
	local steamid = _PlayerInfo( userid, "networkid" ) -- We'll track the users by steamid, not userid

	if gUserProps[ steamid ] == nil then -- They're new, set up their information
		gUserProps[ steamid ] = {}
		gUserPropTimes[ steamid ] = List.new()
		for i=1, tonumber( ulx_sv_antispamprops ) do
			List.pushright( gUserPropTimes[ steamid ], 0 )
		end
		gUserPropTimes[ steamid ].wait_till = nil
	end
	
	--debug( "antispamenabled=" .. ulx_sv_antispamenabled )
	if ulx_sv_antispamenabled == "1" then
		if gUserPropTimes[ steamid ].wait_till ~= nil then
			if _CurTime() > gUserPropTimes[ steamid ].wait_till then -- If it's over
				gUserPropTimes[ steamid ].wait_till = nil
			else
				ulx_tsay( userid, "Stop spamming!" )		
				return false
			end
		else
			local first = gUserPropTimes[ steamid ][ gUserPropTimes[ steamid ].first ]
			local last = gUserPropTimes[ steamid ][ gUserPropTimes[ steamid ].last ]
			if last - first < tonumber( ulx_sv_antispamtime ) and first + last > 0 then
				gUserPropTimes[ steamid ].wait_till = _CurTime() + tonumber( ulx_sv_antispamblocktime )
				ulx_tsay( userid, "You may not spawn more than " .. ulx_sv_antispamprops .. " props in " .. ulx_sv_antispamtime .. " seconds, blocked for the next " .. ulx_sv_antispamblocktime .. " seconds" )
				return false
			end
		end
	end
	
	if gRestrictedProps[ propname ] == nil then
		List.pushright( gUserPropTimes[ steamid ] , _CurTime() )
		List.popleft( gUserPropTimes[ steamid ] )
		return true -- They're allowed to spawn it
	end
	
	if gUserProps[ steamid ][ propname ] == nil then
		gUserProps[ steamid ][ propname ] = 0
	end
	
	if gUserProps[ steamid ][ propname ] < gRestrictedProps[ propname ] then -- If they've spawned less than the max
		gUserProps[ steamid ][ propname ] = gUserProps[ steamid ][ propname ] + 1
		gUserProps[ steamid ].next_prop = propname -- This helps us track the entids
		List.pushright( gUserPropTimes[ steamid ] , _CurTime() )
		List.popleft( gUserPropTimes[ steamid ] )		
		return true
	else
		ulx_tsay( userid, "You can only spawn " .. gRestrictedProps[ propname ] .. " copy of this prop!" )	
		return false
	end
end

function eventPlayerSpawnProp( userid, propname ) -- We want this to be able to be overridden.
	return ulx_playerSpawnProp( userid, propname )
end

function eventPlayerSpawnRagdoll( userid, propname )
	return ulx_playerSpawnProp( userid, propname )
end

function ulx_playerDuplicateProp( userid, propid )
	local steamid = _PlayerInfo( userid, "networkid" ) -- We'll track the users by steamid, not userid
	
	if gRestrictedProps[ string.lower( _EntGetModel( propid ) ) ] ~= nil and hasAccess( userid, ACCESS_PROP_PROTECT ) == false then
		ulx_tsay( userid, "Sorry, due to a security issue, you can't duplicate this prop." )
		return false
	else
		return true
	end
end

function eventPlayerDuplicateProp( userid, propid )
	return ulx_playerDuplicateProp( userid, propid )
end

function eventPlayerDuplicateRagdoll( userid, propid )
	return ulx_playerDuplicateProp( userid, propid )
end

function ulx_playerPropSpawned( userid, propid )
	gProps[ propid ] = { spawner=userid } -- This is for global use, gPropids is only for anti spam and prop protection
	
	if hasAccess( userid, ACCESS_PROP_PROTECT ) == true then -- Protect their prop if they have access
		gPropids[ propid ] = "protected"
		return
	end

	local steamid = _PlayerInfo( userid, "networkid" ) -- We'll track the users by steamid, not userid

	if gUserProps[ steamid ].next_prop == nil then -- If this isn't a prop we're looking out for, return
		return
	end
	
	gPropids[ propid ] = { spawner=steamid, prop_name=gUserProps[ steamid ].next_prop } -- Register this ID
	return
end

-- Here's where we can get the propid from the spawned prop
function eventPlayerPropSpawned( userid, propid )
	return ulx_playerPropSpawned( userid, propid )
end

function eventPlayerRagdollSpawned( userid, propid )
	return ulx_playerPropSpawned( userid, propid )
end

function ulx_playerRemove( userid, propid )	
	if gPropids[ propid ] == nil then -- Not one we're concerned about
		gProps[ propid ] = nil
		return true
	elseif gPropids[ propid ] == "protected" then -- If this is protected
		if hasAccess( userid, ACCESS_PROP_PROTECT ) == true then
			gPropids[ propid ] = nil -- It's no longer, the id will be recycled
			gProps[ propid ] = nil
			return true	
		else
			ulx_tsay( userid, "This prop is protected, you may not delete it!" )
			return false
		end
	end
	
	local steamid = _PlayerInfo( userid, "networkid" ) -- We'll track the users by steamid, not userid
	
	gUserProps[ gPropids[ propid ].spawner ][ gPropids[ propid ].prop_name ] = gUserProps[ gPropids[ propid ].spawner ][ gPropids[ propid ].prop_name ] - 1 -- Decrement their ( original spawner ) count by one
	gPropids[ propid ] = nil -- It's no longer, the id will be recycled
	gProps[ propid ] = nil
	return true
end

function onPlayerRemove( userid, propid )
	return ulx_playerRemove( userid, propid )
end

function ulx_playerMoveProp( userid, propid )
	if gPropids[ propid ] == nil then -- Not one we're concerned about
		return true
	end

	if gPropids[ propid ] ~= "protected" then
		return true
	end
	
	if hasAccess( userid, ACCESS_PROP_PROTECT ) == true then
		return true	
	else
		ulx_tsay( userid, "This prop is protected, you may not move it!" )
		return false
	end
end

function onGravGunPunt( userid, propid )
	return ulx_playerMoveProp( userid, propid )
end

function onGravGunPickup( userid, propid )
	return ulx_playerMoveProp( userid, propid )
end

function onPhysPickup( userid, propid )
	return ulx_playerMoveProp( userid, propid )
end

function onPhysFreeze( userid, propid )
	return ulx_playerMoveProp( userid, propid )
end

function addRestrictedProp( model, max )
	-- Add error checking here?
	gRestrictedProps[ string.lower( model ) ] = max
end


-- Add props to our restricted list ( USE LINUX DIRECTORY NOTATION '/' AND NOT WINDOWS NOTATION '\' )
-- addRestrictedProp( model, max_copies_allowed )
-- Please note that this will disable duplication of these models due to security issues

addRestrictedProp( "models/props_animated_breakable/smokestack.mdl", 0 ) --Completely block this
addRestrictedProp( "models/props_docks/prefab_piling01a.mdl", 0 )
addRestrictedProp( "models/props_wasteland/cargo_container01.mdl", 1 )
addRestrictedProp( "models/props_wasteland/cargo_container01b.mdl", 1 )
addRestrictedProp( "models/props_wasteland/cargo_container01c.mdl", 1 )
addRestrictedProp( "models/props_c17/TrapPropeller_Blade.mdl", 1 )
addRestrictedProp( "models/props_combine/combine_train02a.mdl", 1 )
addRestrictedProp( "models/props_combine/combine_train02b.mdl", 1 )
addRestrictedProp( "models/props_combine/CombineTrain01a.mdl", 1 )
addRestrictedProp( "models/props_trainstation/train001.mdl", 1 )
addRestrictedProp( "models/props_trainstation/train002.mdl", 1 )
addRestrictedProp( "models/props_trainstation/train003.mdl", 1 )
addRestrictedProp( "models/props_trainstation/train005.mdl", 1 )
addRestrictedProp( "models/props_trainstation/train004.mdl", 1 )
addRestrictedProp( "models/props_combine/stasisfield.mdl", 1 )
addRestrictedProp( "models/props_combine/strut_array_01.mdl", 1 )
addRestrictedProp( "models/Cranes/crane_docks.mdl", 1 )
addRestrictedProp( "models/props_c17/statue_horse.mdl", 1 )

