WEAPON_MENU_ENABLED = false

-------------
--Main Menu--
-------------
ID_CLIENTMENU	=	1
ID_ADMINMENU	=	2
ID_MAPSMENU		=	3
ID_WEAPONSMENU	=	4

function cc_ulxMenu( userid, args )
	beginMenu( userid, "ULX Main Menu", cc_ulxMenuFinal )
		addOption( userid, "Client Menu", ID_CLIENTMENU, ACCESS_SLAY )	
		addOption( userid, "Admin Menu", ID_ADMINMENU, ACCESS_CVAR )
		addOption( userid, "Maps Menu", ID_MAPSMENU, ACCESS_MAP )
		if WEAPON_MENU_ENABLED then
		addOption( userid, "Weapons Menu", ID_WEAPONSMENU, ACCESS_KICK )
		end
	endMenu( userid )
end

function cc_ulxMenuFinal( userid, choice, seconds )
	if choice == ID_EXIT then
		return
	elseif choice == ID_CLIENTMENU then
		cc_ulxClientMenu( userid )
	elseif choice == ID_ADMINMENU then
		cc_ulxAdminMenu( userid )
	elseif choice == ID_MAPSMENU then
		cc_ulxMapsMenu( userid )
	elseif choice == ID_WEAPONSMENU then
		cc_ulxWeaponsMenu( userid )
	end
end

ULX_CONCOMMAND( "ulx_menu", cc_ulxMenu, _, "- Shows the ULX main menu", 0, "menu", false )


--------------
--Admin Menu--
--------------
function cc_ulxAdminMenu( userid, args )
	beginMenu( userid, "ULX Admin Menu", cc_ulxAdminMenuFinal )

		if _GetConVar_Bool( "sv_cheats" ) then
			addOption( userid, "Cheats Off", "sv_cheats 0", ACCESS_CVAR )	
		else
			addOption( userid, "Cheats On", "sv_cheats 1", ACCESS_CVAR )	
		end
			
		if _GetConVar_Bool( "gm_sv_playerdamage" ) then
			addOption( userid, "Player Damage Off", "gm_sv_playerdamage 0", ACCESS_CVAR )	
		else
			addOption( userid, "Player Damage On", "gm_sv_playerdamage 1", ACCESS_CVAR )	
		end
		
		if _GetConVar_Bool( "gm_sv_pvpdamage" ) then
			addOption( userid, "PvP Damage Off", "gm_sv_pvpdamage 0", ACCESS_CVAR )	
		else
			addOption( userid, "PvP Damage On", "gm_sv_pvpdamage 1", ACCESS_CVAR )	
		end		
		
		if _GetConVar_Bool( "gm_sv_teamdamage" ) then
			addOption( userid, "Team Damage Off", "gm_sv_teamdamage 0", ACCESS_CVAR )	
		else
			addOption( userid, "Team Damage On", "gm_sv_teamdamage 1", ACCESS_CVAR )	
		end			
		
		if _GetConVar_Bool( "gm_sv_allowspawning" ) then
			addOption( userid, "Disallow Spawning", "gm_sv_allowspawning 0", ACCESS_CVAR )	
		else
			addOption( userid, "Allow Spawning", "gm_sv_allowspawning 1", ACCESS_CVAR )	
		end
		
		if _GetConVar_Bool( "gm_sv_allowmultigun" ) then
			addOption( userid, "Disallow Multigun", "gm_sv_allowmultigun 0", ACCESS_CVAR )	
		else
			addOption( userid, "Allow Multigun", "gm_sv_allowmultigun 1", ACCESS_CVAR )	
		end				
		
		if _GetConVar_Bool( "gm_sv_allowphysgun" ) then
			addOption( userid, "Disallow Physgun", "gm_sv_allowphysgun 0", ACCESS_CVAR )	
		else
			addOption( userid, "Allow Physgun", "gm_sv_allowphysgun 1", ACCESS_CVAR )	
		end	
		
		if _GetConVar_Bool( "gm_sv_allweapons" ) then
			addOption( userid, "All Weapons Off", "gm_sv_allweapons 0", ACCESS_CVAR )	
		else
			addOption( userid, "All Weapons On", "gm_sv_allweapons 1", ACCESS_CVAR )	
		end	
		
		if _GetConVar_Bool( "gm_sv_allowignite" ) then
			addOption( userid, "Disallow Ignite", "gm_sv_allowignite 0", ACCESS_CVAR )	
		else
			addOption( userid, "Allow Ignite", "gm_sv_allowignite 1", ACCESS_CVAR )	
		end	
		
		if _GetConVar_Bool( "gm_sv_noclip" ) then
			addOption( userid, "Disallow Noclip", "gm_sv_noclip 0", ACCESS_CVAR )	
		else
			addOption( userid, "Allow Noclip", "gm_sv_noclip 1", ACCESS_CVAR )	
		end
		
		if _GetConVar_Bool( "gm_sv_allownpc" ) then
			addOption( userid, "Disallow NPC Spawning", "gm_sv_allownpc 0", ACCESS_CVAR )	
		else
			addOption( userid, "Allow NPC Spawning", "gm_sv_allownpc 1", ACCESS_CVAR )	
		end	
		
		if _GetConVar_Bool( "gm_sv_allowlamps" ) then
			addOption( userid, "Disallow Lamps", "gm_sv_allowlamps 0", ACCESS_CVAR )	
		else
			addOption( userid, "Allow Lamps", "gm_sv_allowlamps 1", ACCESS_CVAR )	
		end			
	endMenu( userid )
end

function cc_ulxAdminMenuFinal( userid, choice, seconds )
	if choice == ID_EXIT then
		return
	else
		_ServerCommand( choice .. ";gm_sv_setrules\n" )
	end
	
	AddTimer( 0.25, 1, cc_ulxAdminMenu, userid ) -- Give the server some time to register the command before rebuilding menu
end

ULX_CONCOMMAND( "ulx_adminmenu", cc_ulxAdminMenu, ACCESS_CVAR, "- Shows the ULX admin menu", 0, "adminmenu", false )


---------------
--Client Menu--
---------------
user_choice 	=	{}
ID_SLAP			=	1
ID_SLAY			=	2
ID_SSLAY		=	3
ID_FREEZE		=	4
ID_UNFREEZE		=	5
ID_GOD			=	6
ID_UNGOD		=	7
ID_IGNITE		=	8
ID_KICK			=	9
ID_KICKBAN		=	10
ID_TEAM_RED		=	11
ID_TEAM_GREEN	=	12
ID_TEAM_BLUE	=	13
ID_TEAM_YELLOW	=	14
ID_GIMP			=	15
ID_UNGIMP		=	16

function cc_ulxClientMenu( userid, args )
	menu_sendPlayersMenu( userid, cc_ulxClientMenuPart2 )
end

function cc_ulxClientMenuPart2( userid, target, seconds )
	if target == ID_EXIT then
		return
	end
	
	user_choice[ userid ] = target
	beginMenu( userid, "ULX Command", cc_ulxClientMenuFinal )
		addOption( userid, "Slap Player", ID_SLAP, ACCESS_SLAY )
		addOption( userid, "Slay Player", ID_SLAY, ACCESS_SLAY )
		addOption( userid, "SSlay Player", ID_SSLAY, ACCESS_SLAY )
		addOption( userid, "Kick Player", ID_KICK, ACCESS_KICK )
		addOption( userid, "Kickban Player", ID_KICKBAN, ACCESS_BAN )		
		addOption( userid, "Give Godmode", ID_GOD, ACCESS_SLAY )
		addOption( userid, "Remove Godmode", ID_UNGOD, ACCESS_SLAY )				
		addOption( userid, "Freeze Player", ID_FREEZE, ACCESS_SLAY )
		addOption( userid, "Unfreeze Player", ID_UNFREEZE, ACCESS_SLAY )
		addOption( userid, "Ignite Player", ID_IGNITE, ACCESS_SLAY )
		addOption( userid, "Force Team Red", ID_TEAM_RED, ACCESS_SLAY )
		addOption( userid, "Force Team Blue", ID_TEAM_BLUE, ACCESS_SLAY )		
		addOption( userid, "Force Team Green", ID_TEAM_GREEN, ACCESS_SLAY )
		addOption( userid, "Force Team Yellow", ID_TEAM_YELLOW, ACCESS_SLAY )				
		addOption( userid, "Gimp", ID_GIMP, ACCESS_SLAY )
		addOption( userid, "Ungimp", ID_UNGIMP, ACCESS_SLAY )						
	endMenu( userid )
end

function cc_ulxClientMenuFinal( userid, choice, seconds )
	local target = user_choice[ userid ]
	if target == nil or _PlayerInfo( target, "connected" ) == false then
		return
	end
	
	if choice == ID_EXIT then -- This is a global for when they hit the exit button, just take them back
		cc_ulxClientMenu( userid, _ )
		return
	elseif choice == ID_SLAP then
		ulx_slap( target, 0, 1000 )
	elseif choice == ID_SLAY then
		_PlayerKill( target )
	elseif choice == ID_SSLAY then
		_PlayerSilentKill( target, 3, true )
	elseif choice == ID_GOD then
		_PlayerGod( target, true )
	elseif choice == ID_UNGOD then
		_PlayerGod( target, false )				
	elseif choice == ID_FREEZE then
		_PlayerFreeze( target, true )
	elseif choice == ID_UNFREEZE then
		_PlayerFreeze( target, false )
	elseif choice == ID_IGNITE then
		_PlayerSetHealth( target, 139 ) -- This is so the person doesn't keep dying in the next spawn
		_EntFire( target, "ignite", 1, 0 )
	elseif choice == ID_KICK then
		_ServerCommand( "kickid " .. _PlayerInfo( target, "networkid" ) .. "\n" )
	elseif choice == ID_KICKBAN then
		_ServerCommand( "banid 0 " .. _PlayerInfo( target, "networkid" ) .. " kick;writeid\n" )
	elseif choice == ID_TEAM_RED then
		_PlayerChangeTeam( target, TEAM_RED )		
		_PlayerRespawn( target )
	elseif choice == ID_TEAM_GREEN then
		_PlayerChangeTeam( target, TEAM_GREEN )		
		_PlayerRespawn( target )
	elseif choice == ID_TEAM_BLUE then
		_PlayerChangeTeam( target, TEAM_BLUE )		
		_PlayerRespawn( target )
	elseif choice == ID_TEAM_YELLOW then
		_PlayerChangeTeam( target, TEAM_YELLOW )
		_PlayerRespawn( target )
	elseif choice == ID_GIMP then
		ulx_gimp( _PlayerInfo( target, "networkid" ) )
	elseif choice == ID_UNGIMP then
		ulx_ungimp( _PlayerInfo( target, "networkid" ) )
	end
		
end

function testCallBack( userid, unique_num, seconds )
	ulx_tsay_all( _PlayerInfo( userid, "name" ) .. " choose menu ID #" .. unique_num .. "!" )
end

ULX_CONCOMMAND( "ulx_clientmenu", cc_ulxClientMenu, ACCESS_SLAY, "- Shows the client admin menu", 0, "clientmenu", false )

-------------
--Maps Menu--
-------------

local gMaps = getFilesFromDir( "maps" )
i = table.getn( gMaps )
c = 1
while c <= i do
	if string.sub( gMaps[ c ], -4 ) == ".bsp" then
		gMaps[ c ] = string.sub( gMaps[ c ], 1, -5 )
		c = c + 1
	else
		table.remove( gMaps, c )
		i = i - 1
	end
end
i = nil
c = nil

function sendMapMenu( userid )
	if hasAccess( userid, ACCESS_MAP ) == false then
		return
	end
	
	for i=1, table.getn( gMaps ) do
		_spawnmenu.AddItem( userid, "Changelevel", "+" .. gMaps[ i ], "ulx_map " .. gMaps[ i ] )
	end
end

HookEvent( "eventPlayerInitialSpawn", sendMapMenu )

----------------
--Weapons Menu--
----------------

-- TODO: Finish this whole section!

if WEAPON_MENU_ENABLED then

function getWeaponInfo( weapon ) -- TODO: Finish this function
	if _file.Exists( "lua/" .. weapon ) == false or _file.IsDir( "lua/" .. weapon ) == true then
		error_msg( "loadWeaponInfo given an invalid file!" )
		return
	end
	
	_OpenScript( weapon )
	
	local info = {}
	
	info.printName				=	getPrintName()
	info.classname				=	getClassName()
	info.swapHands				=	getWeaponSwapHands()
	info.fov					=	getWeaponFOV()
	info.weaponSlot				=	getWeaponSlot()
	info.weaponSlotPos			=	getWeaponSlotPos()
	info.firesUnderwater		=	getFiresUnderwater()	
	info.reloadsSingly			=	getReloadsSingly()
	info.damage					=	getDamage()
	info.primaryShotDelay		=	getPrimaryShotDelay()
	info.secondaryShotDelay		=	getSecondaryShotDelay()
	info.primaryIsAutomatic		=	getPrimaryIsAutomatic()
	
	return info
end

gIgnoreWeapons = {}

function addWeaponIgnore( weapon )
	gIgnoreWeapons[ weapon ] = true
end

addWeaponIgnore( "weapons/base.lua" )
addWeaponIgnore( "weapons/moocow_guns.lua" )
addWeaponIgnore( "weapons/build/weapon_cratemaker.lua" )
addWeaponIgnore( "weapons/build/weapon_propmaker.lua" )
addWeaponIgnore( "weapons/build/weapon_freeze.lua" )
addWeaponIgnore( "weapons/build/weapon_remover.lua" )
addWeaponIgnore( "weapons/build/weapon_spawn.lua" )
addWeaponIgnore( "weapons/football/weapon_phys.lua" )
addWeaponIgnore( "weapons/hideandseek/weapon_catcher.lua" )

user_choice = {}

gWeapons = getFilesFromDirRecursive( "lua/weapons" )
i = table.getn( gWeapons )
c = 1
while c <= i do
	--debug( gWeapons[ c ] )
	gWeapons[ c ] = string.sub( gWeapons[ c ], 5 ) -- The sub removes 'lua/'
	if string.sub( gWeapons[ c ], -4 ) == ".lua" and gIgnoreWeapons[ gWeapons[ c ] ] == nil then
		local weapon = getWeaponInfo( gWeapons[ c ] )
		if weapon ~= nil and weapon.printName ~= nil then
			gWeapons[ c ] = { loc=gWeapons[ c ], name=weapon.printName }
			--debug( "valid weap" )
			c = c + 1
		else
			table.remove( gWeapons, c )
			i = i - 1 
			--debug( "invalid weap" )
		end
	else
		table.remove( gWeapons, c )
		i = i - 1
		--debug( "invalid weap" )		
	end
end
i = nil
c = nil

function cc_ulxWeaponsMenu( userid, args )
	beginMenu( userid, "Weapons Menu", cc_ulxWeaponsMenuCallback )
		for i=1, table.getn( gWeapons ) do
			addOption( userid, gWeapons[ i ].name, gWeapons[ i ].loc, ACCESS_KICK )
		end
	endMenu( userid )	
end

function cc_ulxWeaponsMenuCallback( userid, weapon )
	if weapon == ID_EXIT then
		return
	end
	
	user_choice[ userid ] = weapon
	menu_sendPlayersMenu( userid, cc_ulxWeaponsMenuFinal, _, "Give to:", true )
end

function cc_ulxWeaponsMenuFinal( userid, target )
	if target == ID_EXIT then
		return
	end
	
	if target == 0 then
		for i=1, _MaxPlayers() do
			debug( target .. " " .. i )
			if _PlayerInfo( i, "connected" ) == true then
				_PlayerGiveSWEP( i, user_choice[ userid ] )
			end
		end
	else
		_PlayerGiveSWEP( target, user_choice[ userid ] )
	end
end

ULX_CONCOMMAND( "ulx_weaponmenu", cc_ulxWeaponsMenu, ACCESS_KICK, "- Shows the weapons menu", 0, "weaponmenu", false )

end
