-- cc_ulxSlay - responds to ulx_slay <user>, slays the specified user
function cc_ulxSlay( userid, args, argv, argc )
	local target = getUser( userid, argv[ 1 ] )
	if target == nil then
		return
	end
	
	_PlayerKill( target )
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " slayed player " .. ulx_playerString( target ) )
end

ULX_CONCOMMAND( "ulx_slay", cc_ulxSlay, ACCESS_SLAY, "<user> - slays the specified user", 1, "slay" )

-- cc_ulxSSlay - responds to ulx_sslay <user> [<respawn time> [<bool disolve]], slays the specified user
function cc_ulxSSlay( userid, args, argv, argc )	
	local target = getUser( userid, argv[ 1 ] )
	if target == nil then
		return
	end
	
	local respawn_time = 3
	local dissolve = true
	
	if argv[ 2 ] ~= nil then -- if they specified respawn time
		local num = tonumber( argv[ 2 ] )
		if num ~= nil then
			respawn_time = num
		end
	end
	
	if argv[ 3 ] ~= nil then -- if they specified dissolve
		local num = tonumber( argv[ 3 ] )
		if num ~= nil then
			if num == 0 then
				dissolve = false
			else
				dissolve = true
			end
		else  --It must be a boolean, so just assign it as such
			if argv[ 3 ] == "true" then
				dissolve = true
			else
				dissolve = false
			end
		end
	end
	
	_PlayerSilentKill( target, respawn_time, dissolve )
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " sslayed player " .. ulx_playerString( target ) )
end

ULX_CONCOMMAND( "ulx_sslay", cc_ulxSSlay, ACCESS_SLAY, "<user> [<respawn time> [<bool disolve]] - silently slays the specified user", 1, "sslay" )

-- cc_ulxSlay - responds to ulx_slap <user> [<damage>], slaps the specified user with optional damage
function cc_ulxSlap( userid, args, argv, argc )
	local target = getUser( userid, argv[ 1 ] )
	if target == nil then
		return
	end	
	
	local damage = tonumber( argv[ 2 ] ) or 0 -- Either there's a paramater or set it to 0
	
	ulx_slap( target, damage, 1000 )
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " slapped player " .. ulx_playerString( target ) )
end

ULX_CONCOMMAND( "ulx_slap", cc_ulxSlap, ACCESS_SLAY, "<user> [<damage>] - slaps the specified user with optional damage", 1, "slap" )

-- cc_ulxIgnite - responds to ulx_ignite <user>, ignites the specified user
function cc_ulxIgnite( userid, args, argv, argc )
	local target = getUser( userid, argv[ 1 ] )
	if target == nil then
		return
	end
	
	_PlayerSetHealth( target, 139 ) -- This is so the person doesn't keep dying in the next spawn
	_EntFire( target, "ignite", 1, 0 ) -- ent_fire an entity. Syntax <entid> <action> <value> <delay> 
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " ignited player " .. ulx_playerString( target ) )
end

ULX_CONCOMMAND( "ulx_ignite", cc_ulxIgnite, ACCESS_SLAY, "<user> - ignites the specified user ( death by fire )", 1, "ignite" )

-- cc_ulxFreeze - responds to ulx_freeze <user>
function cc_ulxFreeze( userid, args, argv, argc )
	local target = getUser( userid, argv[ 1 ] )
	if target == nil then
		return
	end
	
	_PlayerFreeze( target, true )
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " froze player " .. ulx_playerString( target ) )	
end

ULX_CONCOMMAND( "ulx_freeze", cc_ulxFreeze, ACCESS_SLAY, "<user> - freezes the specified player ( unable to move or aim )", 1, "freeze" )

-- cc_ulxUnfreeze - responds to ulx_unfreeze <user>
function cc_ulxUnfreeze( userid, args, argv, argc )
	local target = getUser( userid, argv[ 1 ] )
	if target == nil then
		return
	end
	
	_PlayerFreeze( target, false )
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " unfroze player " .. ulx_playerString( target ) )
end

ULX_CONCOMMAND( "ulx_unfreeze", cc_ulxUnfreeze, ACCESS_SLAY, "<user> - unfreezes the specified player", 1, "unfreeze" )

-- cc_ulxGod
function cc_ulxGod( userid, args, argv, argc )
	local target = getUser( userid, argv[ 1 ], false )
	if target == nil then
		return
	end
	
	_PlayerGod( target, true )
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " gave God to player " .. ulx_playerString( target ) )
end

ULX_CONCOMMAND( "ulx_god", cc_ulxGod, ACCESS_SLAY, "<user> - Gives the specified player God mod", 1, "god" )

-- cc_ulxUngod
function cc_ulxUngod( userid, args, argv, argc )
	local target = getUser( userid, argv[ 1 ], false )
	if target == nil then
		return
	end
	
	_PlayerGod( target, false )
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " took God off player " .. ulx_playerString( target ) )
end

ULX_CONCOMMAND( "ulx_ungod", cc_ulxUngod, ACCESS_SLAY, "<user> - Removes God mode from the specified player", 1, "ungod" )

-- cc_ulxSetinfo
function cc_ulxSetinfo( userid, args, argv, argc )
	local setinfos = {}
	if _file.Exists( "lua/ulx/configs/setinfo.dat" ) == true then
		setinfos = loadTable( "ulx/configs/setinfo.dat" )
	end
	
	setinfos[ _PlayerInfo( userid, "networkid" ) ] = args
	if args == "*" then
		setinfos[ _PlayerInfo( userid, "networkid" ) ] = nil
	end
	saveTable( setinfos, "ulx/configs/setinfo.dat", "These are your admin setinfos, this text will be displayed when they join" )
end

ULX_CONCOMMAND( "ulx_setinfo", cc_ulxSetinfo, ACCESS_CHAT, "<message> - Server will display this text when you join, use \"*\" to clear.", 1, "!setinfo" )

function setinfoMessage( name, userid, steamid )
	if _file.Exists( "lua/ulx/configs/setinfo.dat" ) == false then
		return
	end
	
	local setinfos = loadTable( "ulx/configs/setinfo.dat" )
	if setinfos[ steamid ] ~= nil then
		ulx_tsay_all_parse( "[%playername%] " .. setinfos[ steamid ] )
	end
end

HookEvent( "eventPlayerActive", setinfoMessage )

-- cc_ulxHp
function cc_ulxHp( userid, args, argv, argc )
	local target = getUser( userid, argv[ 1 ] )
	if target == nil then
		return
	end
	
	local num = tonumber( argv[ 2 ] )
	if num == nil then
		return
	end
	
	_PlayerSetHealth( target, num )
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " changed player " .. ulx_playerString( target ) .. "'s hp to " .. num )
end

ULX_CONCOMMAND( "ulx_hp", cc_ulxHp, ACCESS_SLAY, "<user> <number> - sets the player health to the specified value", 2, "hp" )

-- cc_ulxPlaysound
function cc_ulxPlaysound( userid, args, argv, argc )
	if _file.Exists( "sound/" .. argv[ 1 ] ) == false then
		ulx_console( userid, "That sound doesn't exist on the server!" )
		return
	end
	
	_PlaySound( argv[ 1 ] )
end

ULX_CONCOMMAND( "ulx_playsound", cc_ulxPlaysound, ACCESS_CHAT, "<sound file> - Plays a sound ( relative to 'sound' dir )", 1 )

gimps = {}
sayText = ""
gss = 1

function ulx_gimp( steamid )
	gimps[steamid] = true
end

function ulx_ungimp( steamid )
	gimps[steamid] = nil
end

function GimpSay()
	gstr = table.getn(gimp_say) 
	gss = math.random( 1, gstr )
	return gimp_say[gss];
end

function gimpCallback( userid, strText )
	if isGimped( userid ) then
		local player_name = _PlayerInfo( userid, "name" )
		local sayText = GimpSay()
		return player_name .. ": " .. sayText
	else
		return strText
	end
end

function isGimped( userid )
	local steamid = _PlayerInfo( userid, "networkid" )
	if ( gimps[steamid] == true ) then
		return true;
	else 
		return false;
	end
end

addMessageHook( gimpCallback )

-- Gimp Messages --
gimp_say = {}
table.insert( gimp_say, "Liek Oh, mai, GAWD!!! taht is soooo seks3!" )
table.insert( gimp_say, "ohh, ahhh, oohhh, ahhhhhh" )
table.insert( gimp_say, "I like to be a mingebag" )
table.insert( gimp_say, "" )

function cc_ulxGimp( userid, args, argv, argc )
	local target = getUser( userid, argv[ 1 ] )
	if target == nil then
		return
	end
		
	ulx_gimp( _PlayerInfo( target, "networkid" ) )
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " gimped player " .. ulx_playerString( target ) )	
end

ULX_CONCOMMAND( "ulx_gimp", cc_ulxGimp, ACCESS_SLAY, "<user> - gimps the specified player", 1, "gimp" )

function cc_ulxUngimp( userid, args, argv, argc )
	local target = getUser( userid, argv[ 1 ] )
	if target == nil then
		return
	end
		
	ulx_ungimp( _PlayerInfo( target, "networkid" ) )
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " ungimped player " .. ulx_playerString( target ) )		
end

ULX_CONCOMMAND( "ulx_ungimp", cc_ulxUngimp, ACCESS_SLAY, "<user> - ungimps the specified player", 1, "ungimp" )
