
-- Menu size options, feel free to edit if you want to move it around!
gRectKey	=	0
gRectBegX	= 	0.03
gRectBegY	=	0.3
gRectSizeX	=	0.32
gRectSizeY	=	0.32
gRectEndX	=	gRectBegX + gRectSizeX
gRectEndY	=	gRectBegY + gRectSizeY

-- Title placement
gTitleKey	=	0
gTitleX		=	function( menu ) return (gRectBegX + gRectEndX)/2 - string.len( menu.title )/170 end  -- This should get it somewhat centered
gTitleY		=	gRectBegY + 0.015
gTitleFont	=	"CloseCaption_Bold"

-- Misc
gMenus 			=	{} 			-- Keep track of all the menus
gCurKey			=	{}			-- Keep track of the last text key used, per userid
gCurRectKey		=	{}			-- Keep track of the last rect key used, per userid
gVoteTally		=	{}			-- Tally's the current vote
gPlayersMenus 	= 	{} 			-- Keep track of player menus ( menus that list players ) so we can return the result
gTimeout		= 	30 			-- How long it takes for the menu to time out
gDefaultFont	=	"ChatFont"	-- Default font for the options in the menu
gTextYStep		=	0.02 		-- This is the vertical step between each line
gMaxOptions		=	8 			-- 890 are not bound to slot* ( note that this does not include back and exit )
ID_EXIT			=	-1			-- This is what will be returned to the callback function when exit is pressed
ID_NONE			=	-1			-- This is what will be returned to the voting callback function when no option won ( either no one voted or no one could vote )

---------------------------------------------------------
-- DO NOT EDIT BELOW UNLESS YOU KNOW WHAT YOU'RE DOING!--
---------------------------------------------------------

for i=1, 32 do
	gCurKey[ i ] = 0
	gCurRectKey[ i ] = 1
end

-- add_option, adds an option to a menu for display. choice_num is what will be returned to you if they make a choice, so make sure it's unique!
function addOption( userid, txt, choice_num, access, text_font )
	text_font = text_font or gDefaultFont
	
	if access ~= nil and hasAccess( userid, access ) == false then
		return
	end
	
	if txt == nil or choice_num == nil then
		return
	end
	
	local menu = gMenus[ userid ]
	
	table.insert( menu.options, { text=txt, num=choice_num } )
end

function showText( userid, begX, begY, endX, endY, red, green, blue, txt, text_font )
	local menu = gMenus[ userid ]
	
	gCurKey[ userid ] = gCurKey[ userid ] + 1
	if gCurKey[ userid ] > gMaxOptions * 2 + 6 then -- Shouldn't be anymore than two menus blending in animation ( the extra six is from the title, next, and back text )
		gCurKey[ userid ] = 1
	end
	
	table.insert( menu.curText, { key=gCurKey[ userid ], posy=endY, text=txt, r=red, b=blue, g=green, font=text_font } )
	
	sendTextAndAnimate( userid, gCurKey[ userid ], begX, begY, endX, endY, red, green, blue, txt, text_font, gTimeout, 0.5, 0.5, 0.5, 0.3 )
end

function beginMenu( userid, menu_title, fn_callback )
	if gMenus[ userid ] ~= nil then -- Make sure there's not already a menu up for this user
		menuFadeOut( userid )
	end
	
	gMenus[ userid ] = { callback=fn_callback, curText={}, curPage=1, title=menu_title, options={} }
end

function endMenu( userid )
	menuFadeIn( userid, 1 )
end

function menuFadeIn( userid, page_num )
	local menu = gMenus[ userid ]
	menu.curPage = page_num
	
	_PlayerOption( userid, "menuCallback", gTimeout ); --Continue binding their number keys until our timeout	
	
	sendRectAndAnimate( userid, gCurRectKey[ userid ], 0, gRectBegY, 0, gRectSizeY, 
		gRectBegX, gRectBegY, gRectSizeX, gRectSizeY, 0, 0, 0, 150, 
		"gmod/white", gTimeout, 0, 1.5, 0.5, 0.3 )
	
	-- Send the title
	showText( userid, 0, gRectBegY, gTitleX( menu ), gTitleY, 255, 200, 50, menu.title, gTitleFont );  -- Show the title of the menu, partially centered\

	-- Done with title, let's move on to the options
	local first = gMaxOptions * ( page_num - 1 ) -- Get our first item to display

	local curX = gRectBegX + 0.02
	local curY = gRectBegY + gTextYStep * 2.5
	
	local i -- This is so the variable 'i' will stay on this scope
	for i = 1, gMaxOptions do
		local v = menu.options[ first + i ] -- Get the next choice
		if v == nil then
			break
		end
		curY = curY + gTextYStep -- Newline
		showText( userid, 0, gRectBegY, curX, curY, 255, 255, 255, i .. ". " ..  v.text, "ChatFont" );
	end
	
	-- We're done with the user-defined options, let's send the next and back options
	curY = curY + gTextYStep * 2 -- Make a notable separation
	
	if first + gMaxOptions < table.getn( menu.options ) then -- Show the next button
		showText( userid, 0, gRectBegY, curX, curY, 255, 255, 255, gMaxOptions + 1 .. ". Next page", "ChatFont" );
		curY = curY + gTextYStep
	end
	
	if first < gMaxOptions then -- If we need to show 'exit'
		if gMaxOptions + 2 == 10 then
			showText( userid, 0, gRectBegY, curX, curY, 255, 255, 255, "0. Exit", "ChatFont" );
		else
			showText( userid, 0, gRectBegY, curX, curY, 255, 255, 255, gMaxOptions + 2 .. ". Exit", "ChatFont" );
		end
	else
		if gMaxOptions + 2 == 10 then	
			showText( userid, 0, gRectBegY, curX, curY, 255, 255, 255, "0. Previous page", "ChatFont" );
		else
			showText( userid, 0, gRectBegY, curX, curY, 255, 255, 255, gMaxOptions + 2 .. ". Previous page", "ChatFont" );
		end
	end
end

function menuFadeOut( userid )
	local menu = gMenus[ userid ]
	
	sendRectAnimate( userid, gCurRectKey[ userid ], gRectBegX, gRectBegY, gRectBegX, gRectSizeY, 0, 0, 0, 150, "gmod/white", 0.5, 0.3 )	
	_GModRect_Hide( userid, gCurRectKey[ userid ], 0.4, 0.1 );

	gCurRectKey[ userid ] = gCurRectKey[ userid ] + 1
	if gCurRectKey[ userid ] > 2 then -- Only two menus should be blending together
		gCurRectKey[ userid ] = 1
	end
	
	for _, v in ipairs( menu.curText ) do
		sendTextAnimate( userid, v.key, 0, v.posy, v.r, v.g, v.b, v.text_font, 0.5, 0.3 );
		_GModText_Hide( userid, v.key, 0.4, 0.1 );
	end
	
	menu.curText = {} -- Reset our current text, since we have none
end

function menuCallback( userid, num, seconds )
	local menu = gMenus[ userid ]
	if num  == 0 then
		num = 10 -- This lets us handle the menu correctly
	end
	
	local expanded_num = num + gMaxOptions * ( menu.curPage - 1 )
	
	if num == gMaxOptions + 1 and expanded_num - 1 < table.getn( menu.options ) then -- If it was a valid option to go forward a page, then go forward!
		menuFadeOut( userid )
		menuFadeIn( userid, menu.curPage + 1 )
		return
	end
	
	if num == gMaxOptions + 2 then
		menuFadeOut( userid )
		if expanded_num > gMaxOptions + 2 then -- If it was to move back
			menuFadeIn( userid, menu.curPage - 1 )
			return
		else -- If it was to exit
			menuFadeOut( userid )
			menu.callback( userid, ID_EXIT, seconds )
			return
		end
	end
	
	if expanded_num > table.getn( menu.options ) or num > gMaxOptions + 2 then -- If it wasn't a valid option
			_PlayerOption( userid, "menuCallback", gTimeout ); --Continue binding their number keys until our timeout
			return
	end
	
	menuFadeOut( userid )

	menu.callback( userid, menu.options[ expanded_num ].num, seconds )
end


--------------------
--Send Player Menu--
--------------------
function menu_sendPlayersMenu( userid, callback, access, title, show_all )	
	if userid == nil or _PlayerInfo( userid, "connected" ) == false or 
			callback == nil or type( callback ) ~= "function" then
		error_msg( "Incorrect usage of menu_sendPlayersMenu!" )
		return
	end
	title = title or "Choose a Player"
	
	beginMenu( userid, title, callback )
	
	if show_all ~= nil and show_all == true then
		addOption( userid, "All Players", 0 )
	end
	
	for i = 1, _MaxPlayers() do
		if _PlayerInfo( i, "connected" ) then
			if access == nil then
				addOption( userid, _PlayerInfo( i, "name" ), i )
			elseif hasAccess( i, access ) then -- If this player has the required access, show it!
				addOption( userid, _PlayerInfo( i, "name" ), i )
			end
		end
	end
	
	endMenu( userid )	
end

----------
--Voting--
----------
function menu_sendVote( callback_fn, access, title, ... )
	if callback_fn == nil or type( callback_fn ) ~= "function" then
		error_msg( "Incorrect usage of menu_sendVote!" )
		return
	end
	
	title = title or "Vote!"
	
	gVoteTally = { callback=callback_fn, votes=0, voters=0, exits=0 }
	for i=1, table.getn( arg ), 2 do -- Set up the tallys
		if arg[ i ] ~=nil and arg[ i + 1 ] ~= nil then
			gVoteTally[ arg[ i + 1 ] ] = { name=arg[ i ], num=0 } -- Set it up by the option ID's
		end
	end
	
	for i=1, _MaxPlayers() do
		if _PlayerInfo( i, "connected" ) and hasAccess( i, access ) then
			gVoteTally.voters = gVoteTally.voters + 1
			beginMenu( i, title, menu_sendVoteCallback )
			
			for c=1, table.getn( arg ), 2 do -- Set up options
				addOption( i, arg[ c ], arg[ c + 1 ] )
			end
			
			endMenu( i )
		end
	end
	
	AddTimer( gTimeout, 1, menu_voteFinish ) -- Finish up the vote
end

--Exactly the same as above, but takes a table instead of '...', makes it a bit easier for dynamic votes
function menu_sendVoteTable( callback_fn, access, title, txt_table, id_table )
	if callback_fn == nil or type( callback_fn ) ~= "function" then
		error_msg( "Incorrect usage of menu_sendVoteTable!" )
		return
	end
	
	title = title or "Vote!"
	
	gVoteTally = { callback=callback_fn, votes=0, voters=0, exits=0 }
	for i=1, table.getn( txt_table ) do -- Set up the tallys
		if txt_table[ i ] ~=nil and id_table[ i ] ~= nil then
			gVoteTally[ id_table[ i ] ] = { name=txt_table[ i ], num=0 } -- Set it up by the option ID's
		end
	end
	
	for i=1, _MaxPlayers() do
		if _PlayerInfo( i, "connected" ) and hasAccess( i, access ) then
			gVoteTally.voters = gVoteTally.voters + 1
			beginMenu( i, title, menu_sendVoteCallback )
			
			for c=1, table.getn( txt_table ) do -- Set up options
				addOption( i, txt_table[ c ], id_table[ c ] )
			end
			
			endMenu( i )
		end
	end
	
	AddTimer( gTimeout, 1, menu_voteFinish ) -- Finish up the vote
end

function menu_sendVoteCallback( userid, choice, seconds ) -- Called to tally votes
	if choice == ID_EXIT then
		gVoteTally.exits = gVoteTally.exits + 1
		if gVoteTally.votes + gVoteTally.exits >= gVoteTally.voters then
			menu_voteFinish() -- Allow it to finish early if it has all the votes
		end
		return
	end
	
	if tonumber( ulx_sv_showvotes ) ~= nil and tonumber( ulx_sv_showvotes ) ~= 0 then -- This uses our global
		ulx_tsay_all( _PlayerInfo( userid, "name" ) .. " voted for option " .. gVoteTally[ choice ].name )
	end
			
	gVoteTally[ choice ].num = gVoteTally[ choice ].num + 1 -- Up the tally
	gVoteTally.votes = gVoteTally.votes + 1
	
	if gVoteTally.votes + gVoteTally.exits >= gVoteTally.voters then
		menu_voteFinish() -- Allow it to finish early if it has all the votes
	end
end

function menu_voteFinish()
	if gVoteTally == nil then
		return
	end
	
	local winner = { num_id=ID_NONE, num=0 }

	for i,v in pairs( gVoteTally ) do -- Loop through them
		if i ~= "callback" and i ~= "votes" and i~= "voters" and i~= "exits" then
			if gVoteTally[ i ].num > winner.num then
				winner.num_id=i
				winner.num=gVoteTally[ i ].num
			end
		end
	end

	gVoteTally.callback( winner.num_id, winner.num, gVoteTally[ winner.num_id ].name, gVoteTally )
	
	gVoteTally = nil
end

-------------------------------------------------------------------------------------------------
--Generic "run on console" callback, so we don't have a million individual callbacks doing this--
-------------------------------------------------------------------------------------------------
function menu_serverCommandCallback( userid, choice, seconds )
	if choice == ID_EXIT then
		return
	end
	
	if choice == nil or type( choice ) ~= "string" then
		ulx_error( "menu_serverCommandCallback called incorrectly!" )
	end
	
	_ServerCommand( choice .. "\n" )
end
