function gmx.forPlayers(players,doFunc)
	if gmx.isValid(doFunc,"function")==false then return gmx.error("gmx.forPlayers - Function provided invalid.") end
	if gmx.isValid(players,"number") then
		if players==0 then
			local players=1;
			for players=1, _MaxPlayers() do
				if _PlayerInfo(players,"connected") then
					doFunc(players);
				end
			end
		else
			doFunc(players);
		end
	elseif gmx.isValid(players,"table") then
		for key,value in players do
			doFunc(value);
		end
	else
		return gmx.error("gmx.forPlayers - Players given are invalid.");
	end
end

function gmx.thirdperson(player,state,entity,distance)
	if gmx.allValid({player,state},{"number","boolean"})==false then return gmx.error("gmx.thirdperson - Arguments invalid") end
	if state==true then
		if gmx.allValid({entity,distance},{"number","number"})==false then return gmx.error("gmx.thirdperson - Arguments needed for thirdperson invalid.") end
		if player==entity then return nil end
		
		--If we don't remove the player's weapons he'll still have them when entering spectator mode.
		_PlayerRemoveAllWeapons(player);
		_PlayerSpectatorStart(player,OBS_MODE_CHASE);
		_PlayerSpectatorTarget(player,entity);
		_PlayerSetChaseCamDistance(player,distance);
	else
		_PlayerSilentKill(player,0,false);
		_PlayerSpectatorEnd(player);
	end
end

function gmx.allPlayers()
	local p={};
	local players=1;
	for players=1,_MaxPlayers() do
		if _PlayerInfo(players,"connected") then
			table.insert(p,table.getn(p)+1,players);
		end
	end
	return p;
end

function gmx.teamMembers(team)
	if gmx.isValid(team,"number")==false then return gmx.error("gmx.teamMembers - Arguments invalid.") end
	local teamlist={};
	for i=1, _MaxPlayers() do
		if _PlayerInfo(i,"connected") then
			if _PlayerInfo(i,"team")==team then
				table.insert(teamlist,table.getn(teamlist),i);
			end
		end
	end
	return teamlist;
end