function gmx.color4(red,green,blue,alpha)
	local n="number";
	if gmx.allValid({red,green,blue},{n,n,n})==false then return gmx.error("gmx.color4 - Arguments invalid.") end
	local opacity=255;
	if gmx.isValid(alpha,n) then opacity=alpha end
	return {red=red,green=green,blue=blue,alpha=opacity};
end

function gmx.colorValid(color)
	if gmx.isValid(color,"table")==false then return gmx.error("gmx.colorValid - Arguments invalid.") end
	local newRed=color.red;
	local newGreen=color.green;
	local newBlue=color.blue;
	local newAlpha=color.alpha;
	if color.red>255 then newRed=255 end
	if color.green>255 then newGreen=255 end
	if color.blue>255 then newBlue=255 end
	if color.alpha>255 then newAlpha=255 end
	if color.red<0 then newRed=0 end
	if color.green<0 then newGreen=0 end
	if color.blue<0 then newBlue=0 end
	if color.alpha<0 then newAlpha=0 end
	
	return gmx.color4(newRed,newGreen,newBlue,newAlpha);
end

function gmx.colorBlend(colorA,colorB)
	if gmx.allValid({colorA,colorB},{"table","table"})==false then return gmx.error("gmx.colorBlend - Arguments invalid.") end
	local newRed  =((colorA.red-colorB.red)/2)+colorB.red;
	local newGreen=((colorA.green-colorB.green)/2)+colorB.green;
	local newBlue =((colorA.blue-colorB.blue)/2)+colorB.blue;
	local newAlpha=((colorA.alpha-colorB.alpha)/2)+colorB.alpha;
	return gmx.colorValid(gmx.color4(newRed,newGreen,newBlue,newAlpha));
end

function gmx.colorAdd(colorA,colorB)
	if gmx.allValid({colorA,colorB},{"table","table"})==false then return gmx.error("gmx.colorAdd - Arguments invalid.") end
	local newRed  =colorA.red+colorB.red;
	local newGreen=colorA.green+colorB.green;
	local newBlue =colorA.blue+colorB.blue;
	local newAlpha=colorA.alpha+colorB.alpha;
	return gmx.colorValid(gmx.color4(newRed,newGreen,newBlue,newAlpha));
end

function gmx.colorSub(colorA,colorB)
	if gmx.allValid({colorA,colorB},{"table","table"})==false then return gmx.error("gmx.colorSub - Arguments invalid.") end
	local newRed  =colorA.red-colorB.red;
	local newGreen=colorA.green-colorB.green;
	local newBlue =colorA.blue-colorB.blue;
	local newAlpha=colorA.alpha-colorB.alpha;
	return gmx.colorValid(gmx.color4(newRed,newGreen,newBlue,newAlpha));
end

function gmx.colorMul(colorA,colorB)
	if gmx.allValid({colorA,colorB},{"table","table"})==false then return gmx.error("gmx.colorMul - Arguments invalid.") end
	local newRed  =colorA.red*colorB.red;
	local newGreen=colorA.green*colorB.green;
	local newBlue =colorA.blue*colorB.blue;
	local newAlpha=colorA.alpha*colorB.alpha;
	return gmx.colorValid(gmx.color4(newRed,newGreen,newBlue,newAlpha));
end

function gmx.colorDiv(colorA,colorB)
	if gmx.allValid({colorA,colorB},{"table","table"})==false then return gmx.error("gmx.colorDiv - Arguments invalid.") end
	local newRed  =colorA.red/colorB.red;
	local newGreen=colorA.green/colorB.green;
	local newBlue =colorA.blue/colorB.blue;
	local newAlpha=colorA.alpha/colorB.alpha;
	return gmx.colorValid(gmx.color4(newRed,newGreen,newBlue,newAlpha));
end