
--Code to strip player name by AndyVincent (slightly modified)
function eventPlayerSay(userid,strText,bTeam)
	if _PlayerInfo(userid,"connected") then
		local name=_PlayerInfo(userid,"name");
		
		--Old strip:
		--local cmdAndArgs=string.gsub(strText,..": ","");
		local cmdAndArgs=strText;
		if bTeam==false then
			cmdAndArgs=string.sub(strText,string.len(name..": ")+1);
		else
			cmdAndArgs=string.sub(strText,string.len("(TEAM) "..name..": ")+1);
		end
		
		
		
		for key,value in gmx.chatCmds do
			if gmx.chatCmds[key].nospace then
				local portionToCompare=string.sub(cmdAndArgs,1,string.len(key))
				if gmx.compareNCC(portionToCompare,key) then
					--Old strip:
					--cmdAndArgs=string.gsub(cmdAndArgs,key,"");
					cmdAndArgs=string.sub(cmdAndArgs,string.len(key)+1);
					
					local args=gmx.explode(cmdAndArgs," ");
					gmx.chatCmds[key].func(userid,args,key);
					return "";
				end
			else
				local argList=gmx.explode(cmdAndArgs," ");
				if gmx.compareNCC(argList[1],key) then
					--Old strip:
					--cmdAndArgs=string.gsub(cmdAndArgs,key,"");
					cmdAndArgs=string.sub(cmdAndArgs,string.len(key)+1);
					
					local args=gmx.explode(cmdAndArgs," ");
					table.remove(args,1);
					gmx.chatCmds[key].func(userid,args,key);
					return "";
				end
			end
		end
	end
	return eventPlayerSayGMX(userid,strText,bTeam);
end

function eventPlayerSayGMX(userid,strText,bTeam)
	return strText;
end

function gmx.requireDownload(filename)
	if gmx.isValid(filename,"string")==false then return gmx.error("gmx.requireDownload - Arguments invalid.") end
	table.insert(gmx.requiredFiles,table.getn(gmx.requiredFiles),filename);
end

function gmx.saveRequireDownloads()
	local fullString="";
	if _file.Exists("maps/".._GetCurrentMap()..".res") then
		fullString=_file.Read("maps/".._GetCurrentMap()..".res");
		fullString=string.gsub(fullString,"}","");
		
	else
		fullString="\"resources\"\n{\n";
	end
	local filenames=gmx.requiredFiles;
	for key,value in filenames do
		if string.find(string.lower(fullString),string.lower(value))==nil then
			fullString=fullString.."\""..value.."\" \"file\"\n";
		end
	end
	fullString=fullString.."}";
	_file.Write("maps/".._GetCurrentMap()..".res",fullString);
end

function gmx.consoleCommand(command,theFunc)
	if gmx.allValid({command,theFunc},{"string","function"})==false then return gmx.error("gmx.consoleCommand - Arguments invalid.") end
	gmx.conCmds[command]={};
	gmx.conCmds[command].func=theFunc;
	
	local dummyFunc=function(userid,args)
						local argList=gmx.explode(args," ");
						gmx.conCmds[command].func(userid,argList,command);
					end
	CONCOMMAND(command,dummyFunc);
end

function gmx.chatCommand(command,theFunc,nospace)
	if gmx.allValid({command,theFunc},{"string","function"})==false then return gmx.error("gmx.chatCommand - Arguments invalid.") end
	gmx.chatCmds[command]={};
	gmx.chatCmds[command].func=theFunc;
	gmx.chatCmds[command].nospace=nospace or false;
end

function gmx.trace(pos,angle,distance,detailLevel,ignore)
	if gmx.allValid({pos,angle,distance})==false then return gmx.error("gmx.trace - Arguments invalid.") end
	local detail=detailLevel or 1;
	local ignoreEnt=ignore or nil;
	_TraceLine(pos,angle,distance,ignoreEnt);
	local results={};
	
	if detail>=1 then
		results.hitpos=_TraceEndPos();
		results.entHit=_TraceGetEnt();
	end
	
	if detail>=2 then
		results.hit=_TraceHit();
		results.hitWorld=_TraceHitWorld();
		results.hitNonWorld=_TraceHitNonWorld();
	end
	
	if detail>=3 then
		results.fraction=_TraceFraction();
		results.hitWater=_TraceDidHitWater();
		results.hitHitbox=_TraceDidHitHitbox();
		results.hitSky=_TraceDidHitSky();
	end
	
	if detail>=4 then
		results.normal=_TraceGetSurfaceNormal();
		results.hittexture=_TraceGetTexture();
	end
	return results;
end

function gmx.traceFromPlayer(player,distance,detail)
	if gmx.allValid({player,distance},{"number","number"})==false then return gmx.error("gmx.traceFromPlayer - Arguments invalid.") end
	return gmx.trace(_PlayerGetShootPos(player),_PlayerGetShootAng(player),distance,detail,player);
end