function gmx.makeEnt(classname,location,angles,keyvalues,targetname)
	if gmx.allValid({classname,location,angles},{"string","userdata","userdata"})==false then return gmx.error("gmx.makeEnt - Arguments invalid.") end
		local ent=_EntCreate(classname)
				   _EntSetPos(ent,location)
				   _EntSetAng(ent,angles)
		if gmx.isValid(keyvalues,"table") then
			for keyvalue in keyvalues do
				   _EntSetKeyValue(ent,""..keyvalue,""..keyvalues[keyvalue]);
			end
		end
		if gmx.isValid(targetname,"string") then
				   _EntSetName(ent,targetname);
		end
				  _EntSpawn(ent);
		return ent;
end

function gmx.makeProp(model,location,angles,ragdoll,targetname,skin)
	if gmx.allValid({model,location,angles},{"string","userdata","userdata"})==false then return gmx.error("gmx.makeProp - Arguments invalid.") end
	_EntPrecacheModel(model);
--	Due to ragdoll spawning via Lua crashing the game, ragdoll spawning is off.
--	local spawnRagdoll=ragdoll or false;
	local spawnRagdoll=false;
	local ent=0;
	if spawnRagdoll==true then
		ent=_EntCreate("prop_ragdoll");
	else
		ent=_EntCreate("prop_physics");
	end
			   _EntSetPos(ent,location);
			   _EntSetAng(ent,angles);
			   _EntSetModel(ent,model);
	if gmx.isValid(targetname,"string") then
			   _EntSetName(ent,targetname);
	end
	if gmx.isValid(skin,"number") then
			   _EntSetKeyValue(ent,"skin",""..skin);
	end
			  _EntSpawn(ent);
	return ent;
end

function gmx.makeLaser(vectorStart,vectorEnd,isLaser,strength,texture,beamColor,life,beamWidth)
	if gmx.allValid({vectorStart,vectorEnd,isLaser},{"userdata","userdata","boolean"})==false then return gmx.error("gmx.makeLaser - Arguments invalid.") end
	local material=texture or "sprites/laser.spr";
	local damage=strength or 0;
	local color=beamColor or gmx.color4(255,255,255,255);
	local width=beamWidth or 3;
	
	if isLaser==true then
		local laserStart=gmx.makeEnt("env_laser",vectorStart,vector3(0,0,0),{renderamt=color.alpha,rendercolor=color.red.." "..color.green.." "..color.blue,width=width,texture=material,damage=damage,LaserTarget="gmx_lasertarget_"..gmx.lasers},"gmx_laser_"..gmx.lasers)
		local laserEnd=gmx.makeEnt("info_target",vectorEnd,vector3(0,0,0),{},"gmx_lasertarget_"..gmx.lasers)
		local laserID=gmx.lasers;
		_EntFire(laserStart,"TurnOn","",0);
		if gmx.isValid(life,"number") then
			if life>0 then
				local tempFunc=	function()
									_EntRemove(laserStart);
									_EntRemove(laserEnt);
								end
				AddTimer(life,1,tempFunc);
			end
		end
		gmx.lasers=gmx.lasers+1;
		return {laserStart,laserEnd,laserID};
	else
		local laserEnt=gmx.makeEnt("env_laser",vectorStart,vector3(0,0,0),{renderamt=color.alpha,rendercolor=color.red.." "..color.green.." "..color.blue,BoltWidth=width,texture=material,damage=damage,LightningStart="gmx_laserstart_"..gmx.lasers,LightningEnd="gmx_laserend_"..gmx.lasers},"gmx_laser_"..gmx.lasers)
		local laserStart=gmx.makeEnt("info_target",vectorStart,vector3(0,0,0),{},"gmx_laserstart_"..gmx.lasers)
		local laserEnd=gmx.makeEnt("info_target",vectorEnd,vector3(0,0,0),{},"gmx_laserend_"..gmx.lasers)
		local laserID=gmx.lasers;
		_EntFire(laserEnt,"TurnOn","",0);
		if gmx.isValid(life,"number") then
			if life>0 then
				local tempFunc=	function()
									_EntRemove(laserEnt);
									_EntRemove(laserStart);
									_EntRemove(laserEnd);
								end
				AddTimer(life,1,tempFunc);
			end
		end
		gmx.lasers=gmx.lasers+1;
		return {laserEnt,laserStart,laserEnd,laserID};
	end
end

function gmx.makeExplosion(location,magnitude)
	if gmx.isValid(location,"userdata")==false then return gmx.error("gmx.makeExplosion - Arguments invalid.") end
	local explosionForce=magnitude or 100;
	local ent=gmx.makeEnt("env_explosion",location,vector3(0,0,0),{iMagnitude=explosionForce});
	_EntFire(ent,"Explode","",0);
	return ent;
end

function gmx.setColor(ent,color)
	if gmx.allValid({ent,color},{"number","table"})==false then return gmx.error("gmx.setColor - Arguments invalid.") end
		_EntFire(ent,"Color",color.red.." "..color.green.." "..color.blue.." 0",0);
		_EntFire(ent,"Alpha",""..color.alpha,0);
end

function gmx.picker(player)
	if gmx.isValid(player,"number")==false then return gmx.error("gmx.picker - Arguments invalid.") end
	local pickerTrace=gmx.traceFromPlayer(player,9999,1);
	gmx.tableMem(pickerTrace);
	return pickerTrace.entHit;
end