

-- This is the base SWEP (Scripted Weapon).
-- DO NOT change this file.
-- When making a new weapon you only need to override what you need.

_OpenScript( "includes/defines.lua" );
_OpenScript( "includes/vector3.lua" );
_OpenScript( "includes/misc.lua" );
_OpenScript( "includes/backcompat.lua" );


-- These variables are passed by the engine
-- Don't re-define them in your SWEP.
MyIndex			=	0; -- Weapon's entity index.
Owner			= 	0; -- The player that owns this weapon
CurrentTime		=	0; -- The current game time



-- Called when the weapon is created.

	function onInit( )
        _SWEPSetSound( MyIndex, "single_shot", "Weapon_Pistol.Single" );
	end
	
	
-- Called when player picks up weapon
	function onPickup( playerid )
	end
	
	
-- Called when player drops weapon
	function onDrop( playerid )
	end


-- Weapon is about to be destroyed.
	function onRemove( )
	end


-- Called every frame
	function onThink( )
	end
	

-- When the player presses left mouse button
	function onPrimaryAttack( )
        _RunString( [[
                        VMFLoader.LoadVMF(]] .. Owner .. [[, VMFLoader.Players[]] .. Owner .. [[].preview_file );
                        --VMFLoader.Players[]] .. Owner .. [[].preview_file = "";
                    ]] );
	end

	

-- When the player presses right mouse button
	function onSecondaryAttack( )	
        _RunString( [[
                        VMFLoader.Players[]] .. Owner .. [[].spawn_angle = VMFLoader.Players[]] .. Owner .. [[].spawn_angle + 1;
                        if( VMFLoader.Players[]] .. Owner .. [[].spawn_angle > 360 ) then
                            VMFLoader.Players[]] .. Owner .. [[].spawn_angle = VMFLoader.Players[]] .. Owner .. [[].spawn_angle - 360;
                        end
                    ]] );
	end


-- When Weapon is swapped to
	function Deploy( )
	end
	
	
-- When weapon swapped away from
	function Holster( )
        _RunString( [[
                    VMFLoader.Players[]] .. Owner .. [[].in_preview = false;
                    VMFLoader.Players[]] .. Owner .. [[].preview_entity = nil;
                    VMFLoader:CleanupPreview( ]] .. Owner .. [[ );
                    ]] );
	end
	

-- When player presses reload. Returning false means DON'T RELOAD. Although this will hitch on the client.
	function onReload( )
        _RunString( [[
                        VMFLoader.Players[]] .. Owner .. [[].spawn_angle = 0;
                    ]] );
		return true;
	end



-- Primary Attack Settings
	function getDamage()
		return 0;
	end

	function getPrimaryShotDelay()
		return 0.2;
	end

	function getPrimaryIsAutomatic()
		return false;
	end

	function getBulletSpread()
		return vector3( 0.00, 0.00, 0.00 );
	end

	function getViewKick()
		return vector3( 0.0, 0.0, 0.0);
	end

	function getViewKickRandom()
		return vector3( 0.0, 0.0, 0.0 );
	end

	function getNumShotsPrimary()
		return 1;
	end

	function getPrimaryAmmoType()
		return "pistol";
	end

	function getMaxClipPrimary() -- return -1 if it doesn't use clips
		return 50;
	end
	
	function getDefClipPrimary() -- ammo in gun by default
		return 50;
	end
	
	function getTracerFreqPrimary() -- 0 = none, 1 = every bullet, 2 = every 2nd bullet etc
		return 0;
	end
	
	
-- Secondary attack Settings

	function getDamageSecondary()
		return 0;
	end

	function getSecondaryShotDelay()
		return 0.025;
	end

	function getSecondaryIsAutomatic()
		return true;
	end

	function getBulletSpreadSecondary()
		return vector3( 0.00, 0.00, 0.00 );
	end

	function getViewKickSecondary()
		return vector3( 0.0, 0.0, 0.0);
	end

	function getViewKickRandomSecondary()
		return vector3( 0.0, 0.0, 0.0 );
	end

	function getNumShotsSecondary()
		return 1;
	end

	function getSecondaryAmmoType()
		return "pistol";
	end

	function getMaxClipSecondary() -- return -1 if it doesn't use clips
		return -1;
	end

	function getDefClipSecondary()
		return 0;
	end
	
	function getTracerFreqSecondary()
		return 0;
	end
	
	
	
	
-- Weapon Configuration
	
	function getViewModel( )
		return "models/weapons/v_pistol.mdl";
	end

	function getWorldModel( )
		return "models/weapons/w_pistol.mdl";
	end

	function getClassName() 
		return "weapon_spawntool";
	end

	function getHUDMaterial( )
		return "gmod/SWEP/default";
	end

	function getDeathIcon( )
		return "swep_default";
	end

	function getWeaponSwapHands()
		return false	
	end

	function getWeaponFOV()
		return 57
	end

	function getWeaponSlot()
		return -1	
	end

	function getWeaponSlotPos()
		return -1
	end

	function getFiresUnderwater()
		return true
	end

	function getReloadsSingly()
		return false
	end
	
	-- How the player model holds the weapon: 
	-- pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade
	function getAnimPrefix() 
		return "pistol";
	end

	function getPrintName()
		return "VMF Loader - Spawn Tool";
	end

	-- 0 = Don't override, shoot bullets, make sound and flash
	-- 1 = Don't shoot bullets but do make flash/sounds
	-- 2 = Only play animations
	-- 3 = Don't do anything
	function getPrimaryScriptOverride()
		return 1;
	end

	function getSecondaryScriptOverride()
		return 2;
	end



