
-- Detect newly created entities.
function VMFSaver.ScanForNewEntities( )
    for i = 1, 2048 do
        -- Detect entity additions or removals.
        if( _EntExists( i ) and not VMFSaver:EntityExists( i ) ) then
            VMFSaver:InitEntity( i, true );
            table.insert( VMFSaver.NewEntities, i );
            
            -- Process events.
            VMFSaver:ProcessConstraints();
        elseif( not _EntExists( i ) and VMFSaver:EntityExists( i ) ) then
            VMFSaver:InitEntity( i, false );
        end
    end
end
AddThinkFunction( VMFSaver.ScanForNewEntities );

-- Pop entities off the stack.
function VMFSaver:PopEntities( count, ... )
    if( table.getn( VMFSaver.NewEntities ) > 0 ) then
        local ret = {};
        local popped = 0;
        while( popped < count ) do
            if( table.getn( VMFSaver.NewEntities ) <= 0 ) then
                break;
            end
            
            -- Get the last entity off.
            local ent = VMFSaver.NewEntities[ table.getn( VMFSaver.NewEntities ) ];
            table.remove( VMFSaver.NewEntities, table.getn( VMFSaver.NewEntities ) );
            
            -- Compare to args.
            for _, entity in arg do
                if( entity == _EntGetType( ent ) ) then
                    -- Increment popped.
                    popped = popped + 1;
                    table.insert( ret, ent );
                end
            end
        end
        
        -- Debug.
        _dMsg( "Popping the following entities off the stack.\n===================\n" );
        for _, e in ret do
            _dMsg( _EntGetType( e ) .. "\n" );
        end
        _dMsg( "===================\n" );
        
        return ret;
    end
    
    return nil;
end
