-- Mount file systems.
function VMFLoader:MountFileSystems( path )
    local files = _file.Find( path .. "/*.vpk" );
    for _, file in files do
        _Msg( "[VMFLoader] Loading package " .. file .. "....\n" );
        LuaVFS:new( path .. "/" .. file );
    end
end

-- Mount packs.
VMFLoader:MountFileSystems( "lua/vmfloader/packs" );

-- Process icons.
function VMFLoader:ProcessIcon( file, delete )
    -- Filenames.
    local vmf = string.sub( file, string.lastfind( file, "/" ) + 1 );
    local vtf = string.gsub( vmf, ".vmf", ".vtf" );
    local folder = string.sub( file, 1, string.lastfind( file, "/" ) );
    
    -- Get path.
    local path = "materials/gmod/loadvmf " .. folder;
    
    -- Delete old vmt?
    if( delete and _file.Exists( path .. string.sub( vtf, 1, string.find( vtf, ".vtf" ) - 1 ) .. ".vmt" ) ) then
        _file.Delete( path .. string.sub( vtf, 1, string.find( vtf, ".vtf" ) - 1 ) .. ".vmt" );
        return;
    end
    
    -- Does the icon exist?
    if( _file.Exists( string.gsub( file, ".vmf", ".vtf" ) ) ) then 
        -- Create the folder structure.
        _file.CreateDir( path );
        
        -- Create the vmt file.
        local vmt = "\"UnlitGeneric\"\r\n{\r\n\t\"$vertexalpha\" \"1\"\r\n\t\"$basetexture\" \"../" .. folder .. string.sub( vtf, 1, string.find( vtf, ".vtf" ) - 1 ) .. "\"\r\n}\r\n";
        _file.Write( path .. string.sub( vtf, 1, string.find( vtf, ".vtf" ) - 1 ) .. ".vmt", vmt );
        
        -- Send icons?
        if( VMFLoader.SendSpawnIcons ) then
            -- Does a resource file exist for this map?
            if( _file.Exists( "maps/" .. _GetCurrentMap() .. ".res" ) ) then
                -- Only append.
                local res = _file.Read( "maps/" .. _GetCurrentMap() .. ".res" );
                
                -- Generate file string.
                local file = "\t\"" .. path .. string.sub( vtf, 1, string.find( vtf, ".vtf" ) - 1 ) .. ".vmt" .. "\" \"file\"\r\n";
                
                -- Does it already exist?
                if( string.find( res, file ) == nil ) then
                    res = string.gsub( res, "}", file .. "}" );
                    _file.Write( "maps/" .. _GetCurrentMap() .. ".res", res );
                end
                
                -- Generate file string.
                file = "\t\"" .. folder .. vtf .. "\" \"file\"\r\n";
                
                -- Does it already exist?
                if( string.find( res, file ) == nil ) then
                    res = string.gsub( res, "}", file .. "}" );
                    _file.Write( "maps/" .. _GetCurrentMap() .. ".res", res );
                end
            else
                -- Create a new one
                local res = "\"resources\"\r\n{\r\n\t\"" .. path .. string.sub( vtf, 1, string.find( vtf, ".vtf" ) - 1 ) .. ".vmt" .. "\" \"file\"\r\n\t\"" .. folder .. vtf .. "\" \"file\"\r\n}\r\n";
                
                -- Generate strings.
                _file.Write( "maps/" .. _GetCurrentMap() .. ".res", res );
            end
        end
    end
end

-- VMFLoader Spawn Menu.
function VMFLoader:SendFolder( folder, player )
    -- Find all files and folders in this folder.
    local tFiles = _file.Find( folder.path .. "/*" );
    for _, entry in tFiles do
        if( entry ~= ".." ) then
            if( entry == "." ) then
                -- Extract vmfs out of it.
                local tFiles2 = _file.Find( folder.path .. "/" .. entry .. "/*.vmf" );
                for _, file in tFiles2 do
                    local sTitle = string.gsub( file, ".vmf", "" );
                    sTitle = string.gsub( sTitle, "^%l", string.upper );
                    sTitle = string.gsub( sTitle, "_", " " );
                    
                    -- Process icons.
                    if( VMFLoader.SpawnIcons ) then
                        VMFLoader:ProcessIcon( folder.path .. "/" .. file, false );
                    else
                        VMFLoader:ProcessIcon( folder.path .. "/" .. file, true );
                    end
                    
                    _spawnmenu.AddItem( player, "VMF Loader - " .. folder.category, "+" .. sTitle, "loadvmf " .. folder.path .. "/" .. file );
                end
            else
                -- Extract vmfs out of the subfolder.
                if( _file.IsDir( folder.path .. "/" .. entry ) and not Folder:Find( folder.path .. "/" .. entry ) ) then
                    _spawnmenu.AddItem( player, "VMF Loader - " .. folder.category, "@" .. entry, "" );
                    local tFiles2 = _file.Find( folder.path .. "/" .. entry .. "/*.vmf" );
                    for _, file in tFiles2 do
                        local sTitle = string.gsub( file, ".vmf", "" );
                        sTitle = string.gsub( sTitle, "^%l", string.upper );
                        sTitle = string.gsub( sTitle, "_", " " );
                        
                        -- Process icons.
                        if( VMFLoader.SpawnIcons ) then
                            VMFLoader:ProcessIcon( folder.path .. "/" .. entry .. "/" .. file, false );
                        else
                            VMFLoader:ProcessIcon( folder.path .. "/" .. entry .. "/" .. file, true );
                        end
                    
                        _spawnmenu.AddItem( player, "VMF Loader - " .. folder.category, "+" .. sTitle, "loadvmf " .. folder.path .. "/" .. entry .. "/" .. file );
                    end
                end
            end
        end
    end
end

function VMFLoader:GenerateSpawnMenu( player )
    -- Are we connected.
    if( not _PlayerInfo( player, "connected" ) ) then
        return;
    end

    -- Send down new folders.
    for _, folder in Folder:GetFolders() do
        -- Erase old menu.
        _spawnmenu.RemoveCategory( player, "VMF Loader - " .. folder.category );
        
        if( folder.access ~= "" ) then
            -- Folder requires admin.
            if( Admin:CheckAccess( player, folder.access ) ) then
                VMFLoader:SendFolder( folder, player );
            end
        else
            -- Folder is public.
            VMFLoader:SendFolder( folder, player );
        end
    end
end

function VMFLoader.PlayerInitialSpawn( player )
    -- Should I even send the menu?
    if( VMFLoader.UseSpawnMenu ) then
	    VMFLoader:GenerateSpawnMenu( player );
    end
end
HookEvent( "eventPlayerInitialSpawn", VMFLoader.PlayerInitialSpawn );

-- Auto generate.
if( VMFLoader.UseSpawnMenu ) then
    for i = 1, _MaxPlayers() do
         VMFLoader:GenerateSpawnMenu( i );
    end
end

