-- Key Value Filter
-------------------------------------------
VMFParser = {};

-- Chunk types.
VMFParser.CHUNK_NONE  =   -1;
VMFParser.CHUNK_ENTITY    =   0;
VMFParser.CHUNK_CONNECTIONS   =   1;
VMFParser.CHUNK_SOLID     =   2;
VMFParser.CHUNK_SIDE  =   3;
VMFParser.CHUNK_MISC  =   -2;
VMFParser.CHUNK_WORLD =   4;
VMFParser.CHUNK_LUA   =   5;

-- Parse vmf file.
function VMFParser:parse( file )
    TokenReader.g_sFileData = _file.Read( file );
    TokenReader.g_iReaderPos = 1;

    local depth = 0;
    local currentchunk = VMFParser.CHUNK_NONE;
    local lastchunk = VMFParser.CHUNK_NONE;

    local _buffer = "";
    local _nextbuffer = "";
    local _token = TokenReader.TOKENNONE;
    local _nexttoken = TokenReader.TOKENNONE;
    local beginsolid = false;
    local solidstart = 0;
    
    local worldkeys = {};
    local luakeys = {};
    local entities = {};
    local curentity = {};

    while( true ) do
    
        if( TokenReader.g_iReaderPos >= string.len( TokenReader.g_sFileData ) ) then
            break;
        end
        
        _token, _buffer = TokenReader:ReadToken();
        
        if( _token == TokenReader.TSTRING or _token == TokenReader.IDENT ) then
        
            _nexttoken, _nextbuffer = TokenReader:ReadToken();
            
            if( _nexttoken == TokenReader.TSTRING or _nexttoken == TokenReader.IDENT ) then
        
                if( not beginsolid ) then
                    -- Process entity keyvalue.
                    if( currentchunk == VMFParser.CHUNK_ENTITY ) then
                        -- Construct keyvalue, then run the filters.
                        local kv = {};
                        kv.key = _buffer;
                        kv.value = _nextbuffer;
                        if( not KVFilter:runFilters( kv, currentchunk ) ) then
                            table.insert( curentity.keyvalues, kv );
                        end
                    end
                    
                    -- Process entity connection.
                    if( currentchunk == VMFParser.CHUNK_CONNECTIONS ) then
                        -- Construct keyvalue, then run the filters.
                        local kv = {};
                        kv.key = _buffer;
                        kv.value = _nextbuffer;
                        if( not KVFilter:runFilters( kv, currentchunk ) ) then
                            table.insert( curentity.connections, kv );
                        end
                    end
                    
                    -- Process world keyvalue.
                    if( currentchunk == VMFParser.CHUNK_WORLD ) then
                        local kv = {};
                        kv.key = _buffer;
                        kv.value = _nextbuffer;
                        if( not KVFilter:runFilters( kv, currentchunk ) ) then
                            table.insert( worldkeys, kv );
                        end
                    end
                    
                    -- Process lua keyvalue
                    if( currentchunk == VMFParser.CHUNK_LUA ) then
                        local kv = {};
                        kv.key = _buffer;
                        kv.value = _nextbuffer;
                        if( not KVFilter:runFilters( kv, currentchunk ) ) then
                            table.insert( luakeys, kv );
                        end
                    end
                end
                
            end
            
            if( _nexttoken == TokenReader.OPERATOR and _nextbuffer == "{" ) then
                depth = depth + 1;
                
                if( not beginsolid ) then
                    -- New chunk, push the current one onto the stack.
                    lastchunk = currentchunk;
                    
                    if( _buffer == "entity" ) then
                        currentchunk = VMFParser.CHUNK_ENTITY;
                        curentity = {};
                        curentity.keyvalues = {};
                        curentity.connections = {};
                    elseif( _buffer == "connections" ) then
                        currentchunk = VMFParser.CHUNK_CONNECTIONS;
                    elseif( _buffer == "solid" ) then
                        beginsolid = true;
                        solidstart = depth - 1;
                    elseif( _buffer == "world" ) then
                        currentchunk = VMFParser.CHUNK_WORLD;
                    elseif( _buffer == "lua" ) then
                        currentchunk = VMFParser.CHUNK_LUA;
                    else
                        currentchunk = VMFParser.CHUNK_MISC;
                    end
                end
            end
            
            -- Break out of the infinite loop.
            if( _nexttoken == TokenReader.TOKENERROR or _nexttoken == TokenReader.TOKENEOF ) then
                break;
            end
        end
        
        if( _token == TokenReader.OPERATOR ) then
            depth = depth - 1;
            
            if( not beginsolid ) then
                
                if( currentchunk == VMFParser.CHUNK_ENTITY ) then
                    table.insert( entities, curentity );
                end
                
                -- pop last chunk off stack.
                currentchunk = lastchunk;
            else
                if( solidstart == depth ) then
                    beginsolid = false;
                    solidstart = 0;
                end
            end
        end
        
        -- Break out of the infinite loop.
        if( _token == TokenReader.TOKENERROR or _token == TokenReader.TOKENEOF ) then
            break;
        end
    end

    -- Return what was parsed.
    return entities, worldkeys, luakeys;
end
