-- Key Value Filter
-------------------------------------------
KVFilter = {};

-- Create a new filter.
function KVFilter:create( name )
    -- Create object.
    local obj = {};
    setmetatable( obj, self );
    self.__index = self;
    
    -- Set name.
    obj.name = name;

    -- Give them  back the new filter.
    return obj;
end

-- Called to filter a keyvalue, returning true means remove completely.
function KVFilter:filter( kv, block )
    -- This is basically a psuedo virtual function.
end

-- Install the keyvalue filter.
function KVFilter:install( )
    table.insert( KVFilter.Filters, self );
end

-- Key Value Filtering
-------------------------------------------
KVFilter.Filters = {};

-- Run filters.
function KVFilter:runFilters( kv, block )
    local remove = false;
    for _, filter in KVFilter.Filters do
        if( filter:filter( kv, block ) ) then
            remove = true;
        end
    end
    return remove;
end

-- Load filters.
KVFilter.Files = _file.Find( "lua/vmfloader/filters/*.lua" );
for _, file in KVFilter.Files do
    _OpenScript( "vmfloader/filters/" .. file );
end
