
-- VMF Saving Utility Functions.
----------------------------------------

-- Add a keyvalue to the entity.
function VMFSaver:AddKV( entity, key, value )
    local kv = {};
    kv.key = output;
    kv.value = value;
    table.insert( VMFSaver.Entities[entity].keyvalues, kv );
end

-- Add an output to the entity.
function VMFSaver:AddOutput( entity, output, value )
    local kv = {};
    kv.key = output;
    kv.value = value;
    table.insert( VMFSaver.Entities[entity].connections, kv );
end

-- Init the entity.
function VMFSaver:InitEntity( entity, exists )
    VMFSaver.Entities[entity].exists = exists;
    VMFSaver.Entities[entity].keyvalues = {};
    VMFSaver.Entities[entity].connections = {};
    VMFSaver.Entities[entity].data = {};
end

-- Exists?
function VMFSaver:EntityExists( entity )
    return VMFSaver.Entities[entity].exists;
end

-- Debug print.
function _dMsg( msg )
    if( GLOBAL_DEBUG ) then
        _Msg( msg );
    end
end
