
TOOL.Category = '(Resource Dist.)'
TOOL.Name = '#Link Tool'
TOOL.Command = nil
TOOL.ConfigName = ''

// Add Default Language translation (saves adding it to the txt files)
if ( CLIENT ) then

	language.Add( "Tool_dev_link_name", "Link Tool" )
	language.Add( "Tool_dev_link_desc", "Links Resource-Carrying Devices together, including Vehicle Pods." )
	language.Add( "Tool_dev_link_0", "Left Click: Link Devices.  Right Click: Unlink Two Devices.  Reload: Unlink Device from All." )
    language.Add( "Tool_dev_link_1", "Click on another Resource-Carrying Device(or Vehicle Pod)" )
    language.Add( "Tool_dev_link_2", "Right-Click on another Resource-Carrying Device(or the same one to unlink ALL)" )
    language.Add( "LinkTool_addlength", "Add Length:" )
    language.Add( "LinkTool_width", "Width:" )
    language.Add( "LinkTool_material", "Material:" )
	
end

//TOOL.ClientConVar[ "addlength" ] = "4"
TOOL.ClientConVar[ "width" ] = "2"
TOOL.ClientConVar[ "material" ] = "cable/cable2"
//TOOL.ForceLimit = 0
TOOL.ClientConVar[ "color_r" ] = "255"
TOOL.ClientConVar[ "color_g" ] = "255"
TOOL.ClientConVar[ "color_b" ] = "255"

function TOOL:LeftClick( trace )
	if (trace.Entity:IsValid()) and (trace.Entity:IsPlayer()) then return end

	// If there's no physics object then we can't constraint it!
	if ( SERVER && !util.IsValidPhysicsObject( trace.Entity, trace.PhysicsBone ) ) then return false end

	local iNum = self:NumObjects()

	local Phys = trace.Entity:GetPhysicsObjectNum( trace.PhysicsBone )
	self:SetObject( iNum + 1, trace.Entity, trace.HitPos, Phys, trace.PhysicsBone, trace.HitNormal )

	if ( iNum > 0 ) then
	
		if (CLIENT) then
			self:ClearObjects()
			return true
		end
		
		// Get client's CVars
		//local addlength	 = self:GetClientNumber( "addlength" )
		local material 	 = self:GetClientInfo( "material" )
		local width 	 = self:GetClientNumber( "width" ) 
		local color     = Color(self:GetClientNumber("color_r"), self:GetClientNumber("color_g"), self:GetClientNumber("color_b"))
		
		// Get information we're about to use
		local Ent1,  Ent2  = self:GetEnt(1),	 self:GetEnt(2)
		local Bone1, Bone2 = self:GetBone(1),	 self:GetBone(2)
		local WPos1, WPos2 = self:GetPos(1),	 self:GetPos(2)
		local LPos1, LPos2 = self:GetLocalPos(1),self:GetLocalPos(2)
		local length = ( WPos1 - WPos2):Length()
		

		if (not Ent1:GetTable().resources) then
			self:ClearObjects()
	        self:GetOwner():SendLua( "GAMEMODE:AddNotify('Conduit source invalid!', NOTIFY_GENERIC, 7);" )
			return
		end
		if (not Ent2:GetTable().resources) then
			self:ClearObjects()
	        self:GetOwner():SendLua( "GAMEMODE:AddNotify('Conduit destination invalid!', NOTIFY_GENERIC, 7);" )
			return
		end
		
		local matched = 0
		for _, r1 in pairs( Ent1.resources ) do
			for _, r2 in pairs( Ent2.resources ) do
				if ( r1.res_ID == r2.res_ID ) then
					matched = 1
					break
				end
			end
			if ( matched == 1 ) then break end
		end
		
		local Ent1_class = Ent1:GetClass()
		local Ent2_class = Ent2:GetClass()
		if ((Ent1_class == "res_pump") or (Ent1_class == "res_valve")) then
			for _, check in pairs( Ent2.resources ) do
				matched = 1
				break
			end
		end
		if ((Ent2_class == "res_pump") or (Ent2_class == "res_valve")) then
			for _, check in pairs( Ent1.resources ) do
				matched = 1
				break
			end
		end
		
		
		if (matched == 0) then
			self:ClearObjects()
	        self:GetOwner():SendLua( "GAMEMODE:AddNotify('Device does not require this resource!', NOTIFY_GENERIC, 7);" )
			return
		end
		for _, rtype in pairs( Ent1:GetTable().resources ) do
			for _, check in pairs( rtype.links ) do
				if (Ent2 == check.ent) then
					self:ClearObjects()
			        self:GetOwner():SendLua( "GAMEMODE:AddNotify('Devices already connected!', NOTIFY_GENERIC, 7);" )
					return
				end
			end
		end
		if (Ent1 == Ent2) then
			self:ClearObjects()
	        self:GetOwner():SendLua( "GAMEMODE:AddNotify('Devices already connected!', NOTIFY_GENERIC, 7);" )
			return
		end

		if Ent1:GetPos():Distance(Ent2:GetPos()) > RD_MAX_LINK_LENGTH then
			self:ClearObjects()
	        self:GetOwner():SendLua( "GAMEMODE:AddNotify('Distance is too great!', NOTIFY_GENERIC, 7);" )
			return
		end

		--local constraint, rope = constraint.Rope( Ent1, Ent2, Bone1, Bone2, LPos1, LPos2, length, addlength, self.ForceLimit, width, material, false )

--		if ((Ent2_class == "res_pump") or (Ent2_class == "res_valve")) then
			Dev_Link(Ent1, Ent2, LPos1, LPos2, material, color, width)
--		else
--			Dev_Link(Ent2, Ent1, LPos1, LPos2, material, color, width)
--		end

		/*if (constraint) then
--			constraint:CallOnRemove("UnlinkWire", Wire_Unlink, input_idx, self.ToB)
		else
	        self:GetOwner():SendLua( "GAMEMODE:AddNotify('Failed to create rope constraint for Conduit!', NOTIFY_GENERIC, 7);" )
		end*/

		// Clear the objects so we're ready to go again
		self:ClearObjects()

--		// Add The constraint to the players undo table
--		undo.Create("Hose")
--		undo.AddEntity( constraint )
--		undo.AddEntity( rope )
--		undo.SetPlayer( self:GetOwner() )
--		undo.Finish()
		//self:GetOwner():AddCleanup( "tankconstraints", constraint )
		//self:GetOwner():AddCleanup( "tankconstraints", rope )

	else

		self:SetStage( iNum+1 )

	end

	return true
end

function TOOL:RightClick( trace )

	if (trace.Entity:IsValid()) and (trace.Entity:IsPlayer()) then return end

	// If there's no physics object then we can't constraint it!
	if ( SERVER && !util.IsValidPhysicsObject( trace.Entity, trace.PhysicsBone ) ) then return false end

	local iNum = self:NumObjects()

	local Phys = trace.Entity:GetPhysicsObjectNum( trace.PhysicsBone )
	self:SetObject( iNum + 1, trace.Entity, trace.HitPos, Phys, trace.PhysicsBone, trace.HitNormal )

	if ( iNum > 0 ) then
	
		if (CLIENT) then
			self:ClearObjects()
			return true
		end
		
		
		// Get information we're about to use
		local Ent1,  Ent2  = self:GetEnt(1),	 self:GetEnt(2)

		if (not Ent1:GetTable().resources) then
			self:ClearObjects()
	        self:GetOwner():SendLua( "GAMEMODE:AddNotify('Conduit source invalid!', NOTIFY_GENERIC, 7);" )
			return
		end
		if (not Ent2:GetTable().resources) then
			self:ClearObjects()
	        self:GetOwner():SendLua( "GAMEMODE:AddNotify('Conduit destination invalid!', NOTIFY_GENERIC, 7);" )
			return
		end


		if (Ent1 == Ent2) then
			Dev_Unlink_All(Ent1)
			//constraint.RemoveConstraints(trace.Entity, "Rope")
		else
			Dev_Unlink(Ent1, Ent2)
			/*if ( !Ent1:GetTable().Constraints ) then return end
			
			local c = Ent1:GetTable().Constraints
			i = 0
		
			for k, v in pairs( c ) do
			
				if ( !v:IsValid() ) then
				
					c[ k ] = nil
			
				elseif (  v:GetTable().Type == "Rope" ) then
				
					// Make sure physics collisions are on!
					// If we don't the unconstrained objects will fall through the world forever.
					Ent1:GetPhysicsObject():EnableCollisions( true )
					Ent2:GetPhysicsObject():EnableCollisions( true )
					if ( ( ( v:GetTable().Ent1 == Ent1 ) and ( v:GetTable().Ent2 == Ent2 ) ) or ( ( v:GetTable().Ent1 == Ent2 ) and ( v:GetTable().Ent2 == Ent1 ) ) ) then
						c[ k ] = nil
						v:Remove()
					end
					
					i = i + 1
				end
				
			end
		
			if (table.Count(c) == 0) then
				// Update the network var and clear the constraints table.
				Ent1:IsConstrained()
			end*/
			
		end

		// Clear the objects so we're ready to go again
		self:ClearObjects()

	else

		self:SetStage( iNum+2 )

	end

	return true

end

function TOOL:Reload(trace)
	if (trace.Entity:IsValid()) and (trace.Entity:IsPlayer()) then return end

	// If there's no physics object then we can't constraint it!
	if ( SERVER && !util.IsValidPhysicsObject( trace.Entity, trace.PhysicsBone ) ) then return false end

	local iNum = self:NumObjects()

	local Phys = trace.Entity:GetPhysicsObjectNum( trace.PhysicsBone )
	self:SetObject( iNum + 1, trace.Entity, trace.HitPos, Phys, trace.PhysicsBone, trace.HitNormal )

	if (CLIENT) then
		self:ClearObjects()
		return true
	end
	
	
	// Get information we're about to use
	local Ent1 = self:GetEnt(1)

	if (not Ent1:GetTable().resources) then
		self:ClearObjects()
        self:GetOwner():SendLua( "GAMEMODE:AddNotify('Conduit destination invalid!', NOTIFY_GENERIC, 7);" )
		return
	end


	Dev_Unlink_All(Ent1)
	//constraint.RemoveConstraints(trace.Entity, "Rope")

	// Clear the objects so we're ready to go again
	self:ClearObjects()

	return true
end


function TOOL.BuildCPanel( CPanel )

	// HEADER
	CPanel:AddControl( "Header", { Text = "#Tool_dev_link_name", Description	= "#Tool_dev_link_desc" }  )
	CPanel:AddControl("ComboBox", {
		Label = "#Presets",
		MenuButton = "1",
		Folder = "link",

		Options = {
			Default = {
				dev_link_addlength = "4",
				dev_link_material = "cable/rope",
				dev_link_width = "3"
			}
		},

		CVars = {
			[0] = "dev_link_addlength",
			[1] = "dev_link_width",
			[2] = "dev_link_material"
		}
	})

	/*CPanel:AddControl("Slider", {
		Label = "#LinkTool_addlength",
		Type = "Float",
		Min = "-1000",
		Max = "1000",
		Command = "dev_link_addlength"
	})*/

	CPanel:AddControl("Slider", {
		Label = "#LinkTool_width",
		Type = "Float",
		Min = "1",
		Max = "20",
		Command = "dev_link_width"
	})

	CPanel:AddControl("MaterialGallery", {
		Label = "#LinkTool_material",
		Height = "64",
		Width = "32",
		Rows = "1",
		Stretch = "1",

		Options = {
			["Link"] = { Material = "cable/rope_icon", dev_link_material = "cable/rope" },
			["Cable 2"] = { Material = "cable/cable_icon", dev_link_material = "cable/cable2" },
			["XBeam"] = { Material = "cable/xbeam", dev_link_material = "cable/xbeam" },
			["Red Laser"] = { Material = "cable/redlaser", dev_link_material = "cable/redlaser" },
			["Blue Electric"] = { Material = "cable/blue_elec", dev_link_material = "cable/blue_elec" },
			["Physics Beam"] = { Material = "cable/physbeam", dev_link_material = "cable/physbeam" },
			["Hydra"] = { Material = "cable/hydra", dev_link_material = "cable/hydra" }
		},

		CVars = {
			[0] = "dev_link_material"
		}
	})
	
	CPanel:AddControl("Color", {
		Label = "#LinkTool_colour",
		Red = "dev_link_color_r",
		Green = "dev_link_color_g",
		Blue = "dev_link_color_b",
		ShowAlpha = "0",
		ShowHSV = "1",
		ShowRGB = "1",
		Multiplier = "255"
	})
	
end
