AddCSLuaFile( "cl_init.lua" )
AddCSLuaFile( "shared.lua" )

util.PrecacheSound( "Buttons.snd17" )

include('shared.lua')

local Ground = 1 + 0 + 2 + 8 + 32

function ENT:Initialize()
	self.NextThink = CurTime() +  1
	self.Entity:PhysicsInit( SOLID_VPHYSICS )
	self.Entity:SetMoveType( MOVETYPE_VPHYSICS )
	self.Entity:SetSolid( SOLID_VPHYSICS )
	
	local phys = self.Entity:GetPhysicsObject()
	
	if not (WireAddon == nil) then self.Inputs = Wire_CreateInputs(self.Entity, { "Open" }) end
	if not (WireAddon == nil) then self.Outputs = Wire_CreateOutputs(self.Entity, { "Open" }) end
	
	self.NextThink = CurTime() +  1
	RD_ValveState(self.Entity, 0)
	
	if (phys:IsValid()) then
		phys:Wake()
--		phys:SetMass(20)

	end
end

function ENT:Setup()
	self:TriggerInput("On", 0)
end

function ENT:TriggerInput(iname, value)
	if (iname == "Open") then
		if (value ~= 0) then
			if ( self.Active == 0 ) then
				self.Active = 1
				RD_ValveState(self, 1)
				self.Entity:EmitSound( "Buttons.snd17" )
				if not (WireAddon == nil) then Wire_TriggerOutput(self.Entity, "Open", 1) end
			end
		else
			if ( self.Active == 1 ) then
				self.Active = 0
				RD_ValveState(self, 0)
				self.Entity:EmitSound( "Buttons.snd17" )
				if not (WireAddon == nil) then Wire_TriggerOutput(self.Entity, "Open", 0) end
			end
		end
	end
end


function ENT:OnRemove()
	Dev_Unlink_All(self.Entity)
end

function ENT:Output()
	return 1
end

function ENT:Use()
end




function ENT:Think()
	if (self.Active == 1) then
		self:SetOverlayText( "Cutoff Valve(Open)" )
	else
		self:SetOverlayText( "Cutoff Valve(Closed)" )
	end
	if ( self.NextThink > CurTime() ) then return end
	self.NextThink = CurTime() +  1
	
end

function ENT:AcceptInput(name,activator,caller)
	if name == "Use" and caller:IsPlayer() and caller:KeyDownLast(IN_USE) == false then
		if ( self.Active == 0 ) then
			self.Active = 1
			RD_ValveState(self, 1)
			self.Entity:EmitSound( "Buttons.snd17" )
			if not (WireAddon == nil) then Wire_TriggerOutput(self.Entity, "Open", 1) end
		else
			self.Active = 0
			RD_ValveState(self, 0)
			self.Entity:EmitSound( "Buttons.snd17" )
			if not (WireAddon == nil) then Wire_TriggerOutput(self.Entity, "Open", 0) end
		end
	end
end

function ENT:PreEntityCopy()
	RD_BuildDupeInfo(self.Entity)
	if (WireAddon == 1) then
		local DupeInfo = Wire_BuildDupeInfo(self.Entity)
		if DupeInfo then
			duplicator.StoreEntityModifier( self.Entity, "WireDupeInfo", DupeInfo )
		end
	end
end

function ENT:PostEntityPaste( Player, Ent, CreatedEntities )
	RD_ApplyDupeInfo(Ent, CreatedEntities)
	if (WireAddon == 1) then
		if (Ent.EntityMods) and (Ent.EntityMods.WireDupeInfo) then
			Wire_ApplyDupeInfo(Player, Ent, Ent.EntityMods.WireDupeInfo, function(id) return CreatedEntities[id] end)
		end
	end
end
