AddCSLuaFile( "cl_init.lua" )
AddCSLuaFile( "shared.lua" )


include('shared.lua')

local Ground = 1 + 0 + 2 + 8 + 32

function ENT:Initialize()
	self.Entity:SetModel( "models/props_c17/oildrum001.mdl" )
	self.Entity:PhysicsInit( SOLID_VPHYSICS )
	self.Entity:SetMoveType( MOVETYPE_VPHYSICS )
	self.Entity:SetSolid( SOLID_VPHYSICS )
	local phys = self.Entity:GetPhysicsObject()
	self.NextThink = CurTime() +  1
	if (phys:IsValid()) then
		phys:Wake()
	end
	
	self.val1 = 0
	self.val2 = 0
	RD_AddResource(self.Entity, "stuff", 100)
	RD_AddResource(self.Entity, "junk", 100)
	
	RD_SupplyResource(self.Entity, "stuff", 100)
	RD_SupplyResource(self.Entity, "junk", 100)
	
end

function ENT:SpawnFunction( ply, tr )

	if ( !tr.Hit ) then return end

	local SpawnPos = tr.HitPos + tr.HitNormal * 16

	local ent = ents.Create( "barrel" )
	ent:SetPos( SpawnPos )
	ent:Spawn()
	ent:Activate()
	return ent
end


function ENT:OnRemove()
--	Dev_Unlink_All(self.Entity:GetTable().conduit)
end



function ENT:Think()
	self:SetOverlayText( "Stuff: " .. self.val1 .. "\nJunk: " .. self.val2 )
	if ( self.NextThink > CurTime() ) then return end
	self.val1 = RD_GetResourceAmount(self.Entity, "stuff")
	self.val2 = RD_GetResourceAmount(self.Entity, "junk")
	self.NextThink = CurTime() +  1
end


function ENT:PreEntityCopy()
	RD_BuildDupeInfo(self.Entity)
end

function ENT:PostEntityPaste( Player, Ent, CreatedEntities )
	RD_ApplyDupeInfo(Ent, CreatedEntities)
end