
TOOL.Category = '(Resource Dist.)'
TOOL.Name = '#Supply Connector'
TOOL.Command = nil
TOOL.ConfigName = ''

TOOL.ClientConVar["Pump"] =   "0"
TOOL.ClientConVar["Rate"] = "100"

cleanup.Register('connectors')
cleanup.Register( 'linkconstraints' )


if ( CLIENT ) then
	language.Add( 'Tool_sup_connector_name', 'Supply Connector' )
	language.Add( 'Tool_sup_connector_desc', 'Create a Supply Connector attached to any surface.' )
	language.Add( 'Tool_sup_connector_0', 'Left-Click: Spawn a Device.' )

	language.Add( 'Undone_SupplyConnector', 'Supply Connector Undone' )
	language.Add( 'Cleanup_SupplyConnector', 'Supply Connector' )
	language.Add( 'Cleaned_SupplyConnector', 'Cleaned up all Supply Connectors' )
	language.Add( 'SBoxLimit_connectors', 'Maximum Supply Connectors Reached' )
end

function TOOL:LeftClick( trace )
	if trace.Entity && (trace.Entity:IsPlayer() ) then return false end
	
	if(CLIENT) then
		return true
	end

	if(!SERVER) then return false end

	if ( !self:GetSWEP():CheckLimit( "connectors" ) ) then return false end
	
	local Pump = self:GetClientNumber("Pump")
	local Rate = math.floor(self:GetClientNumber("Rate"))

	local ply = self:GetOwner()
	local Pos = trace.HitPos
	local Ang = trace.HitNormal:Angle()
	Pos = Pos + self:Offset( trace.HitNormal:Angle(), Vector(-12, 13, 0) )
	ent = MakeSupplyConnector( ply, Ang, Pos, Pump, Rate )
	
	
	if ( trace.Entity:IsValid() ) then
		local const = constraint.Weld(ent, trace.Entity,0, trace.PhysicsBone, 0, systemmanager )
		nocollide = constraint.NoCollide( ent, trace.Entity, 0, trace.PhysicsBone )
		trace.Entity:DeleteOnRemove( ent )
	end

	undo.Create('SupplyConnectors')
		undo.AddEntity( ent)
		undo.AddEntity( const )
		undo.AddEntity( nocollide )
		undo.SetPlayer( ply )
	undo.Finish()


	ply:AddCleanup( 'supplyconnector', const )
	ply:AddCleanup( 'supplyconnector', nocollide )
	
	return true
end



function TOOL:RightClick( trace )
	return true
end


function TOOL:Reload(trace)
	return true
end




if SERVER then 
    CreateConVar('sbox_maxconnectors',4)
	
	function MakeSupplyConnector( ply, Ang, Pos, Pump, Rate )
		if ( !ply:CheckLimit( "connectors" ) ) then return nil end
		local ent = ents.Create( "res_pump" )
			if !ent:IsValid() then return false end
			ent:SetModel( "models/props_lab/tpplugholder_single.mdl" )
			ent:SetAngles(Ang)
			ent:SetPos(Pos)
		ent:Spawn()

		ent:SetVar('Owner',ply)

		local phys = ent:GetPhysicsObject()
		local NextThink = CurTime() +  1

		local resources = {}

		local rtable = {
			Active = 0,
			pump_active = Pump,
			pump_rate = Rate,
			resources = resources,
			NextThink = NextThink
			}
		table.Merge(ent:GetTable(), rtable )


		ply:AddCount('connectors', ent)
		
		return ent
	end
	duplicator.RegisterEntityClass("res_pump", MakeSupplyConnector, "Ang", "Pos", "Pump", "Rate", "Vel", "aVel", "frozen")

	
	
end

function TOOL.BuildCPanel( cp )
	cp:AddControl( 'Header', { Text = '#Tool_sup_connector_name', Description	= '#Tool_sup_connector_desc' }  )

	cp:AddControl("Checkbox", {Label = "#Uses Pump", Command = "sup_connector_Pump"})

	cp:AddControl("Slider", {Label = "#Transfer Rate(using pump)", Type	= "Float", Min = 0, Max = 500, Command = "sup_connector_Rate"})
end

function TOOL:UpdateGhostSupConnector( ent, player )

	if ( !ent ) then return end
	if ( !ent:IsValid() ) then return end

	local tr 	= utilx.GetPlayerTrace( player, player:GetCursorAimVector() )
	local trace 	= util.TraceLine( tr )
	if (!trace.Hit) then return end
	
--	if (trace.Entity && trace.Entity:GetClass() == "air_tank" || trace.Entity:IsPlayer() ) then
	if ( trace.Entity:IsPlayer() ) then

		ent:SetNoDraw( true )
		return

	end
	local Ang = trace.HitNormal:Angle()

	local min = ent:OBBMins()
	local Pos = trace.HitPos
	Pos = Pos + self:Offset( trace.HitNormal:Angle(), Vector(-12, 13, 0) )
	ent:SetPos( Pos )
	ent:SetAngles( Ang )

	ent:SetNoDraw( false )

end


function TOOL:Offset( ang, offsetvec )
	local offset = offsetvec
	local stackdir = ang:Up()
	
	offset = ang:Up() * offset.X + ang:Forward() * -1 * offset.Z + ang:Right() * offset.Y

	return stackdir * 2 + offset
end


function TOOL:Think()
	local model	= "models/props_lab/tpplugholder_single.mdl"
	
	if (!self.GhostEntity || !self.GhostEntity:IsValid() || self.GhostEntity:GetModel() != model) then
		self:MakeGhostEntity( model, Vector(0,0,0), Angle(0,0,0) )
	end
	self:UpdateGhostSupConnector( self.GhostEntity, self:GetOwner() )
end


