
TOOL.Category = '(Resource Dist.)'
TOOL.Name = '#Cutoff Valve'
TOOL.Command = nil
TOOL.ConfigName = ''


cleanup.Register('cutoffvalves')
cleanup.Register( 'linkconstraints' )


if ( CLIENT ) then
	language.Add( 'Tool_cutoff_valve_name', 'Cutoff Valve' )
	language.Add( 'Tool_cutoff_valve_desc', 'Create a Cutoff Valve attached to any surface.' )
	language.Add( 'Tool_cutoff_valve_0', 'Left-Click: Spawn a Device.' )

	language.Add( 'Undone_CutoffValve', 'Cutoff Valve Undone' )
	language.Add( 'Cleanup_CutoffValve', 'Cutoff Valve' )
	language.Add( 'Cleaned_CutoffValve', 'Cleaned up all Cutoff Valves' )
	language.Add( 'SBoxLimit_cutoffvalves', 'Maximum Cutoff Valve Reached' )
end

function TOOL:LeftClick( trace )
	if trace.Entity && (trace.Entity:IsPlayer() ) then return false end
	
	if(CLIENT) then
		return true
	end

	if(!SERVER) then return false end

	if ( !self:GetSWEP():CheckLimit( "cutoffvalves" ) ) then return false end

	local ply = self:GetOwner()
	local Pos = trace.HitPos
	local Ang = trace.HitNormal:Angle()
	Ang.pitch = Ang.pitch + 90

	ent = MakeCutoffValve( ply, Ang, Pos )
	ent:SetPos( trace.HitPos - trace.HitNormal * ent:OBBMins().z)
	
	
	if ( trace.Entity:IsValid() ) then
		local const = constraint.Weld(ent, trace.Entity,0, trace.PhysicsBone, 0, systemmanager )
		nocollide = constraint.NoCollide( ent, trace.Entity, 0, trace.PhysicsBone )
		trace.Entity:DeleteOnRemove( ent )
	end

	undo.Create('CutoffValves')
		undo.AddEntity( ent)
		undo.AddEntity( const )
		undo.AddEntity( nocollide )
		undo.SetPlayer( ply )
	undo.Finish()


	ply:AddCleanup( 'cutoffvalve', const )
	ply:AddCleanup( 'cutoffvalve', nocollide )
	
	return true
end



function TOOL:RightClick( trace )
	return true
end


function TOOL:Reload(trace)
	return true
end




if SERVER then 
    CreateConVar('sbox_maxcutoffvalves',4)
	
	function MakeCutoffValve( ply, Ang, Pos )
		if ( !ply:CheckLimit( "cutoffvalves" ) ) then return nil end
		local ent = ents.Create( "res_valve" )
			if !ent:IsValid() then return false end
			ent:SetModel( "models/props_c17/utilityconnecter006.mdl" )
			ent:SetAngles(Ang)
			ent:SetPos(Pos)
		ent:Spawn()

		ent:SetVar('Owner',ply)
		
		local phys = ent:GetPhysicsObject()
		local NextThink = CurTime() +  1
		
		local resources = {}
	
		local rtable = {
			Active = 0,
			resources = resources,
			NextThink = NextThink
			}
		table.Merge(ent:GetTable(), rtable )
		
			
		ply:AddCount('cutoffvalves', ent)
		
		return ent
	end
	duplicator.RegisterEntityClass("res_valve", MakeCutoffValve, "Ang", "Pos", "Active", "Vel", "aVel", "frozen")

	
	
end

function TOOL.BuildCPanel( cp )
	cp:AddControl( 'Header', { Text = '#Tool_cutoff_valve_name', Description	= '#Tool_cutoff_valve_desc' }  )
end

function TOOL:UpdateGhostStorageDevice( ent, player )

	if ( !ent ) then return end
	if ( !ent:IsValid() ) then return end

	local tr 	= utilx.GetPlayerTrace( player, player:GetCursorAimVector() )
	local trace 	= util.TraceLine( tr )
	if (!trace.Hit) then return end
	
	if ( trace.Entity:IsPlayer() ) then
	
		ent:SetNoDraw( true )
		return
		
	end
	
	local Ang = trace.HitNormal:Angle()
	Ang.pitch = Ang.pitch + 90
	ent:SetAngles( Ang )
	
	local min = ent:OBBMins()
	ent:SetPos( trace.HitPos - trace.HitNormal * min.z )
	
	ent:SetNoDraw( false )
	
end


function TOOL:Think()
	local model	= "models/props_c17/utilityconnecter006.mdl"
	
	if (!self.GhostEntity || !self.GhostEntity:IsValid() || self.GhostEntity:GetModel() != model) then
		self:MakeGhostEntity( model, Vector(0,0,0), Angle(0,0,0) )
	end
	self:UpdateGhostStorageDevice( self.GhostEntity, self:GetOwner() )
end


