AddCSLuaFile( "cl_init.lua" )
AddCSLuaFile( "shared.lua" )

util.PrecacheSound( "Buttons.snd17" )

include('shared.lua')

local Ground = 1 + 0 + 2 + 8 + 32
local NEW_PLUG_WAIT_TIME = 2
local PLUG_IN_SOCKET_CONSTRAINT_POWER = 5000
local PLUG_IN_ATTACH_RANGE = 20

function ENT:Initialize()
	self.NextThink = CurTime() +  1
	self.Entity:PhysicsInit( SOLID_VPHYSICS )
	self.Entity:SetMoveType( MOVETYPE_VPHYSICS )
	self.Entity:SetSolid( SOLID_VPHYSICS )
	
	local phys = self.Entity:GetPhysicsObject()
	self.damaged = 0
	
	if not (WireAddon == nil) then self.Inputs = Wire_CreateInputs(self.Entity, { "Deploy" }) end
	if not (WireAddon == nil) then self.Outputs = Wire_CreateOutputs(self.Entity, { "InUse" }) end
	
	self.ropelength = 0
	self.ropemax = 0
	self.NextThink = CurTime() +  1
	self.OtherSocket = nil
	self.MyPlug = nil
	self.Const = nil

	if (phys:IsValid()) then
		phys:Wake()
--		phys:SetMass(20)

	end
end

function ENT:Setup()
	self:TriggerInput("On", 0)
end

function ENT:TriggerInput(iname, value)
	if (iname == "Deploy") then
		if (value ~= 0) then
			if ( self.Active == 0 ) then
				self:Deploy(nil)
				self.Active = 1
				self.Entity:EmitSound( "Buttons.snd17" )
				if not (WireAddon == nil) then Wire_TriggerOutput(self.Entity, "InUse", 1) end
			end
		else
			if ( self.Active == 1 ) then
				if (self.ropemax == 0) then
					self.ropemax = 1000
				else
					self.ropemax = 0
				end
				self.Entity:EmitSound( "Buttons.snd17" )
			end
		end
	end
end

function ENT:OnRemove()
	if ((self.plug) and (self.plug:IsValid())) then self.plug:Remove() end
	if ((self.MyPlug) and (self.MyPlug:IsValid())) then self.MyPlug.MySocket = nil end

	Dev_Unlink_All(self.Entity)
end

function ENT:Output()
	return 1
end

function ENT:Use()
end



function ENT:ShowOutput( )
	if (self.Active == 1) then
		if(self.pump_active == 1) then
			self:SetOverlayText( "Supply Connector(In Use) \nPump Enabled: " .. "\nPump Rate" .. self.pump_rate )
		else
			self:SetOverlayText( "Supply Connector(In Use) ")
		end
	else
		if(self.pump_active == 1) then
			self:SetOverlayText( "Supply Connector(Ready) \nPump Enabled: " .. "\nPump Rate" .. self.pump_rate )
		else
			self:SetOverlayText( "Supply Connector(Ready) ")
		end
	end
end



function ENT:AttachPlug( plug )
	// Set references between them
	plug.MySocket = self.Entity
	self.MyPlug = plug
	
	// Position plug
	newpos = self.Entity:LocalToWorld( Vector(5,13,10) )
	local socketAng = self.Entity:GetAngles()
	plug:SetPos( newpos )
	plug:SetAngles( socketAng )
	
	self.NoCollideConst = constraint.NoCollide(self.Entity, plug, 0, 0)
	if (not self.NoCollideConst) then
	    self.MyPlug = nil
		plug.MySocket = nil
	    return
	end

	// Constrain together
	self.Const = constraint.Weld( self.Entity, plug, 0, 0, PLUG_IN_SOCKET_CONSTRAINT_POWER, true )
	if (not self.Const) then
	    self.NoCollideConst:Remove()
	    self.NoCollideConst = nil
	    self.MyPlug = nil
		plug.MySocket = nil
	    return
	end

	self.OtherSocket = plug.socket
	plug.socket.OtherSocket = self
	
	if (( self.pump_active == 0 ) and ( self.OtherSocket.pump_active == 0 )) then
		Dev_Link(self.Entity, self.OtherSocket)
	end
	
	-- Prepare clearup incase one is removed
	plug:DeleteOnRemove( self.Const )
	self.Entity:DeleteOnRemove( self.Const )
	self.Const:DeleteOnRemove( self.NoCollideConst )

--	plug:AttachedToSocket(self.Entity)
end



function ENT:Think()
	self:ShowOutput()
	if ( self.NextThink > CurTime() ) then return end
	self.NextThink = CurTime() +  1
	
	if (self.Active == 0) then
		-- If we have no plug in us
		if (not self.MyPlug) or (not self.MyPlug:IsValid()) then
			
			// Find entities near us
			local sockCenter = self.Entity:LocalToWorld( Vector(5,13,10) )
			
			local local_ents = ents.FindInSphere( sockCenter, PLUG_IN_ATTACH_RANGE )
			for key, plug in pairs(local_ents) do

				// If we find a plug, try to attach it to us
				if ( plug:IsValid() && (plug:GetVar("IsPlug",nil) == 1) ) then
					// If no other sockets are using it
					if plug.MySocket == nil then
					    local plugpos = plug:GetPos()
						local dist = (sockCenter-plugpos):Length()
	
						self:AttachPlug(plug)
						self.Active = 1
						if not (WireAddon == nil) then Wire_TriggerOutput(self.Entity, "InUse", 1) end
					end
				end
			end
		end
	else
		-- If we were unplugged, reset the plug and socket to accept new ones.
		if ((self.Const) and (not self.Const:IsValid())) then
			self.Const = nil
			self.NoCollideConst = nil
			if (self.MyPlug) and (self.MyPlug:IsValid()) then
				self.MyPlug.MySocket = nil
				self.MyPlug = nil
			end
			if not (self.OtherSocket == nil) then
				if (( self.pump_active == 0 ) and ( self.OtherSocket.pump_active == 0 )) then
					Dev_Unlink(self.Entity, self.OtherSocket.Entity)
				end
				self.OtherSocket.OtherSocket = nil
				self.OtherSocket = nil
			end
			self.Active = 0
			self.ropelength = 0
			if not (WireAddon == nil) then Wire_TriggerOutput(self.Entity, "InUse", 0) end
		end
		
		-- If we are connected and pump is active, transfer resources
		if not ( self.OtherSocket == nil ) then
			if not ( self.pump_active == 0 ) then
				for _, rtype1 in pairs( self.resources ) do
					for _, rtype2 in pairs( self.OtherSocket.resources ) do
						if ( rtype1.res_ID == rtype2.res_ID ) then
							if ( RD_GetResourceAmount(self.OtherSocket, rtype1.res_name) < RD_GetNetworkCapacity(self.OtherSocket, rtype1.res_name) ) then
								RD_SupplyResource(self.OtherSocket, rtype1.res_name, RD_ConsumeResource(self, rtype1.res_name, math.abs(self.pump_rate)))
							end
						end
					end
				end
			end
		end
		
		if ( self.ropemax > 0 ) then
			if (self.ropelength <= self.ropemax) then
				self.ropelength = (self.ropelength + 50)
				if ((self.constraint) and (self.constraint:IsValid())) then
					self.constraint:Fire("SetSpringLength", self.ropelength, 0)
				else
					self.ropemax = 0
					self.ropelength = 0
				end
				if ((self.rope) and (self.rope:IsValid())) then
					self.rope:Fire("SetLength", self.ropelength, 0)
				else
					self.ropemax = 0
					self.ropelength = 0
				end
			end
		else
			if (self.ropelength > 0) then
				self.ropelength = (self.ropelength - 50)
				if ((self.constraint) and (self.constraint:IsValid())) then
					self.constraint:Fire("SetSpringLength", self.ropelength, 0)
				else
					self.ropelength = 0
				end
				if ((self.rope) and (self.rope:IsValid())) then
					self.rope:Fire("SetLength", self.ropelength, 0)
				else
					self.ropelength = 0
				end
			else
				if not ((self.MyPlug) and (self.MyPlug:IsValid())) then
					if ((self.plug) and (self.plug:IsValid())) then self.plug:Remove() end
					self.constraint = nil
					self.rope = nil
					self.plug = nil
					self.Active = 0
					if not (WireAddon == nil) then Wire_TriggerOutput(self.Entity, "InUse", 0) end
				end
			end
		end
	end
end

function ENT:Deploy(ply)
		local pl = nil
		local Ent1 = self.Entity
		local Ent2 = nil
		local Bone1 = 0
		local Bone2 = 0
		local LPos1 = Vector(5,13,10)
		local LPos2 = Vector(10,0,0)
		local width = 3
		local fwd_speed = 50
		local bwd_speed = 50
		local material = "cable/cable2"
		
		pos = Ent1:LocalToWorld( Vector(15,13,10) )
		ang = Ent1:GetAngles() + Vector(180,0,0)
	
		local plug = ents.Create( "prop_physics" )
		plug:SetModel( "models/props_lab/tpplug.mdl" )
		plug:SetPos( pos )
		plug:SetAngles( ang )
		plug:SetColor( 255, 255, 255, 255 )
		plug:Spawn()
		local phys = plug:GetPhysicsObject()
		phys:EnableGravity( true )
--		phys:SetMass(20)
		phys:Wake()
		nocollide = constraint.NoCollide( Ent1, plug, 0, 0 )
		phys:EnableMotion( true )
		phys:SetVelocity(self.Entity:GetForward() * 50)
		plug:SetVar("IsPlug", 1)
		plug.MySocket = nil
		plug.socket = self
		self.plug = plug
		Ent2 = plug
		if not (ply == nil) then plug:SetVar('Owner',ply) end

		self.NextThink = CurTime()
		

		local const, rope = constraint.Elastic( Ent1, Ent2, Bone1, Bone2, LPos1, LPos2, 500, 0, 0, material, width, true )
--		local const, rope = constraint.Elastic( Ent1, Ent2, Bone1, Bone2, LPos1, LPos2, constant, dampen, 0, material, width, true )
--		local const, rope = constraint.Elastic( self.Entity, plug, 0, 0, Vector(0,0,0), Vector(0,0,0), 100, 100, 0, "cable/cable2", 1, true )
	
--		if ( !const ) then return nil, rope end
		
		local ctable = 
		{
				Type 		= "LSWinch",
				pl			= pl,
				Ent1		= Ent1,
				Ent2		= Ent2,
				Bone1		= Bone1,
				Bone2		= Bone2,
				LPos1		= LPos1,
				LPos2		= LPos2,
				width		= width,
				fwd_speed	= fwd_speed,
				bwd_speed	= bwd_speed,
				material	= material
		}
		const:SetTable( ctable )
		self.constraint = const
		self.rope = rope
		self.ropelength = 50
		self.ropemax = 1000
		self.nocollide = nocollide
		
		plug:DeleteOnRemove( self.constraint )
		self.Entity:DeleteOnRemove( self.constraint )
		self.constraint:DeleteOnRemove( self.nocollide )
end

function ENT:AcceptInput(name,activator,caller)
	if name == "Use" and caller:IsPlayer() and caller:KeyDownLast(IN_USE) == false then
		if ( self.Active == 0 ) then
			self:Deploy(caller)
			self.Active = 1
			self.Entity:EmitSound( "Buttons.snd17" )
			if not (WireAddon == nil) then Wire_TriggerOutput(self.Entity, "InUse", 1) end
		else
			if (self.ropemax == 0) then
				self.ropemax = 1000
			else
				self.ropemax = 0
			end
			self.Entity:EmitSound( "Buttons.snd17" )
		end
	end
end

function ENT:PreEntityCopy()
	RD_BuildDupeInfo(self.Entity)
	if (WireAddon == 1) then
		local DupeInfo = Wire_BuildDupeInfo(self.Entity)
		if DupeInfo then
			duplicator.StoreEntityModifier( self.Entity, "WireDupeInfo", DupeInfo )
		end
	end
end

function ENT:PostEntityPaste( Player, Ent, CreatedEntities )
	RD_ApplyDupeInfo(Ent, CreatedEntities)
	if (WireAddon == 1) then
		if (Ent.EntityMods) and (Ent.EntityMods.WireDupeInfo) then
			Wire_ApplyDupeInfo(Player, Ent, Ent.EntityMods.WireDupeInfo, function(id) return CreatedEntities[id] end)
		end
	end
end
