AddCSLuaFile( "cl_init.lua" )
AddCSLuaFile( "shared.lua" )


include('shared.lua')

local Ground = 1 + 0 + 2 + 8 + 32

function ENT:Initialize()
	self.Entity:SetModel( "models/props_junk/MetalBucket01a.mdl" )
	self.Entity:PhysicsInit( SOLID_VPHYSICS )
	self.Entity:SetMoveType( MOVETYPE_VPHYSICS )
	self.Entity:SetSolid( SOLID_VPHYSICS )
	local phys = self.Entity:GetPhysicsObject()
	self.NextThink = CurTime() +  1
	if (phys:IsValid()) then
		phys:Wake()
	end
	
	self.val1 = 0
	RD_AddResource(self.Entity, "crud", 100)
	RD_SupplyResource(self.Entity, "crud", 100)
	
end

function ENT:SpawnFunction( ply, tr )

	if ( !tr.Hit ) then return end

	local SpawnPos = tr.HitPos + tr.HitNormal * 16

	local ent = ents.Create( "bucket" )
	ent:SetPos( SpawnPos )
	ent:Spawn()
	ent:Activate()
	return ent
end

function ENT:Use()
end


function ENT:OnRemove()
--	Dev_Unlink_All(self.Entity:GetTable().conduit)
end


function ENT:ShowOutput(value)
	local net
	for _, r in pairs( self.Entity.resources ) do
		net = r.net_ID
	end
	
	self:SetOverlayText( "Crud: " .. value .. "\nNet: " .. net )
	return value
end

function ENT:Think()
	self:ShowOutput(self.val1)
	if ( self.NextThink > CurTime() ) then return end
	self.val1 = RD_GetResourceAmount(self.Entity, "crud")
	self.NextThink = CurTime() +  1
end


function ENT:AcceptInput(name,activator,caller)
	if name == "Use" and caller:IsPlayer() and caller:KeyDownLast(IN_USE) == false then
		RD_ConsumeResource(self, "crud", 10)
	end
end

function ENT:PreEntityCopy()
	RD_BuildDupeInfo(self.Entity)
end

function ENT:PostEntityPaste( Player, Ent, CreatedEntities )
	RD_ApplyDupeInfo(Ent, CreatedEntities)
end