-- shanjaq: Start Resource Distribution mod.

--Compatibility Global
RES_DISTRIB = 1

local Resource_Types = { }
local network_index = 1
RD_MAX_LINK_LENGTH = 2048
RD_EXTRA_LINK_LENGTH = 64

function Flatten_Network(resource)

	local devices = {}
	local net_max = 0
	
	local rd = nil	-- resource --root conduit is what we see first
	local d = nil
	
	local temproot = {}
	
	
	if not ( resource.ent.valve_state == 0 ) then
		rd = resource
	else
--		Msg( "Encountered Closed Root Valve.\n" )
		net_max = 0
		table.insert( devices, resource )
	
		local hash = {}
		hash.devices = devices
		hash.net_max = net_max
		
		return hash
--		for _, link in pairs( resource.links ) do
--			if not ( link.ent.valve_state == 0 ) then
--				Msg( "Setting new Root.\n" )
--				rd = link
--				break
--			else 
--				Msg( "Encountered Another Closed Root Valve.\n" )
--			end
--		end
	end

	
	if (rd == nil) then
		net_max = 0
		table.insert( devices, resource )
	
		local hash = {}
		hash.devices = devices
		hash.net_max = net_max
		
		return hash
	else
		table.insert( temproot, rd )  --first temproot is local
		ent = rd.ent
	end
	
	
	local found = 0
	if ( ent.Entity:IsValid() ) then
		net_max = net_max + rd.res_capacity
		table.insert( devices, rd )
	end
	
	for i, r in pairs( temproot ) do
		local j = 1

		while (j <= #r.links) do
			d = r.links[j]
			ent = d.ent
			found = 0
			for _, check in pairs( devices ) do
				if (ent == check.ent) then
					found = 1
					j = j + 1
					break
				end
			end
			if ( found == 0 ) then
				if ( ent.Entity ) and ( ent.Entity:IsValid() ) then
					if not ( ent.valve_state == 0 ) then
						table.insert( temproot, d )
						net_max = net_max + d.res_capacity
						table.insert( devices, d )
					else
--						Msg( "Encountered Closed Valve.\n" )
					end
					j = j + 1

				else
					table.remove( r.links, j )
				end
			end
		end
		
	end
	
	local hash = {}
	hash.devices = devices
	hash.net_max = net_max
	
	return hash
end


function Rebuild_Network(network, aggregate)
	local temproot = nil
	for _, check in pairs( network.devices ) do
		check.net_ID = network_index
		check.net_link = temproot  --build inverted singly-linked list by moving the root(no precog. required!)
		temproot = check
		
		check.net_max = network.net_max
		check.net_aggregate = aggregate
	end
	for _, check in pairs( network.devices ) do
		check.net_root = temproot
	end
	network_index = network_index + 1
end


function EnumResource(res)
	for _, check in pairs( Resource_Types ) do
		if (check.res_name == res) then return check.res_ID end
	end
	local NewID = #Resource_Types
	local hash = { }
	hash.ent = nil
	hash.res_name = res
	hash.res_ID = NewID
	hash.res_capacity = 0
	hash.net_aggregate = 0
	hash.net_max = 0
	hash.net_ID = 0
	hash.net_root = nil
	hash.net_link = nil
	hash.links = {}
	
	table.insert( Resource_Types, hash )
	return NewID
end

function GetResource(num)
	for _, check in pairs( Resource_Types ) do
		if (check.res_ID == num) then
			local val = table.Copy(check)
			val.net_root = val
			return val
		end
	end
	return nil
end

--Adds a named resource with the specified storage capacity to the ent
function RD_AddResource(ent, res, capacity)
	local ResID = EnumResource(res)
	if not ( ent.resources == nil ) then
		for _, check in pairs( ent.resources ) do
			if (check.res_ID == ResID) then
				check.res_capacity = capacity
				return
			end
		end
	else
		local resources = {}
	
		local rtable = {
			resources = resources
			}
	
		table.Merge(ent:GetTable(), rtable )
	end
	
	local Resource = GetResource(ResID)
	Resource.ent = ent
	Resource.res_capacity = capacity
	Resource.net_max = capacity
	table.insert( ent.resources, Resource )
end


--Consumes a named resource from the entity
function RD_ConsumeResource(ent, res, amount)
	local result = 0
	local ResID = EnumResource(res)
	for _, check in pairs( ent.resources ) do
		if (check.res_ID == ResID) then
			if (check.net_aggregate >= amount) then
				check.net_aggregate = check.net_aggregate - amount
				result = amount
			elseif (check.net_aggregate > 0) then
				result = check.net_aggregate
				check.net_aggregate = 0
			end
			--distribute aggregate here
			if (result > 0) then
				local device = check.net_root
				while not (device == nil) do
					device.net_aggregate = check.net_aggregate
					device = device.net_link
				end
			end
			break
		end
	end
	return result
end

--Replenishes a named resource on the entity by a specified amount
function RD_SupplyResource(ent, res, amount)
	local result = 0
	local ResID = EnumResource(res)
	for _, check in pairs( ent.resources ) do
		if (check.res_ID == ResID) then
			if ((check.net_max - check.net_aggregate) >= amount) then
				result = amount
				check.net_aggregate = check.net_aggregate + amount
			elseif ((check.net_max - check.net_aggregate) > 0) then
				result = (check.net_max - check.net_aggregate)
				check.net_aggregate = check.net_max
			end
			--distribute aggregate here
			if (result > 0) then
--				Msg( check.res_name .. "\n" )
				local device = check.net_root
				while not (device == nil) do
					device.net_aggregate = check.net_aggregate
					device = device.net_link
				end
			end
			break
		end
	end
	return result
end

--Returns true if device uses resource
function RD_CheckResource(ent, res)
	local ResID = EnumResource(res)
	for _, check in pairs( ent.resources ) do
		if (check.res_ID == ResID) then
			return 1
		end
	end
	return 0
end

--Returns the amount of a named resource accessable to the entity
function RD_GetResourceAmount(ent, res)
	local ResID = EnumResource(res)
	for _, check in pairs( ent.resources ) do
		if (check.res_ID == ResID) then
			return check.net_aggregate
		end
	end
	return 0
end

--Returns the maximum storage capacity of a specified entity, disregarding the network size(for named resource only)
function RD_GetUnitCapacity(ent, res)
	local ResID = EnumResource(res)
	for _, check in pairs( ent.resources ) do
		if (check.res_ID == ResID) then
			return check.res_capacity
		end
	end
	return 0
end

--Returns the maximum storage capacity of an entire network accessable to the entity(for named resource only)
function RD_GetNetworkCapacity(ent, res)
	local ResID = EnumResource(res)
	for _, check in pairs( ent.resources ) do
		if (check.res_ID == ResID) then
			return check.net_max
		end
	end
	return 0
end

--Disables or Enables the passage of all resources through this device(0 = closed, 1 = open)
function RD_ValveState(ent, toggle)
	if not (toggle == 0) then toggle = 1 end
	
	if ( toggle == 0 ) then ent.valve_state = 0 end

	if not (ent.resources == nil) then
		for _, rtype in pairs( ent.resources ) do
			local networks = {}
			for _, device in pairs( rtype.links ) do
				local network = Flatten_Network( device )
				--don't add redundant networks
				local found = 0
				for _, check_net in pairs( networks ) do
					for _, check_dev in pairs ( check_net.devices ) do
						if ( device.ent == check_dev.ent ) then
--							Msg( "Found a redundant network\n" )
							found = 1
							break
						end
					end
					if (found == 1) then break end
				end
				if ( found == 0 ) then
					table.insert( networks, network )
				else
					found = 0
				end
			end
			
			
			local distrib = 0
			if ( toggle == 1 ) then
				ent.valve_state = 1
				for _, network in pairs( networks ) do
					distrib = distrib + network.devices[1].net_aggregate
				end
				local network = Flatten_Network( rtype )
--				Msg( "Rebuilding " .. rtype.res_name .. "\n")
				Rebuild_Network(network, distrib)
			else
				for _, network in pairs( networks ) do
					distrib = math.ceil(rtype.net_aggregate * (network.net_max / rtype.net_max))
--					Msg( "Rebuilding " .. rtype.res_name .. "\n")
					Rebuild_Network(network, distrib)
				end
			end
			
		end
	end
	return 0
end


function Dev_Link(ent1, ent2, LPos1, LPos2, material, color, width)
	
	--only make beam if parameters call for it
	if (LPos1) and (LPos2) and (material) and (color) and (width) then
		RDbeamlib.MakeSimpleBeam(ent1, LPos1, ent2, LPos2, material, color, width)
	end
	
	--make sure resources aren't already part of the same network!
	--if resources are already part of the same network, don't add aggregate
	
--	ent1:SetColor( 255, 0, 0, 255 )
--	ent2:SetColor( 0, 0, 255, 255 )
	
	local Ent1_class = ent1:GetClass()
	local Ent2_class = ent2:GetClass()
	
	if (Ent1_class == "prop_vehicle_prisoner_pod")
	or (Ent1_class == "prop_vehicle_airboat")
	or (Ent1_class == "prop_vehicle_jeep") then
		if (ent1.environment == nil) then
			LS_RegisterEnt(ent1)
			RD_AddResource(ent1, "air", 0)
			RD_AddResource(ent1, "energy", 0)
			RD_AddResource(ent1, "coolant", 0)
		end
	end
	if (Ent2_class == "prop_vehicle_prisoner_pod")
	or (Ent2_class == "prop_vehicle_airboat")
	or (Ent2_class == "prop_vehicle_jeep") then
		if (ent2.environment == nil) then
			LS_RegisterEnt(ent2)
			RD_AddResource(ent2, "air", 0)
			RD_AddResource(ent2, "energy", 0)
			RD_AddResource(ent2, "coolant", 0)
		end
	end
	
	if ((Ent1_class == "res_pump") or (Ent1_class == "res_valve")) then
		for _, check in pairs( ent2.resources ) do
			RD_AddResource(ent1, check.res_name, 0)
			Msg( "Adding " .. check.res_name .. "\n" )
		end
	end
	if ((Ent2_class == "res_pump") or (Ent2_class == "res_valve")) then
		for _, check in pairs( ent1.resources ) do
			RD_AddResource(ent2, check.res_name, 0)
			Msg( "Adding " .. check.res_name .. "\n" )
		end
	end
	
	for _, rtype1 in pairs( ent1.resources ) do
		for _, rtype2 in pairs( ent2.resources ) do
			if ( rtype1.res_ID == rtype2.res_ID ) then  --resources shared
--				Msg( "Shared " .. rtype1.res_name .. "\n" )
				local found = 0
				local network1 = Flatten_Network(rtype1)
				for _, check in pairs( network1.devices ) do
					if ( check.ent == ent2 ) then
						found = 1
						break
					end
				end
				table.insert( rtype1.links, rtype2 )
				table.insert( rtype2.links, rtype1 )
				
				if (( rtype1.net_ID != rtype2.net_ID ) or (( rtype1.net_ID + rtype2.net_ID ) == 0 ))  then  --avoid redundant traversal
					if ( found == 0 ) then  --ok to add aggregate
						local network = Flatten_Network(rtype1)
						local distrib = (rtype1.net_aggregate * (rtype1.ent.valve_state or 1)) + (rtype2.net_aggregate * (rtype2.ent.valve_state or 1))
						Rebuild_Network(network, distrib)
					end
				end
			end
		end
	end


end

function Dev_Unlink_All(ent1)
	RDbeamlib.ClearAllBeamsOnEnt( ent1 )
	
	for _, rtype in pairs( ent1.resources ) do
		local links = {}
		local networks = {}
		local shared = 0
		local i = 1
		while ( i <= #rtype.links ) do  --remove forward links
			table.insert( links, rtype.links[i] )
			table.remove( rtype.links, i )
		end
		for _, check in pairs( links ) do  --remove backward links
			for j, bcheck in pairs( check.links ) do
				if ( bcheck.ent == ent1 ) then
					table.remove( check.links, j )
					break
				end
			end
		end
		for _, check in pairs( links ) do  --only include networks with shared resources and open valves
			if not ( check.ent.valve_state == 0 ) and ( check.ent.resources )then
				for _, rtype2 in pairs( check.ent.resources ) do
					if ( rtype2.res_ID == rtype.res_ID ) then
						local network = Flatten_Network(check)
						table.insert( networks, network )
						shared = 1
						break
					end
				end
			end
		end
		
		if (( shared == 1 ) and ( ent1.valve_state != 0 )) then
		
			local found = 0
			
			i = 1
			while ( i < #networks ) do
			
				local j = 1
				while ( j < #networks ) do
				
					if not ( i == j ) then  --eliminate redundant networks
						for _, check in pairs( networks[j].devices ) do
							if ( check.ent == networks[i].devices[1].ent ) then
								found = 1
								break
							end
						end
						if (found == 1) then
--							Msg( "Removing redundant network.\n" )
							table.remove( networks, j )
							break
						end
					
					end
				
					j = j + 1
				end
			
				if ( found == 0 ) then
					i = i + 1
				else
					found = 0
					i = 1
				end
			end


			local current = Flatten_Network(rtype)
			table.insert( networks, current )
			
			for _, network in pairs( networks ) do
				local net_aggregate = rtype.net_aggregate
				local net_max = rtype.net_max
				if ( net_max == 0 ) then net_max = 1 end
				local distrib = math.floor(network.net_max * (net_aggregate / net_max))
--				Msg( "Distributed " .. distrib .. " " .. rtype.res_name .. " on net " .. rtype.net_ID .. "\n" )
				Rebuild_Network(network, distrib)
			end
		end
	end

end


function Dev_Unlink(ent1, ent2)
	RDbeamlib.ClearBeam( ent1, ent2 )
	
	local i = 0
	for _, rtype1 in pairs( ent1.resources ) do
		i = 1
		while (i <= #rtype1.links) do
			if ( rtype1.links[i].ent == ent2 ) then
				table.remove( rtype1.links, i )
				break
			end
			i = i + 1
		end
	end
	
	for _, rtype2 in pairs( ent2.resources ) do
		i = 1
		while (i <= #rtype2.links) do
			if ( rtype2.links[i].ent == ent1 ) then
				table.remove( rtype2.links, i )
				break
			end
			i = i + 1
		end
	end
	
	for _, rtype1 in pairs( ent1.resources ) do
		for _, rtype2 in pairs( ent2.resources ) do
			if ( rtype1.res_ID == rtype2.res_ID ) then
				local found = 0
				local network1 = Flatten_Network(rtype1)
				for _, d in pairs( network1.devices ) do
					if ( d.ent == ent2 ) then
						found = 1
						break
					end
				end
				if ( found == 0 ) then	--confirmed network separation, distribute average then balance
					local net_aggregate = rtype1.net_aggregate
					local net_max = rtype1.net_max
					if ( net_max == 0 ) then net_max = 1 end
					local network2 = Flatten_Network(rtype2)
					local distrib1 = math.floor(network1.net_max * (net_aggregate / net_max))
					local distrib2 = math.floor(network2.net_max * (net_aggregate / net_max))
					
					if not ( ent1.valve_state == 0 ) then Rebuild_Network(network1, distrib1) end
					if not ( ent2.valve_state == 0 ) then Rebuild_Network(network2, distrib2) end
					
				end
			end
		end
	end
	
end


--TAD2020: duplicator support
--build the DupeInfo table and save it as an entity mod

function RD_BuildDupeInfo( Ent )
	if !Ent:GetTable().resources then return end
	
	local info = {}
	info.devices = {}
	
	local beamtable = RDbeamlib.GetBeamTable( Ent )
	info.beams = {}
	
	for _, rtype in pairs( Ent:GetTable().resources ) do
		for _, device in pairs( rtype.links ) do
			if not ( device.ent == nil ) then 
				table.insert(info.devices, device.ent.Entity:EntIndex())
				
				if beamtable[device.ent.Entity] then
					info.beams[device.ent.Entity:EntIndex()] = beamtable[device.ent.Entity]
				end
			end
		end
	end
	
	if info.devices then
		duplicator.StoreEntityModifier( Ent, "RDDupeInfo", info )
	end
	
end

--apply the DupeInfo
function RD_ApplyDupeInfo( Ent, CreatedEntities )
	if (Ent.EntityMods) and (Ent.EntityMods.RDDupeInfo) and (Ent.EntityMods.RDDupeInfo.devices) then
	
		
		for k,ent2id in pairs(Ent.EntityMods.RDDupeInfo.devices) do
			ent2 = CreatedEntities[ ent2id ]
			if ent2 and ent2.Entity and ent2.Entity:IsValid() then
				//Dev_Link(Ent, ent2)
				if (Ent.EntityMods.RDDupeInfo.beams) and (Ent.EntityMods.RDDupeInfo.beams[ent2id]) then
					Dev_Link(
						Ent, ent2, 
						Ent.EntityMods.RDDupeInfo.beams[ent2id].start_pos, 
						Ent.EntityMods.RDDupeInfo.beams[ent2id].dest_pos, 
						Ent.EntityMods.RDDupeInfo.beams[ent2id].material, 
						Ent.EntityMods.RDDupeInfo.beams[ent2id].color, 
						Ent.EntityMods.RDDupeInfo.beams[ent2id].width
					)
				else
					Dev_Link(Ent, ent2)
				end
			end
		end
	end
end	

function RD_AfterPasteMods(ply, Ent, DupeInfo)
	--doesn't need to do anything for now
end
--TAD2020: end duplicator support


-- shanjaq: End Resource Distribution mod.
