--======MSG STYLES==========
wstylemsg					= 2			--1 = original, 2 = gmodtext(default), 3 = chat msg
--=============================

wings								= {}
wings.settings						= {}
wings.settings.wingArea				= 0.005		-- 0.005 sq. meters (will be multiplied by mass for default area)
wings.settings.airDensity			= 1.225
wings.settings.waterDensity			= 1000
wings.settings.liftCoefficient		= 1
wings.settings.dragCoefficient		= 0.6		-- lift + no drag = infinite crazy prop motion
wings.time							= _CurTime()
wings.wingEntities					= {}
wings.commands						= {}

function wings.wingsThink()
	
	-- Calculate the time that the last frame took
	local time						= _CurTime()
	local timeDiff					= time - wings.time
	wings.time						= time
	
	if timeDiff ~= 0 then			-- Divide by zero errors suck
		for wingID, wingData in wings.wingEntities do
			if _EntExists( wingID ) then
			
				-- Calculate wing velocity
				local pos							= _EntGetPos( wingID )
				local ang							= _EntGetForwardVector( wingID )
				local velocity						= vecDotProduct( ang, vecSub( wingData.pos, pos ) ) / timeDiff
				local direction
				if velocity ~= 0 then
					direction					= vecNormalize( vecSub( wingData.pos, pos ) )
				else
					direction					= vector3( 0, 0, 0 )
				end
				wings.wingEntities[wingID].ang		= ang
				wings.wingEntities[wingID].pos		= pos
				
				-- Set density to either water or air
				local density
				if _EntGetWaterLevel( wingID ) >= 2 then
					density							= wings.settings.waterDensity
				else
					density							= wings.settings.airDensity
				end
				
				-- Calculate wing lift scaled by time of last frame.  Formula from http://en.wikipedia.org/wiki/Lift_(force).
				local lift							= wingData.liftCoefficient * density * ( velocity ^ 2 * 0.5 ) * wingData.area * timeDiff
				
				-- Calculate wing drag scaled by time of last frame.  Formula from http://en.wikipedia.org/wiki/Drag_equation.
				local drag							= 0.5 * density * velocity ^ 2 * wingData.area * wingData.dragCoefficient * timeDiff
			
				--[[ Must figure out how to properly convert newtons to the crazy source units
				lift								= lift * 39.3700787
				drag								= drag * 39.3700787
				]]--
			
				-- Calculate net force
				local netForce						= vecAdd(
				vecMul( _EntGetUpVector( wingID ), vector3( lift, lift, lift ) ),			-- lift
				vecMul( direction, vector3( drag, drag, drag ) )							-- drag
				)
			
				-- Apply force
				_phys.ApplyForceCenter( wingID, netForce )
				
			else
			
				-- Entity doesn't exist, remove it from the table
				wings.wingEntities[wingID]			= nil
				
			end
		end
	end
	
end
AddThinkFunction( wings.wingsThink )

function wings.commands.makeWing( fromplayer, args )
	
	local pos									= _PlayerGetShootPos( fromplayer )
	local ang									= _PlayerGetShootAng( fromplayer )
	
	_TraceLine( pos, ang, 1024, fromplayer )
	if not _TraceHitNonWorld() then return end
	local wingID								= _TraceGetEnt()
	if not _phys.HasPhysics( wingID ) then return end
	wings.wingEntities[wingID]					= {}
	wings.wingEntities[wingID].pos				= _EntGetPos( wingID )
	wings.wingEntities[wingID].ang				= _EntGetAng( wingID )
	wings.wingEntities[wingID].area				= wings.settings.wingArea * _phys.GetMass( wingID )	-- Use mass to guess area
	wings.wingEntities[wingID].liftCoefficient	= wings.settings.liftCoefficient
	wings.wingEntities[wingID].dragCoefficient	= wings.settings.dragCoefficient
	
	if wstylemsg == 1 then
		_PrintMessage( fromplayer, HUD_PRINTCENTER, "Wing Created!" )
	elseif wstylemsg == 2 then
		_GModText_Start( "ClientTitleFont" )
		_GModText_SetPos( 0.35, 0 )
		_GModText_SetColor( 0, 150, 255, 240 )
		_GModText_SetTime( 3, 0.5, 0.5 )
		_GModText_SetText( "Wing Created!" )
		_GModText_Send( fromplayer, 600 )
	else
		_PrintMessage( fromplayer, HUD_PRINTTALK, "Wing Created!" )
	end
	
end
CONCOMMAND( "wings_makewing", wings.commands.makeWing )

function wings.commands.setDrag( fromplayer, args )
	
	local pos									= _PlayerGetShootPos( fromplayer )
	local ang									= _PlayerGetShootAng( fromplayer )
	
	_TraceLine( pos, ang, 1024, fromplayer )
	if not _TraceHitNonWorld() then return end
	local wingID								= _TraceGetEnt()
	if not wings.wingEntities[wingID] then return end
	wings.wingEntities[wingID].dragCoefficient	= tonumber(args)
	
	_PrintMessage( fromplayer, HUD_PRINTCENTER, "Drag set to: " .. args )
	
end
CONCOMMAND( "wings_setdrag", wings.commands.setDrag )

function wings.commands.setLift( fromplayer, args )
	
	local pos									= _PlayerGetShootPos( fromplayer )
	local ang									= _PlayerGetShootAng( fromplayer )
	
	_TraceLine( pos, ang, 1024, fromplayer )
	if not _TraceHitNonWorld() then return end
	local wingID								= _TraceGetEnt()
	if not wings.wingEntities[wingID] then return end
	wings.wingEntities[wingID].liftCoefficient	= tonumber(args)
	
	_PrintMessage( fromplayer, HUD_PRINTCENTER, "Lift set to: " .. args )
	
end
CONCOMMAND( "wings_setlift", wings.commands.setLift )

function wings.commands.setArea( fromplayer, args )
	
	local pos									= _PlayerGetShootPos( fromplayer )
	local ang									= _PlayerGetShootAng( fromplayer )
	
	_TraceLine( pos, ang, 1024, fromplayer )
	if not _TraceHitNonWorld() then return end
	local wingID								= _TraceGetEnt()
	if not wings.wingEntities[wingID] then return end
	wings.wingEntities[wingID].area				= tonumber(args)
	
	_PrintMessage( fromplayer, HUD_PRINTCENTER, "Area set to: " .. args )
	
end
CONCOMMAND( "wings_setarea", wings.commands.setArea )
--=========================================================
--here's where the adding/subtracting functions beggin(seiken)
--=========================================================
function wmsgstyles( fromplayer, args )
	wstylemsg = tonumber(args)
end
CONCOMMAND( "wings_msgstyle", wmsgstyles )

function wmsgwings( fromplayer, msgstr, msgvar ) --function used to send messages
	if wstylemsg == 1 then
		_PrintMessage( fromplayer, HUD_PRINTCENTER, msgstr .. msgvar  )
	elseif wstylemsg == 2 then
		_GModText_Start( "ClientTitleFont" )
		_GModText_SetPos( 0.35, 0 )
		_GModText_SetColor( 0, 150, 255, 240 )
		_GModText_SetTime( 3, 0.5, 0.5 )
		_GModText_SetText( msgstr .. msgvar  )
		_GModText_Send( fromplayer, 600 )
	else
		_PrintMessage( fromplayer, HUD_PRINTTALK, msgstr .. msgvar  )
	end	
end
	
function wings.commands.inclift( fromplayer, args )
	
	local pos									= _PlayerGetShootPos( fromplayer )
	local ang									= _PlayerGetShootAng( fromplayer )
	
	_TraceLine( pos, ang, 1024, fromplayer )
	if not _TraceHitNonWorld() then return end
	local wingID								= _TraceGetEnt()
	if not wings.wingEntities[wingID] then return end
	if args == "cl" then --to check current set values
		wmsgwings( fromplayer, "Lift at ", wings.wingEntities[wingID].liftCoefficient )
	return end
	wings.wingEntities[wingID].liftCoefficient	= wings.wingEntities[wingID].liftCoefficient + args --easiest solution possible
	
	wmsgwings( fromplayer, "Lift set to ", wings.wingEntities[wingID].liftCoefficient )
	
end
CONCOMMAND( "wings_inclift", wings.commands.inclift )

function wings.commands.declift( fromplayer, args )
	
	local pos									= _PlayerGetShootPos( fromplayer )
	local ang									= _PlayerGetShootAng( fromplayer )
	
	_TraceLine( pos, ang, 1024, fromplayer )
	if not _TraceHitNonWorld() then return end
	local wingID								= _TraceGetEnt()
	if not wings.wingEntities[wingID] then return end
	wings.wingEntities[wingID].liftCoefficient	= wings.wingEntities[wingID].liftCoefficient - args
	
	wmsgwings( fromplayer, "Lift set to ", wings.wingEntities[wingID].liftCoefficient )
	
end
CONCOMMAND( "wings_declift", wings.commands.declift )

function wings.commands.incdrag( fromplayer, args )
	
	local pos									= _PlayerGetShootPos( fromplayer )
	local ang									= _PlayerGetShootAng( fromplayer )
	
	_TraceLine( pos, ang, 1024, fromplayer )
	if not _TraceHitNonWorld() then return end
	local wingID								= _TraceGetEnt()
	if not wings.wingEntities[wingID] then return end
	if args == "cd" then
		wmsgwings( fromplayer, "Drag at ", wings.wingEntities[wingID].dragCoefficient )
	return end
	wings.wingEntities[wingID].dragCoefficient = wings.wingEntities[wingID].dragCoefficient + args
	
	wmsgwings( fromplayer, "Drag set to ", wings.wingEntities[wingID].dragCoefficient )
	
end
CONCOMMAND( "wings_incdrag", wings.commands.incdrag )

function wings.commands.decdrag( fromplayer, args )
	
	local pos									= _PlayerGetShootPos( fromplayer )
	local ang									= _PlayerGetShootAng( fromplayer )
	
	_TraceLine( pos, ang, 1024, fromplayer )
	if not _TraceHitNonWorld() then return end
	local wingID								= _TraceGetEnt()
	if not wings.wingEntities[wingID] then return end
	wings.wingEntities[wingID].dragCoefficient = wings.wingEntities[wingID].dragCoefficient - args
	
	wmsgwings( fromplayer, "Drag set to ", wings.wingEntities[wingID].dragCoefficient )
	
end
CONCOMMAND( "wings_decdrag", wings.commands.decdrag )

function wings.commands.incarea( fromplayer, args )
	
	local pos									= _PlayerGetShootPos( fromplayer )
	local ang									= _PlayerGetShootAng( fromplayer )
	
	_TraceLine( pos, ang, 1024, fromplayer )
	if not _TraceHitNonWorld() then return end
	local wingID								= _TraceGetEnt()
	if not wings.wingEntities[wingID] then return end
	if args == "ca" then
		wmsgwings( fromplayer, "Area at ", wings.wingEntities[wingID].area )
	return end
	wings.wingEntities[wingID].area = wings.wingEntities[wingID].area + args
	
	wmsgwings( fromplayer, "Area set to ", wings.wingEntities[wingID].area )
	
end
CONCOMMAND( "wings_incarea", wings.commands.incarea )

function wings.commands.decarea( fromplayer, args )
	
	local pos									= _PlayerGetShootPos( fromplayer )
	local ang									= _PlayerGetShootAng( fromplayer )
	
	_TraceLine( pos, ang, 1024, fromplayer )
	if not _TraceHitNonWorld() then return end
	local wingID								= _TraceGetEnt()
	if not wings.wingEntities[wingID] then return end
	wings.wingEntities[wingID].area = wings.wingEntities[wingID].area - args
	
	wmsgwings( fromplayer, "Area set to ", wings.wingEntities[wingID].area )
	
end
CONCOMMAND( "wings_decarea", wings.commands.decarea )
--=========================================================
--and here's where they end.
--=========================================================
function wings.commands.help( fromplayer, args )

	_PrintMessage( fromplayer, HUD_PRINTCONSOLE, "Wing Script Help:\n\nAll commands taget the prop you are looking at.\n\nCommands:" )
	_PrintMessage( fromplayer, HUD_PRINTCONSOLE, "wings_makewing\t- Turns prop into a wing." )
	_PrintMessage( fromplayer, HUD_PRINTCONSOLE, "wings_setdrag\t- Sets the prop's drag coefficient.  Default is " .. wings.settings.dragCoefficient )
	_PrintMessage( fromplayer, HUD_PRINTCONSOLE, "wings_setlift\t- Sets the prop's lift coefficient.  Default is " .. wings.settings.liftCoefficient )
	_PrintMessage( fromplayer, HUD_PRINTCONSOLE, "wings_setarea\t- Sets the peop's area." )
	
end
CONCOMMAND( "wings_help", wings.commands.help )
