
_EntPrecacheModel( "models/props_junk/watermelon01.mdl" );


-- Information on HoverBalls
EntityInfo = {};
for i = 1, 2048 do
	EntityInfo[i] = {};
	EntityInfo[i].Hight = 64.0;
	EntityInfo[i].Force = 200.0;
	EntityInfo[i].HoverEnabled = false;
	EntityInfo[i].AttachedObject = null;
end

-- Player Information
PlayerInfo = {};
for i = 1, _MaxPlayers( ) do
	PlayerInfo[i] = {};
	PlayerInfo[i].LastHight = 64.0;
	PlayerInfo[i].LastForce = 1000.0;
end

-- HoverBall handlers
function ProcessHoverBall( HoverBall )
	-- Get the position of the HoverBall
	local vBallPos = _EntGetPos( HoverBall );
	
	--one trace for the ground
	_TraceSetMask( 131083 );
	_TraceLine( vBallPos, vector3(0,0,-1), 32768, HoverBall );
	local a = vecLength( vecSub( vBallPos, _TraceEndPos() ) );
	
	--one trace for water
	_TraceSetMask( MASK_WATER );
	_TraceLine( vBallPos, vector3(0,0,-1), 32768, HoverBall );
	local a2nd = vecLength( vecSub( vBallPos, _TraceEndPos() ) );
	
	if ( _TraceDidHitWater() > 0 ) then --Did our water trace hit water?
		if ( _EntGetWaterLevel( EntityInfo[HoverBall].AttachedObject ) >= 1 ) then --is our hoverballs object below water?
			a = 1;--if below water our hight is set low as to always push up.
		else
			a = a2nd;--if above water, makit it the hight above water
		end
	end
	
	
	local b = EntityInfo[HoverBall].Hight;
	local force = EntityInfo[HoverBall].Force;
	local c = b - a;
	

	if ( a < b ) then
		if ( c > 50 ) then
			force = EntityInfo[HoverBall].Force;
			_phys.ApplyForceCenter( HoverBall, vector3( 0, 0, force ) );
			return;
		else
			force = (( c / 50 ) * EntityInfo[HoverBall].Force);
			_phys.ApplyForceCenter( HoverBall, vector3( 0, 0, force ) );
			return;
		end
	end
end

-- Thinks
function HoverBallsThink( )
	-- Find all Hoverballs
	local eHoverBalls = _EntitiesFindByClass( "prop_physics" );
	for _,entity in eHoverBalls do
		-- Process HoverBalls
		if( EntityInfo[entity].HoverEnabled == true ) then
			ProcessHoverBall( entity );
		end
	end
end
AddThinkFunction( HoverBallsThink );

function sethoverballhight( player, args )
	PlayerInfo[player].LastHight = tonumber( args );
end
CONCOMMAND( "set_hoverballs_hight", sethoverballhight );

function sethoverballforce( player, args )
	PlayerInfo[player].LastForce = tonumber( args );
end
CONCOMMAND( "set_hoverballs_force", sethoverballforce );


function spawnHoverBall( player, args )
	if ( not _PlayerInfo( player, "alive" ) ) then return; end
	local vecpos = _PlayerGetShootPos( player );
	local plyang = _PlayerGetShootAng( player );
	_TraceLine( vecpos, plyang, 4096, player );

	if ( _TraceHitNonWorld() == false ) then return; end
	
	local ent = _TraceGetEnt( );
	
	local HoverBall = _EntCreate( "prop_physics" );
		_EntSetModel( HoverBall, "models/props_junk/watermelon01.mdl" );
		_EntSetPos( HoverBall,  _TraceEndPos() );
		--_EntSetOwner( HoverBall, player );
	_EntSpawn( HoverBall );
	_PhysEnableCollisions( HoverBall, false );
	WeldEntities( HoverBall, ent );
	
	
	
	local newhight = PlayerInfo[player].LastHight;
	local newforce = PlayerInfo[player].LastForce;
	
	
	EntityInfo[HoverBall].HoverEnabled = true;
	EntityInfo[HoverBall].Hight = newhight;
	EntityInfo[HoverBall].Force = newforce;
	EntityInfo[HoverBall].AttachedObject = ent;
	
end
CONCOMMAND( "spawn_hoverball", spawnHoverBall );


function removeHoverBall( player, args )
	local vecpos = _PlayerGetShootPos( player );
	local plyang = _PlayerGetShootAng( player );
	_TraceLine( vecpos, plyang, 4096, player );

	if ( _TraceHitNonWorld() == false ) then return; end
	
	local entity = _TraceGetEnt();
	
	if( EntityInfo[entity].HoverEnabled == true ) then
		EntityInfo[entity].HoverEnabled = false;
		_EntRemove( entity );
	end
	
end


function removeAllHoverBalls( player, args )
	for i = 1, 2048 do
		if( EntityInfo[i].HoverEnabled == true and _EntGetOwner( i ) == player ) then
			EntityInfo[i].HoverEnabled = false;
			_EntRemove( i );
		end
	end
end
CONCOMMAND( "remove_all_hoverballs", removeAllHoverBalls );


function restetonbreak( breakerid, propid )
	EntityInfo[propid].HoverEnabled = false;
end
HookEvent( eventPropBreak, restetonbreak );

function giveHoverBallSticker( player, args )
	if( _PlayerHasWeapon( player, "melonstickergun" ) ) then
		_PlayerSelectWeapon( player, "melonstickergun" );
	else
		_PlayerGiveSWEP( player, "weapons/hovermelons/weapon_MelonSticker.lua" );
	end
end
CONCOMMAND( "give_hoverball_sticker", giveHoverBallSticker );