local function FindSpace(POS)
	if not FAdmin.IsEmpty(POS) then
		local found = false
		for i = 40, 300, 15 do
			if FAdmin.IsEmpty(POS + Vector(i, 0, 0)) then
				POS = POS + Vector(i, 0, 0)
				--Yeah I found a nice position to put the player in!
				found = true
				break
			end
		end
		if not found then
			for i = 40, 300, 15 do
				if FAdmin.IsEmpty(POS + Vector(0, i, 0)) then
					POS = POS + Vector(0, i, 0)
					found = true
					break
				end
			end
		end
		if not found then
			for i = 40, 300, 15 do
				if FAdmin.IsEmpty(POS + Vector(0, -i, 0)) then
					POS = POS + Vector(0, -i, 0)
					found = true
					break
				end
			end
		end
		if not found then
			for i = 40, 300, 15 do
				if FAdmin.IsEmpty(POS + Vector(-i, 0, 0)) then
					POS = POS + Vector(-i, 0, 0)
					--Yeah I found a nice position to put the player in!
					found = true
					break
				end
			end
		end
		-- If you STILL can't find it, you'll just put him on top of the other player lol
		if not found then
			POS = POS + Vector(0,0,70)
		end
	end
	return POS
end

local function Teleport(ply, cmd, args)
	if not FAdmin.Access.PlayerHasPrivilege(ply, "Teleport") then FAdmin.Messages.SendMessage(ply, 5, "No access!") return end
	
	local targets = FAdmin.FindPlayer(args[1])
	if not targets or #targets == 1 and not ValidEntity(targets[1]) then
		targets = {ply}
	end
	
	for _, target in pairs(targets) do
		if ValidEntity(target) and target:Alive() then
			target:ExitVehicle()
			
			local tracedata = {}
			tracedata.start = ply:GetShootPos()
			tracedata.endpos = tracedata.start + ply:GetAimVector()*10000
			tracedata.filter = ply
			
			local trace = util.TraceLine(tracedata)
			local InitialPosition = FindSpace(trace.HitPos - ply:GetAimVector() * 60)
			target:SetPos(InitialPosition)

			
			local vFlushPoint = trace.HitPos - ( trace.HitNormal * 512 )
			vFlushPoint = target:NearestPoint( vFlushPoint )
			vFlushPoint = target:GetPos() - vFlushPoint
			vFlushPoint = trace.HitPos + vFlushPoint
			target:SetPos(vFlushPoint)
			
			local effectdata = EffectData()
			effectdata:SetStart(target:GetShootPos())
			effectdata:SetOrigin(target:GetShootPos())
			effectdata:SetScale( 1 )
			effectdata:SetMagnitude( 1 )
			effectdata:SetScale( 3 )
			effectdata:SetRadius( 1 )
			effectdata:SetEntity(target)
			for i = 1, 100 do timer.Simple(1/i, util.Effect, "TeslaHitBoxes", effectdata, true, true) end
			local Zap = math.random(1,9)
			if Zap == 4 then Zap = 3 end
			target:EmitSound("ambient/energy/zap"..Zap..".wav")
		end
	end
end

local function Bring(ply, cmd, args)
	if not FAdmin.Access.PlayerHasPrivilege(ply, "Teleport") then FAdmin.Messages.SendMessage(ply, 5, "No access!") return end
	if not args[1] then return end
	
	local targets = FAdmin.FindPlayer(args[1])
	local BringTo = FAdmin.FindPlayer(args[2])
	BringTo = (BringTo and BringTo[1]) or ply
	if not targets or #targets == 1 and not ValidEntity(targets[1]) then
		FAdmin.Messages.SendMessage(ply, 1, "Player not found")
		return
	end
	
	for _, target in pairs(targets) do
		if ValidEntity(target) and target ~= ply then
			target:ExitVehicle()
			if not target:Alive() then target:Spawn() end
			local PHYSGUN = false
			if ValidEntity(target:GetActiveWeapon()) and target:GetActiveWeapon():GetClass() == "weapon_physgun" and target:KeyDown(IN_ATTACK) then
				target:ConCommand("-attack")--release the stuff he's holding :)
				target:GetActiveWeapon():Remove()
				PHYSGUN = true
			end
			timer.Simple(0, function()
				local tracedata = {}
				tracedata.start = BringTo:GetShootPos()
				tracedata.endpos = tracedata.start + BringTo:GetAimVector()*50
				tracedata.filter = BringTo
				
				local trace = util.TraceLine(tracedata)
				if trace.HitPos:Distance(BringTo:GetShootPos()) < 45 then
					tracedata.endpos = tracedata.start - BringTo:GetAimVector()*50
					trace = util.TraceLine(tracedata)
				end
				
				target:SetPos(FindSpace(trace.HitPos))
				
				/*local vFlushPoint = trace.HitPos - ( trace.HitNormal * 512 )
				vFlushPoint = target:NearestPoint( vFlushPoint )
				vFlushPoint = target:GetPos() - vFlushPoint
				vFlushPoint = trace.HitPos + vFlushPoint*2
				target:SetPos(vFlushPoint)*/
				
				
				local effectdata = EffectData()
				effectdata:SetStart(target:GetShootPos())
				effectdata:SetOrigin(target:GetShootPos())
				effectdata:SetScale( 1 )
				effectdata:SetMagnitude( 1 )
				effectdata:SetScale( 3 )
				effectdata:SetRadius( 1 )
				effectdata:SetEntity(target)
				for i = 1, 100 do timer.Simple(1/i, util.Effect, "TeslaHitBoxes", effectdata, true, true) end
				local Zap = math.random(1,9)
				if Zap == 4 then Zap = 3 end
				target:EmitSound("ambient/energy/zap"..Zap..".wav")
				if PHYSGUN then timer.Simple(0.5, function() target:Give("weapon_physgun") target:SelectWeapon("weapon_physgun") end) end
			end)
		end
	end
end

local function Goto(ply, cmd, args)
	if not FAdmin.Access.PlayerHasPrivilege(ply, "Teleport") then FAdmin.Messages.SendMessage(ply, 5, "No access!") return end
	if not args[1] then return end
	
	local target = FAdmin.FindPlayer(args[1])
	target = target and target[1]
	if not ValidEntity(target) then return end
	
	ply:ExitVehicle()
	if not ply:Alive() then ply:Spawn() end
	
	local tracedata = {}
	tracedata.start = target:GetShootPos()
	tracedata.endpos = tracedata.start + target:GetAimVector()*50
	tracedata.filter = target
	
	local trace = util.TraceLine(tracedata)
	if trace.HitPos:Distance(target:GetShootPos()) < 45 then
		tracedata.endpos = tracedata.start - target:GetAimVector()*50
		trace = util.TraceLine(tracedata)
	end
	
	ply:SetPos(FindSpace(trace.HitPos))
	
	/*local vFlushPoint = trace.HitPos - ( trace.HitNormal * 512 )
	vFlushPoint = ply:NearestPoint( vFlushPoint )
	vFlushPoint = ply:GetPos() - vFlushPoint
	vFlushPoint = trace.HitPos + vFlushPoint*2
	ply:SetPos(vFlushPoint)*/
	
	
	local effectdata = EffectData()
	effectdata:SetStart(ply:GetShootPos())
	effectdata:SetOrigin(ply:GetShootPos())
	effectdata:SetScale( 1 )
	effectdata:SetMagnitude( 1 )
	effectdata:SetScale( 3 )
	effectdata:SetRadius( 1 )
	effectdata:SetEntity(ply)
	for i = 1, 100 do timer.Simple(1/i, util.Effect, "TeslaHitBoxes", effectdata, true, true) end
	local Zap = math.random(1,9)
	if Zap == 4 then Zap = 3 end
	ply:EmitSound("ambient/energy/zap"..Zap..".wav")
end

FAdmin.StartHooks["Teleport"] = function()
	FAdmin.Access.AddPrivilege("Teleport", 2)
	
	FAdmin.Commands.AddCommand("Teleport", Teleport)
	FAdmin.Commands.AddCommand("TP", Teleport)
	FAdmin.Commands.AddCommand("Bring", Bring)
	FAdmin.Commands.AddCommand("Goto", Goto)
end