TOOL.Category	= "Constraints"
TOOL.Name		= "#Super Parent Multi V2 beta"
TOOL.Command	= nil
TOOL.ConfigName = ""

TOOL.SelectedProps = {}
TOOL.Props = {}
TOOL.ClientConVar["phys"] = 0
TOOL.ClientConVar["multiplier"] = 5
TOOL.ClientConVar["balance"] = 0
TOOL.ClientConVar["shadow"] = 0
TOOL.ClientConVar[ "mode" ]	= "1"
TOOL.ClientConVar["unfreeze"] = 0

if(CLIENT) then
	language.Add("Tool_superparentmulti_name", "Super Parent Multi V2 beta")
	language.Add("Tool_superparentmulti_desc", "Super Parent Props multi")
	language.Add("Tool_superparentmulti_0", "Left click - selects/deselects props. Right click - Apply. Reload - Unselect all")
	language.Add("Tool_superparentmulti_1", "Left click - selects/deselects props. Right click - Apply. Reload - Unselect all")
	language.Add("Undone_superparentmulti", "Undone Parent Multi")
	language.Add("Cleanup_superparentmulti", "Parent Multi")
end


function TOOL:SelectEnt(ent)
	local Col = table.Count(self.SelectedProps)
	local Prop = {}
	Prop.ent = ent
	Prop.r, Prop.g, Prop.b, Prop.a = ent:GetColor()
	table.insert(self.SelectedProps, Prop)
	table.insert(self.Props, ent)
	if ( Col == 0 ) then
		ent:SetColor(0, 255, 0, 255)
	else
		ent:SetColor(170, 0, 255, 255)
	end
end

function TOOL:UnSelectEnt(ent)
	local Base = self.Props[1]
	if(ent == Base) then 
	self:GetOwner():PrintMessage(HUD_PRINTTALK, "Parent cannot unselect, use Reload to unselect all")
	return false end
	for k, Prop in pairs(self.SelectedProps) do
		if(Prop.ent == ent) then
			Prop.ent:SetColor(Prop.r, Prop.g, Prop.b, Prop.a)
			table.remove(self.SelectedProps, k)
			table.remove(self.Props, k)
		end
	end
end


local function SetMass(Ent2, Data )
	if Data.Mass then
		local Child = Ent2:GetPhysicsObject()
		Child:SetMass(Data.Mass)
	end
	
	duplicator.StoreEntityModifier( Ent2, "mass", Data )
end

duplicator.RegisterEntityModifier( "mass", SetMass )


function TOOL:Parent()
	local Num = table.Count(self.SelectedProps)
	local Ent1 = self.Props[1]
	local Ent2 = self.Props[Num]
	local PO1 = Ent1:GetPhysicsObject()
	local PO2 = Ent2:GetPhysicsObject()
	local Unfreeze = self:GetClientNumber("unfreeze")
	local Nonshadow = self:GetClientNumber("shadow")
	local physic = self:GetClientNumber("phys")
	local Mode = self:GetClientNumber("mode")
	local Balance = self:GetClientNumber("balance")
	local Multi = self:GetClientNumber("multiplier") * Num * Mode
	local Defaultmass = Ent1:GetPhysicsObject():GetMass()
	local Newmass = Defaultmass + Multi
	if(table.Count(self.SelectedProps) > 1) then
		for k, v in pairs(self.SelectedProps) do
			if(v.ent:IsValid()) then
				v.ent:SetColor(v.r, v.g, v.b, v.a)
			end
		end
		constraint.NoCollide(Ent1, Ent2, 0, 0)
		Ent2:SetParent( Ent1 );
		if( physic == 1 ) then 
			constraint.Weld(Ent1, Ent2, 0, 0, 0) 
				if( Balance == 1 ) then 
					if( Defaultmass < Newmass) then
						SetMass( Ent1, { Mass = Newmass } )
					end
				end
		end
		if(Unfreeze == 1) then		
			if(!PO2:IsMoveable()) then
				PO2:EnableMotion(true)
				PO2:Wake()
			end
		end
		if( Nonshadow == 1 ) then Ent2:DrawShadow( false ) end
		table.remove(self.SelectedProps, Num)
		table.remove(self.Props, Num)
		self:Parent()
		return true
	else
		if(Unfreeze == 1) then		
			if(!PO1:IsMoveable()) then
				PO1:EnableMotion(true)
				PO1:Wake()
			end
		end
		if(Balance == 1 && physic == 1 ) then 
		self:GetOwner():PrintMessage(HUD_PRINTTALK, "New mass from Parent: "..Newmass)
		end
		if( Nonshadow == 1 ) then Ent1:DrawShadow( false ) end
		self:ClearSelectedProps()
		self:GetOwner():PrintMessage(HUD_PRINTTALK, "Parenting finish.")
		return false
	end
end



function TOOL:ClearSelectedProps()
	if(table.Count(self.SelectedProps) > 0) then
		for k, v in pairs(self.SelectedProps) do
			if(v.ent:IsValid()) then
				v.ent:SetColor(v.r, v.g, v.b, v.a)
			end
		end
		self.SelectedProps = {}
		self.Props = {}
		return true
	else
		return false
	end
end



function TOOL:CheckEnt(ent)
	local FoundIt = false
	if(table.Count(self.SelectedProps) == 0) then
		return false
	end
	for k, Prop in pairs(self.SelectedProps) do
		if(Prop.ent == ent) then
			FoundIt = true
		end
	end
	if(FoundIt == true) then
		return true
	else
		return false
	end
end


function TOOL:LeftClick(tr)
	local ply = self:GetOwner()
	if(!tr.Entity || !tr.Entity:IsValid() || tr.Entity:IsPlayer() || tr.Entity:IsWorld() || tr.Entity:IsVehicle() ) then 
		self:GetOwner():PrintMessage(HUD_PRINTTALK, "Cannot select!")
		return false end
		if(CLIENT) then return true end
			local state = table.Count(self.SelectedProps)
			local ent = tr.Entity
			if ( state == 0 ) then
				self:GetOwner():PrintMessage(HUD_PRINTTALK, "Parent selected..select more props to link with the parent")
			end

			if(self:CheckEnt(ent)) then
				self:UnSelectEnt(ent)
				else
				self:SelectEnt(ent)
				
			end
		
	return true
end

function TOOL:RightClick(tr)
	if(CLIENT) then return true end
	local Number = table.Count(self.SelectedProps)
	local Time = table.Count(self.SelectedProps) /8
	if(Number <= 1) then 
	self:GetOwner():PrintMessage(HUD_PRINTTALK, "Select more props!")
	return false 
	end
	self:GetOwner():PrintMessage(HUD_PRINTTALK, "Working...")
	timer.Create( "timer", Time, 1, function() self:Parent() end )
end

function TOOL:Reload(tr)
	if(CLIENT) then return true end
	self:ClearSelectedProps()
end

function TOOL.BuildCPanel(CPanel)
	CPanel:AddControl( "Label", { Text = "The first prop you select, is the parent, all other props will be linked to the first prop. Right click to finish the operation. To add more props, start a new operation, select the same parent prop as before and add further ones.", Description  = "Text" }  )
	CPanel:AddControl( "Label", { Text = "", Description	= "space" }  )
	CPanel:AddControl("CheckBox", {Label = "Unfreeze all", Command = "superparentmulti_unfreeze"} )
	CPanel:AddControl( "Label", { Text = "", Description	= "space" }  )
	CPanel:AddControl("CheckBox", {Label = "Superparent mode", Command = "superparentmulti_phys"} )
	CPanel:AddControl( "Label", { Text = "Superparent mode, parenting with some kind of physical proberties", Description	= "How to 1" }  )
	CPanel:AddControl( "Label", { Text = "", Description	= "space" }  )
	CPanel:AddControl("CheckBox", {Label = "Disable Shadow", Command = "superparentmulti_shadow"} )
	CPanel:AddControl( "Label", { Text = "", Description	= "space" }  )
	CPanel:AddControl( "Label", { Text = "", Description	= "space" }  )
	CPanel:AddControl("CheckBox", {Label = "Mass balance", Command = "superparentmulti_balance"} )
	CPanel:AddControl( "Label", { Text = "Mass balance will be stabilize the children. Only affected on Superparent mode..select presetting", Description	= "How to 2" }  )

	local params = {Label = "presetting", MenuButton = "0", Options = {}}
	params.Options["Is a car"] = {superparentmulti_mode = "1"}
	params.Options["Is a plane"] = {superparentmulti_mode = "3"}
	params.Options["Is a house"] = {superparentmulti_mode = "5"}
	params.Options["Is other"] = {superparentmulti_mode = "7"}

	CPanel:AddControl( "ComboBox", params )
	CPanel:AddControl( "Slider", { Label = "Size from building: ( 1 is small )", Description = "Multiplikator",Type = "integer", Min = "1", Max = "5", Command = "superparentmulti_multiplier" } )	
end


