include('shared.lua')

local Laser = Material( "cable/redlaser" )
local Hydra = Material( "cable/hydra" )

function ENT:Draw()
	--self.BaseClass.Draw(self)
	--self.Entity:DrawModel() 
	
	local Toggled = self.Entity:GetNWBool( "Toggled", true )
	
	if Toggled then
		render.SetMaterial( Laser )
	else
		render.SetMaterial( Hydra )
	end
	
	-- 2.5625 62.5625 104.5625
	local size = self.Entity:OBBMaxs() - self.Entity:OBBMins()
	local w = size.y/2
	local h = size.z/2
	
	local Vector1 = self.Entity:LocalToWorld( Vector( 0, -w, -h ) )
	local Vector2 = self.Entity:LocalToWorld( Vector( 0, -w, h ) )
	
	render.DrawBeam( Vector1, Vector2, 5, 0, 0, Color( 255, 255, 255, 255 ) ) 
	
	local Vector1 = self.Entity:LocalToWorld( Vector( 0, w, -h ) )
	local Vector2 = self.Entity:LocalToWorld( Vector( 0, w, h ) )
	
	render.DrawBeam( Vector1, Vector2, 5, 0, 0, Color( 255, 255, 255, 255 ) ) 
 
 
end 