AddCSLuaFile("cl_init.lua")
AddCSLuaFile("shared.lua")

include("shared.lua")

function ENT:Initialize()

	self.Entity:SetModel( "models/props_building_details/Storefront_Template001a_Bars.mdl" )
	self.Entity:PhysicsInit( SOLID_VPHYSICS )
	self.Entity:SetMoveType( MOVETYPE_VPHYSICS )
	self.Entity:SetSolid( SOLID_VPHYSICS )
	
	-- Defaults on
	self.Toggled = true
	self.IsLadder = false
	self:TurnOn()
	
	local phys = self.Entity:GetPhysicsObject()
	if( phys:IsValid() ) then
		phys:EnableMotion( false )
	end
	
	self.Entity:DrawShadow( false )
end

function ENT:TurnOn()

	self.Entity:SetNWBool( "Toggled", true )
	self.Entity:SetSolid( SOLID_VPHYSICS )
	self.Entity.Toggled = true

end
function ENT:TurnOff()

	self.Entity:SetNWBool( "Toggled", false )
	self.Entity:SetSolid( SOLID_NONE )
	self.Entity.Toggled = false

end

function ENT:OnRemove()

	if self.BridgeController then
	
		for k, v in pairs( self.BridgeEnts ) do
		
			if v:IsValid() then
			
				v:Remove()
			end
		
		end
		for k, v in pairs( self.LadderEnts ) do
		
			if v:IsValid() then
			
				v:Remove()
			end
		
		end
	
	end

end

function ENT:Use( activator, caller )

	return
end


function ENT:Think()
	
	return
end 

local function Toggle( pl, ent )

	if !ent:IsValid() then return false end
	
	ent.Toggled = !ent.Toggled
	
	for k, v in pairs( ent.BridgeEnts ) do
	
		if v:IsValid() then
			if ent.Toggled then
			
				v:TurnOn()
			else
				v:TurnOff()
			end
		end
	end
	for k, v in pairs( ent.LadderEnts ) do
		
		if v:IsValid() and v:GetClass() == "func_useableladder" then
		
			if ent.Toggled then
			
				v:Fire( "Enable", "", 0 )
			else
				v:Fire( "Disable", "", 0 )
			end
		end
	end
	
	return true
	
end

numpad.Register( "Bridge_Toggle", Toggle )