
TOOL.Category		= "Wire - Detection"
TOOL.Name			= "Laser Sensor"
TOOL.Command		= nil
TOOL.ConfigName		= ""

if ( CLIENT ) then
    language.Add( "Tool_wire_lasersensor_name", "Laser Sensor Tool (Wire)" )
    language.Add( "Tool_wire_lasersensor_desc", "Spawns a laser sensor for use with the wire system." )
    language.Add( "Tool_wire_lasersensor_0", "Primary: Create/Update Laser Sensor" )
    language.Add( "WireLaserSensorTool_range", "Range:" )
    language.Add( "WireLaserSensorTool_colourOff", "Colour OFF:" )
    language.Add( "WireLaserSensorTool_colourOn", "Colour ON:" )
    language.Add( "WireLaserSensorTool_show_beam", "Show Beam:" )
    language.Add( "WireLaserSensorTool_ignworld", "Ignore World:" )
    language.Add( "WireLaserSensorTool_ignprops", "Ignore Props:" )
    language.Add( "ToolWireIndicator_b_colour", "B Colour:" )
	language.Add( "sboxlimit_wire_lasersensors", "You've hit laser sensors limit!" )
	language.Add( "undone_wirelasersensor", "Undone Wire Laser Sensor" )
end

if (SERVER) then
	CreateConVar('sbox_maxwire_lasersensors', 10)
end

TOOL.ClientConVar[ "range" ] = "1500"
TOOL.ClientConVar[ "show_beam" ] = "0"
TOOL.ClientConVar[ "ar" ] = "255"
TOOL.ClientConVar[ "ag" ] = "0"
TOOL.ClientConVar[ "ab" ] = "0"
TOOL.ClientConVar[ "aa" ] = "255"
TOOL.ClientConVar[ "br" ] = "0"
TOOL.ClientConVar[ "bg" ] = "255"
TOOL.ClientConVar[ "bb" ] = "0"
TOOL.ClientConVar[ "ba" ] = "255"
TOOL.ClientConVar[ "ignworld" ] = "1"
TOOL.ClientConVar[ "ignprops" ] = "0"

TOOL.Model = "models/jaanus/wiretool/wiretool_range.mdl"

cleanup.Register( "wire_lasersensors" )

function TOOL:LeftClick( trace )
	if trace.Entity && trace.Entity:IsPlayer() then return false end

	// If there's no physics object then we can't constraint it!
	if ( SERVER && !util.IsValidPhysicsObject( trace.Entity, trace.PhysicsBone ) ) then return false end

	if (CLIENT) then return true end

	local ply = self:GetOwner()

	local range			= self:GetClientNumber("range")
	local show_beam		= (self:GetClientNumber("show_beam") ~= 0)
	local ar			= math.min(self:GetClientNumber("ar"), 255)
	local ag			= math.min(self:GetClientNumber("ag"), 255)
	local ab			= math.min(self:GetClientNumber("ab"), 255)
	local aa			= math.min(self:GetClientNumber("aa"), 255)
	local br			= math.min(self:GetClientNumber("br"), 255)
	local bg			= math.min(self:GetClientNumber("bg"), 255)
	local bb			= math.min(self:GetClientNumber("bb"), 255)
	local ba			= math.min(self:GetClientNumber("ba"), 255)
	local ignworld		= (self:GetClientNumber("ignworld") ~= 0)
	local ignprops		= (self:GetClientNumber("ignprops") ~= 0)
	
	// If we shot a wire_lasersensor change its range
	if ( trace.Entity:IsValid() && trace.Entity:GetClass() == "gmod_wire_lasersensor" && trace.Entity.pl == ply ) then

		trace.Entity:Setup( range, show_beam, ar, ag, ab, aa, br, bg, bb, ba, ignworld, ignprops )

		trace.Entity.range = range
		trace.Entity.show_beam = show_beam
		trace.Entity.ar = ar
		trace.Entity.ag = ag
		trace.Entity.ab = ab
		trace.Entity.aa = aa
		trace.Entity.br = br
		trace.Entity.bg = bg
		trace.Entity.bb = bb
		trace.Entity.ba = ba
		trace.Entity.ignworld = ignworld
		trace.Entity.ignprops = ignprops

		return true
	end

	if ( !self:GetSWEP():CheckLimit( "wire_lasersensors" ) ) then return false end

	if (not util.IsValidModel(self.Model)) then return false end
	if (not util.IsValidProp(self.Model)) then return false end		// Allow ragdolls to be used?

	local Ang = trace.HitNormal:Angle()
	Ang.pitch = Ang.pitch + 90

	wire_lasersensor = MakeWireLaserSensor( ply, Ang, trace.HitPos, range, show_beam, ar, ag, ab, aa, br, bg, bb, ba, ignworld, ignprops )

	local min = wire_lasersensor:OBBMins()
	wire_lasersensor:SetPos( trace.HitPos - trace.HitNormal * min.z )

	/*local const, nocollide

	// Don't weld to world
	if ( trace.Entity:IsValid() ) then
		const = constraint.Weld( wire_lasersensor, trace.Entity, 0, trace.PhysicsBone, 0, true, true )
		// Don't disable collision if it's not attached to anything
		wire_lasersensor:GetPhysicsObject():EnableCollisions( false )
		wire_lasersensor.nocollide = true
	end*/
	local const = WireLib.Weld(wire_lasersensor, trace.Entity, trace.PhysicsBone, true)

	undo.Create("WireLaserSensor")
		undo.AddEntity( wire_lasersensor )
		undo.AddEntity( const )
		undo.SetPlayer( ply )
	undo.Finish()

	ply:AddCleanup( "wire_lasersensors", wire_lasersensor )
	ply:AddCleanup( "wire_lasersensors", const )
	ply:AddCleanup( "wire_lasersensors", nocollide )

	return true
end

if (SERVER) then

	function MakeWireLaserSensor( pl, Ang, Pos, range, show_beam, ar, ag, ab, aa, br, bg, bb, ba, ignworld, ignprops, nocollide, Vel, aVel, frozen )
		if ( !pl:CheckLimit( "wire_lasersensors" ) ) then return false end

		local wire_lasersensor = ents.Create( "gmod_wire_lasersensor" )
		if (!wire_lasersensor:IsValid()) then return false end

		wire_lasersensor:SetAngles( Ang )
		wire_lasersensor:SetPos( Pos )
		wire_lasersensor:SetModel( Model("models/jaanus/wiretool/wiretool_range.mdl") )
		wire_lasersensor:Spawn()

		wire_lasersensor:Setup( range, show_beam, ar, ag, ab, aa, br, bg, bb, ba, ignworld, ignprops )
		wire_lasersensor:SetPlayer( pl )

		if ( nocollide == true ) then wire_lasersensor:GetPhysicsObject():EnableCollisions( false ) end

		local ttable = {
			range = range,
			show_beam = show_beam,
			ar	= ar,
			ag	= ag,
			ab	= ab,
			aa	= aa,
			br	= br,
			bg	= bg,
			bb	= bb,
			ba	= ba,
			ignworld	= ignworld,
			ignprops	= ignprops,
			pl	= pl,
			}

		table.Merge(wire_lasersensor:GetTable(), ttable )

		pl:AddCount( "wire_lasersensors", wire_lasersensor )

		return wire_lasersensor
	end

	duplicator.RegisterEntityClass("gmod_wire_lasersensor", MakeWireLaserSensor, "Ang", "Pos", "range", "show_beam", "ar", "ag", "ab", "aa", "br", "bg", "bb", "ba", "ignworld", "ignprops", "nocollide", "Vel", "aVel", "frozen")

end

function TOOL:UpdateGhostWireLaserSensor( ent, player )
	if ( !ent ) then return end
	if ( !ent:IsValid() ) then return end

	local tr 	= utilx.GetPlayerTrace( player, player:GetCursorAimVector() )
	local trace 	= util.TraceLine( tr )
	if (!trace.Hit) then return end

	if (trace.Entity && trace.Entity:GetClass() == "gmod_wire_lasersensor" || trace.Entity:IsPlayer()) then

		ent:SetNoDraw( true )
		return

	end

	local Ang = trace.HitNormal:Angle()
	Ang.pitch = Ang.pitch + 90

	local min = ent:OBBMins()
	ent:SetPos( trace.HitPos - trace.HitNormal * min.z )
	ent:SetAngles( Ang )

	ent:SetNoDraw( false )
end


function TOOL:Think()
	if (!self.GhostEntity || !self.GhostEntity:IsValid() || self.GhostEntity:GetModel() != self.Model ) then
		self:MakeGhostEntity( self.Model, Vector(0,0,0), Angle(0,0,0) )
	end

	self:UpdateGhostWireLaserSensor( self.GhostEntity, self:GetOwner() )
end

function TOOL.BuildCPanel(panel)
	panel:AddControl("Header", { Text = "#Tool_wire_lasersensor_name", Description = "#Tool_wire_lasersensor_desc" })

	panel:AddControl("ComboBox", {
		Label = "#Presets",
		MenuButton = "1",
		Folder = "wire_lasersensor",

		Options = {
			Default = {
				wire_lasersensor_range = "50",
				wire_lasersensor_show_beam = "1",
				wire_lasersensor_ar = "255",
				wire_lasersensor_ag = "0",
				wire_lasersensor_ab = "0",
				wire_lasersensor_aa = "255",
				wire_lasersensor_br = "0",
				wire_lasersensor_bg = "255",
				wire_lasersensor_bb = "0",
				wire_lasersensor_ba = "255",
				wire_lasersensor_ignworld = "1",
				wire_lasersensor_ignprops = "0",
			}
		},

		CVars = {
			[0] = "wire_lasersensor_range",
			[1] = "wire_lasersensor_show_beam",
			[2] = "wire_lasersensor_ar",
			[3] = "wire_lasersensor_ag",
			[4] = "wire_lasersensor_ab",
			[5] = "wire_lasersensor_aa",
			[6] = "wire_lasersensor_br",
			[7] = "wire_lasersensor_bg",
			[8] = "wire_lasersensor_bb",
			[9] = "wire_lasersensor_ba",
			[10] = "wire_lasersensor_ignworld",
			[11] = "wire_lasersensor_ignprops",
		}
	})

	panel:AddControl("Slider", {
		Label = "#WireLaserSensorTool_range",
		Type = "Float",
		Min = "1",
		Max = "1000",
		Command = "wire_lasersensor_range"
	})
	
    panel:AddControl("Color", {
		Label = "#WireLaserSensorTool_colourOff",
		Red = "wire_lasersensor_ar",
		Green = "wire_lasersensor_ag",
		Blue = "wire_lasersensor_ab",
		Alpha = "wire_lasersensor_aa",
		ShowAlpha = "1",
		ShowHSV = "1",
		ShowRGB = "1",
		Multiplier = "255"
	})	
    panel:AddControl("Color", {
		Label = "#WireLaserSensorTool_colourOn",
		Red = "wire_lasersensor_br",
		Green = "wire_lasersensor_bg",
		Blue = "wire_lasersensor_bb",
		Alpha = "wire_lasersensor_ba",
		ShowAlpha = "1",
		ShowHSV = "1",
		ShowRGB = "1",
		Multiplier = "255"
	})
	
	panel:AddControl("CheckBox", {
		Label = "#WireLaserSensorTool_show_beam",
		Command = "wire_lasersensor_show_beam"
	})	
	panel:AddControl("CheckBox", {
		Label = "#WireLaserSensorTool_ignworld",
		Command = "wire_lasersensor_ignworld"
	})
	panel:AddControl("CheckBox", {
		Label = "#WireLaserSensorTool_ignprops",
		Command = "wire_lasersensor_ignprops"
	})

end
