
#ifndef _WEST_CPAD_
#define _WEST_CPAD_

#include "CDirect3D.h"
#include "vec.h"

class CPad{
public:
	CPad(bool move=false, int w=10, int h=100, int spd=7, D3DCOLOR col=0xFFFFFF){
		m_size.x=w; m_size.y=h;
		m_spd_max.x=spd; m_spd_max.y=spd;
		m_spd.x=0; m_spd.y=0;
		m_color=col;
		m_move=move;
	}
	void setpos(vec p){m_pos=p;}
	void setpos(int x, int y){m_pos.x=x; m_pos.y=y;}
	void setspeed(vec s){m_spd=clamp(s,m_spd_max);}
	void setspeed(int x, int y){m_spd.x=clamp(x,m_spd_max.x); m_spd.y=clamp(y,m_spd_max.y);}
	void setsize(vec s){m_size=s;}
	void setsize(int x, int y){m_size.x=x,m_size.y=y;}
	void setcolor(D3DCOLOR col){m_color=col;}
	vec pos(){return m_pos;}
	vec siz(){return m_size;}
	vec spd(){return m_spd;}
	void move();
	void draw(D3DCOLOR*, int);
	bool m_move;
protected:
	vec m_pos;
	vec m_spd;
	vec m_spd_max;
	vec m_size;
	D3DCOLOR m_color;
	friend class CBall;
};

#endif