
struct vec {
	double x;
	double y;
};

inline vec operator+(vec a, vec b){
	vec t={a.x+b.x,a.y+b.y};
	return t;
}
inline vec operator-(vec a, vec b){
	vec t={a.x-b.x,a.y-b.y};
	return t;
}
inline vec operator+=(vec &a, vec b){
	return a=a+b;
}
inline vec operator-=(vec &a, vec b){
	return a=a-b;
}
inline vec operator/(vec a, vec b){
	vec t={a.x/b.x,a.y/b.y};
	return t;
}
inline vec operator/(vec a, int b){
	vec t={a.x/b,a.y/b};
	return t;
}
inline bool operator<(vec a, vec b){
	return (a.x<b.x || a.y<b.y);
}
inline bool operator>(vec a, vec b){
	return (a.x>b.x || a.y>b.y);
}

inline double clamp(double x, double c){
	return x<-c?-c:(x>c?c:x);
}
inline double clamp(double x, double min, double max){
	return x<min?min:(x>max?max:x);
}
inline vec clamp(vec x, vec y){
	vec t={
		clamp(x.x,y.x),
		clamp(x.y,y.y),
	};
	return t;
}
inline vec clamp(vec x, vec min, vec max){
	vec t={
		clamp(x.x,min.x,max.x),
		clamp(x.y,min.y,max.y),
	};
	return t;
}
