
#include "CDirect3D.h"
#include <process.h>
#include <time.h>
#include <string>
#include <Windows.h>
using namespace std;
#include "CPad.h"
#include "CBall.h"

bool PROGRAM_RUN=true;

CDirect3D D3DClass;
CPad Pad1;
CPad Pad2;
CPad Line1;
CPad Line2;
CBall Ball;

CPad *padt[]={
	&Pad1, &Pad2, &Line1, &Line2, &Ball
};

int FRAMERATE_DRAW=30;
time_t draw_t;

int nextplay=0;
bool nextplay_b=true;

void draw(void *){
	while(PROGRAM_RUN){
		D3DClass.BeginScene();
		if(Ball.onscreen()){
			Pad1.move();
			Pad2.move();
			Ball.move(padt, 5);
		}else if(!nextplay){
			nextplay=time(0)+3;
		}else if(nextplay>time(0)){
			//D3DClass.DrawText(""+(nextplay-time(0)),SCR_WIDTH/2, SCR_HEIGHT/2, 0xFFFFFF);
			Pad1.setspeed(0,SCR_HEIGHT/2-Pad1.pos().y);
			Pad2.setspeed(0,SCR_HEIGHT/2-Pad2.pos().y);
			Pad1.move();
			Pad2.move();
		}else if(nextplay<=time(0)){
			Ball.setpos(SCR_WIDTH/2, SCR_HEIGHT/2);
			Ball.setspeed(rand()%2==2 ? 10 : -10,0);
			nextplay=0;
		}
		LPDIRECT3DSURFACE9 bbuffer=D3DClass.GetBackbuffer();
		D3DLOCKED_RECT r;
		bbuffer->LockRect(&r,0,0);
		for(int i=0;i<5;i++)
			padt[i]->draw((D3DCOLOR*)r.pBits,r.Pitch/4);
		bbuffer->UnlockRect();
		D3DClass.EndScene();
		draw_t=clock();
	}
}


void KeyDown(WPARAM key, bool press){
	switch(key){
	case VK_UP:
		Pad1.setspeed(0,press?-10:0);
		break;
	case VK_DOWN:
		Pad1.setspeed(0,press?10:0);
		break;
	case 0x57:
		Pad2.setspeed(0,press?-10:0);
		break;
	case 0x53:
		Pad2.setspeed(0,press?10:0);
		break;
	}
}

LRESULT CALLBACK MessageHandler(HWND HWind, UINT msg, WPARAM wp, LPARAM lp){
	D3DClass.SetClearColor(0x00000000);
	switch(msg){
	case WM_DESTROY:
		PostQuitMessage(0);
		return 0;
		break;
	case WM_KEYDOWN:
		switch(wp){
		case VK_ESCAPE:
			DestroyWindow(HWind);
			PostQuitMessage(0);
			return 0;
			break;
		}
		KeyDown(wp,true);
		break;
	case WM_KEYUP:
		KeyDown(wp,false);
		break;
	}
	return DefWindowProc(HWind, msg, wp, lp);
}

HWND CreateMainWindow(HINSTANCE hInst){
	WNDCLASSEX WindowClass={sizeof(WNDCLASSEX),CS_DBLCLKS | CS_OWNDC | CS_HREDRAW | CS_VREDRAW,
			MessageHandler,0,0,hInst,LoadIcon(NULL, IDI_WINLOGO),LoadCursor(NULL,IDC_ARROW),
			(HBRUSH)GetStockObject(WHITE_BRUSH),NULL,"WindowClass",LoadIcon(NULL,IDI_WINLOGO)};
	RegisterClassEx(&WindowClass);
	return CreateWindowEx(NULL,"WindowClass","Pong",WS_OVERLAPPEDWINDOW | WS_VISIBLE,0,0,SCR_WIDTH,SCR_HEIGHT,NULL,NULL,hInst,NULL);
};

int WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPrev, LPSTR lpCmdLine, int nCmdShow){
	HWND hWind=CreateMainWindow(hInst);
	if(!hWind) return -1;
	if(!D3DClass.Init(hWind)) return -1;
	D3DClass.CreateFont();
	srand(time(0));

	Pad1.setpos(SCR_WIDTH-25, SCR_HEIGHT/2);
	Pad1.m_move=true;
	Pad2.setpos(25, SCR_HEIGHT/2);
	Pad2.m_move=true;

	Line1.setpos(SCR_WIDTH/2,25);
	Line1.setsize(SCR_WIDTH-60,10);

	Line2.setpos(SCR_WIDTH/2,SCR_HEIGHT-25);
	Line2.setsize(SCR_WIDTH-60,10);

	Ball.setpos(SCR_WIDTH+5,SCR_HEIGHT+5);
	Ball.setsize(10,10);
	Ball.setspeed(10,0);
	
	_beginthread(draw,0,0);

	MSG msg={0};
	while(msg.message != WM_QUIT){
		if(GetMessage(&msg,NULL,0,0)){
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	return 0;
}
