
#include "CDirect3D.h"

CDirect3D::CDirect3D(){}
CDirect3D::~CDirect3D(){CleanUp();}

BOOL CDirect3D::Init(HWND HWind, BOOL Windowed){
	m_lpD3D=Direct3DCreate9(D3D_SDK_VERSION);
	if(!m_lpD3D) return FALSE;
	D3DPRESENT_PARAMETERS PParams;
	ZeroMemory(&PParams, sizeof(PParams));

	PParams.SwapEffect		=D3DSWAPEFFECT_DISCARD;
	PParams.hDeviceWindow	=HWind;
	PParams.Windowed		=Windowed;

	PParams.BackBufferWidth		=SCR_WIDTH;
	PParams.BackBufferHeight	=SCR_HEIGHT;
	PParams.BackBufferFormat	=D3DFMT_A8R8G8B8;

	if(FAILED(m_lpD3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, HWind,
			D3DCREATE_SOFTWARE_VERTEXPROCESSING, &PParams, &m_lpD3DDevice)))
		return FALSE;
	return TRUE;
}

void CDirect3D::SetClearColor(D3DCOLOR col){
	m_ClearColor=col;
}

void CDirect3D::CreateFont(){
	D3DXFONT_DESC LogFont={0};
	strcpy(LogFont.FaceName,"Arial");
	D3DXCreateFontIndirectA(m_lpD3DDevice,&LogFont,&m_lpD3DFont);
}

void CDirect3D::DrawText(LPCSTR text, int x, int y, D3DCOLOR col){
	RECT r={x,y,0,0};
	m_lpD3DFont->DrawText(0,text,-1,&r,DT_CALCRECT,col);
	m_lpD3DFont->DrawText(0,text,-1,&r,DT_CENTER,col);
}

inline void CDirect3D::CloneSurface(LPDIRECT3DSURFACE9 src, LPDIRECT3DSURFACE9 &dst){
	D3DSURFACE_DESC pDesc;
	src->GetDesc(&pDesc);
	m_lpD3DDevice->CreateOffscreenPlainSurface(pDesc.Width,pDesc.Height,pDesc.Format,pDesc.Pool,&dst,0);
}

inline LPDIRECT3DSURFACE9 CDirect3D::GetBackbuffer(){
	if(!m_lpBBufferAlias){
		CloneSurface(GetRealBackbuffer(),m_lpBBufferAlias);
	}
	return m_lpBBufferAlias;
}

inline LPDIRECT3DSURFACE9 CDirect3D::GetRealBackbuffer(){
	if(!m_lpBBuffer)
		m_lpD3DDevice->GetBackBuffer(0,0,D3DBACKBUFFER_TYPE_MONO,&m_lpBBuffer);
	return m_lpBBuffer;
}

void CDirect3D::BeginScene(){
	m_lpD3DDevice->Clear(0,0,D3DCLEAR_TARGET,m_ClearColor,0,0);
	m_lpD3DDevice->BeginScene();
	m_lpD3DDevice->ColorFill(GetBackbuffer(),0,0x0);
}

void CDirect3D::EndScene(){
	D3DSURFACE_DESC pDesc;
	GetBackbuffer()->GetDesc(&pDesc);
	RECT r={0,0,pDesc.Width,pDesc.Height};
	m_lpD3DDevice->StretchRect(GetBackbuffer(),&r,GetRealBackbuffer(),&r,D3DTEXF_NONE);
	m_lpD3DDevice->EndScene();
	m_lpD3DDevice->Present(0,0,0,0);
}

void CDirect3D::CleanUp(){
	if(m_lpD3DDevice) m_lpD3DDevice->Release();
	if(m_lpD3D) m_lpD3D->Release();
}
