/*
 * Decompiled with CFR 0.152.
 */
package unmap;

import java.util.ArrayList;
import unmap.BSP;
import unmap.Brush;
import unmap.Cons;
import unmap.Face;
import unmap.Plane;
import unmap.Vec;

public class Wind {
    ArrayList v = new ArrayList();
    static final int Maxlen = 56756;
    static final int Max_coord = 32768;
    static final int Side_front = 0;
    static final int Side_back = 1;
    static final int Side_on = 2;
    static final float Eps_split = 0.01f;
    static final float Eps_comp = 0.5f;
    static final float Eps_degen = 0.1f;

    public int size() {
        return this.v.size();
    }

    public void createplane(Plane pl) {
        float dmax = -1.0f;
        int idir = -1;
        Vec norm = new Vec(pl.nx, pl.ny, pl.nz);
        int i = 0;
        while (i < 3) {
            float dc = Math.abs(norm.comp(i));
            if (dc > dmax) {
                dmax = dc;
                idir = i;
            }
            ++i;
        }
        if (idir == -1) {
            Cons.println("createplane: bad plane normal");
            return;
        }
        Vec vup = new Vec(0.0f, 0.0f, 0.0f);
        switch (idir) {
            case 0: 
            case 1: {
                vup.z = 1.0f;
                break;
            }
            case 2: {
                vup.x = 1.0f;
            }
        }
        float vdot = vup.dot(norm);
        vup = vup.addmult(-vdot, norm);
        vup = vup.norm();
        Vec org = norm.scalar(pl.dist);
        Vec vrt = vup.cross(norm);
        vup = vup.scalar(56756.0f);
        vrt = vrt.scalar(56756.0f);
        this.v.add(org.subtract(vrt).add(vup));
        this.v.add(org.add(vrt).add(vup));
        this.v.add(org.add(vrt).subtract(vup));
        this.v.add(org.subtract(vrt).subtract(vup));
    }

    public Wind clipplane(Plane pl) {
        Vec norm = new Vec(pl.nx, pl.ny, pl.nz);
        int[] counts = new int[3];
        Wind w = new Wind();
        float[] dists = new float[this.size() + 1];
        int[] sides = new int[this.size() + 1];
        counts[2] = 0;
        counts[1] = 0;
        counts[0] = 0;
        int i = 0;
        while (i < this.size()) {
            float dot = ((Vec)this.v.get(i)).dot(norm);
            dists[i] = dot -= pl.dist;
            sides[i] = dot > 0.01f ? 0 : (dot < -0.01f ? 1 : 2);
            int n = sides[i];
            counts[n] = counts[n] + 1;
            ++i;
        }
        sides[this.size()] = sides[0];
        dists[this.size()] = dists[0];
        if (counts[0] == 0 && counts[1] == 0) {
            return this;
        }
        if (counts[0] == 0) {
            return w;
        }
        if (counts[1] == 0) {
            return this;
        }
        i = 0;
        while (i < this.size()) {
            block17: {
                Vec mv;
                int mi;
                Vec p1;
                block16: {
                    p1 = (Vec)this.v.get(i);
                    mi = w.size();
                    mv = new Vec(0.0f, 0.0f, 0.0f);
                    if (sides[i] != 0 && sides[i] != 2) break block16;
                    mv = p1.copy();
                    w.vset(mi, mv);
                    if (sides[i] == 2) break block17;
                    mi = w.size();
                    mv = new Vec(0.0f, 0.0f, 0.0f);
                }
                if (sides[i + 1] != 2 && sides[i + 1] != sides[i]) {
                    int pi2;
                    Vec p2;
                    if (i == this.size() - 1) {
                        p2 = (Vec)this.v.get(0);
                        pi2 = 0;
                    } else {
                        p2 = (Vec)this.v.get(i + 1);
                        pi2 = i + 1;
                    }
                    float dot = dists[i] / (dists[i] - dists[i + 1]);
                    int j = 0;
                    while (j < 3) {
                        if (norm.comp(j) == 1.0f) {
                            mv.setcomp(j, pl.dist);
                        } else if (norm.comp(j) == -1.0f) {
                            mv.setcomp(j, -pl.dist);
                        } else {
                            mv.setcomp(j, p1.comp(j) + dot * (p2.comp(j) - p1.comp(j)));
                        }
                        ++j;
                    }
                    w.vset(mi, mv);
                }
            }
            ++i;
        }
        return w;
    }

    public void vset(int index, Vec vertex) {
        int size = this.v.size();
        if (size == index) {
            this.v.add(vertex);
        } else if (size > index) {
            this.v.set(index, vertex);
        } else {
            Cons.println("Vset: index " + index + " > size " + size);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.size() + " : ");
        int i = 0;
        while (i < this.size()) {
            s.append(" (" + ((Vec)this.v.get((int)i)).x + ", " + ((Vec)this.v.get((int)i)).y + ", " + ((Vec)this.v.get((int)i)).z + ") ");
            ++i;
        }
        return s.toString();
    }

    public boolean matches(Wind that) {
        if (this.size() != that.size()) {
            return false;
        }
        float min = 1000000.0f;
        int i = 0;
        while (i < this.size()) {
            float mdist = this.matchdist(that, i);
            if (mdist < min) {
                min = mdist;
            }
            ++i;
        }
        return min < 0.5f;
    }

    public float matchdist(Wind that, int offset) {
        float dist = 0.0f;
        int i = 0;
        while (i < this.size()) {
            int j = (i + offset) % this.size();
            dist += ((Vec)this.v.get(i)).subtract((Vec)that.v.get(j)).modulus();
            ++i;
        }
        return dist;
    }

    public float vmatches(Wind that) {
        float min = 1000000.0f;
        if (this.size() != that.size()) {
            return min;
        }
        int i = 0;
        while (i < this.size()) {
            float mdist = this.matchdist(that, i);
            if (mdist < min) {
                min = mdist;
            }
            ++i;
        }
        return min;
    }

    public static Wind windfromface(BSP m, Face f) {
        Wind w = new Wind();
        int i = 0;
        while (i < f.numedge) {
            int sedge = m.sedge[f.fstedge + i];
            int v = 0;
            v = sedge < 0 ? m.vi2[-sedge] : m.vi1[sedge];
            w.v.add(new Vec(m.x[v], m.y[v], m.z[v]));
            ++i;
        }
        return w;
    }

    public static Wind windfromside(BSP m, Brush brush, int side) {
        Wind bw = new Wind();
        int bside = brush.fstside + side;
        int plane = m.bsd[bside].pnum;
        bw.createplane(m.pl[plane]);
        int i = 0;
        while (i < brush.numside) {
            if (i != side) {
                int ibside = brush.fstside + i;
                int iplane = m.bsd[ibside].pnum;
                if (m.bsd[ibside].bevel != 1) {
                    bw = bw.clipplane(m.pl[iplane].flip());
                }
            }
            ++i;
        }
        return bw;
    }

    public boolean isnull() {
        return this.size() == 0;
    }

    public boolean ishuge() {
        for (Vec point : this.v) {
            int j = 0;
            while (j < 3) {
                if (Math.abs(point.comp(j)) > 32768.0f) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    public void removedegenerate() {
        if (this.isnull()) {
            return;
        }
        Wind result = new Wind();
        int i = 0;
        while (i < this.size()) {
            Vec v1;
            int j = (i + 1) % this.size();
            Vec v0 = (Vec)this.v.get(i);
            if (v0.subtract(v1 = (Vec)this.v.get(j)).modulus() > 0.1f) {
                result.v.add(v0);
            }
            ++i;
        }
        if (this.size() != result.size()) {
            this.v = result.v;
        }
    }
}

