/*
 * Decompiled with CFR 0.152.
 */
package unmap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import unmap.BSP;
import unmap.Brush;
import unmap.Brushside;
import unmap.BspFileFilter;
import unmap.Cons;
import unmap.Cubemap;
import unmap.Dispinfo;
import unmap.Dispvert;
import unmap.Entity;
import unmap.Face;
import unmap.JGBPanel;
import unmap.Model;
import unmap.Overlay;
import unmap.Plane;
import unmap.Pstatic;
import unmap.Texture;
import unmap.Treelimit;
import unmap.Vec;
import unmap.Wind;

public class Vmex {
    String filename;
    int dmode = 3;
    int bmode = 0;
    float depth = 1.0f;
    int stexmode = 3;
    int ttexmode = 3;
    int prec = 8;
    boolean fixorg = true;
    boolean fixtex = true;
    boolean props = true;
    boolean debug = false;
    boolean checkverts = true;
    boolean details = true;
    boolean disps = true;
    boolean olays = true;
    boolean crunch = true;
    boolean newdisp = true;
    int envmaps = 8;
    int brushid = 2;
    int sideid = 1;
    BSP m;
    PrintWriter p;
    DecimalFormat fp;
    Vec org;
    HashSet[] origmap;
    float area_eps = 1.0f;
    int oucount = 0;
    int worldbrushes;
    static int PLAYERCLIP = 65536;
    static int NPCCLIP = 131072;
    static int CLIP = PLAYERCLIP | NPCCLIP;
    static int DETAIL = 0x8000000;
    static int SOLID = 1;
    static final int shipprops = 0;
    static String VERSION = "v0.98g";

    public void exec() {
        try {
            String fullname;
            int index;
            this.twait();
            if (this.filename.length() == 0) {
                Cons.println("No map specified");
                return;
            }
            long starttime = System.currentTimeMillis();
            File infile = new File(this.filename);
            if (!infile.exists() || !infile.canRead()) {
                Cons.println("Can't read " + this.filename);
                return;
            }
            Cons.println("Reading " + this.filename);
            FileChannel raf = new RandomAccessFile(infile, "r").getChannel();
            MappedByteBuffer mbuffer = raf.map(FileChannel.MapMode.READ_ONLY, 0L, raf.size());
            ByteBuffer buff = mbuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.m = new BSP();
            this.m.shipprops = false;
            this.m.loadmap(buff);
            this.twait();
            raf.close();
            String precfmt = "0.";
            int i = 0;
            while (i < this.prec) {
                precfmt = String.valueOf(precfmt) + "#";
                ++i;
            }
            Locale.setDefault(Locale.ENGLISH);
            this.fp = new DecimalFormat(precfmt);
            this.org = new Vec(0.0f, 0.0f, 0.0f);
            this.fixtexturenames();
            this.twait();
            if (this.dmode == 2) {
                this.buildfacemaps();
            }
            this.protbrushcheck();
            if (this.m.dispinfos == 0) {
                this.disps = false;
            }
            String outfullname = (index = (fullname = infile.getPath()).lastIndexOf(".bsp")) > 0 ? String.valueOf(fullname.substring(0, index)) + "_d.vmf" : String.valueOf(fullname) + "_d.vmf";
            File outfile = new File(outfullname);
            FileWriter ofw = new FileWriter(outfile);
            this.p = new PrintWriter(ofw);
            Cons.println("\nWriting " + outfile.getName());
            this.twait();
            Cons.print("Decompiling via ");
            if (this.dmode == 0) {
                Cons.println("original faces");
            }
            if (this.dmode == 1) {
                Cons.println("split faces");
            }
            if (this.dmode == 2) {
                Cons.println("original faces where possible");
            }
            if (this.dmode == 3) {
                Cons.println("brushes and planes");
            }
            if (this.dmode == 3) {
                Cons.println("Assigning brushes to models");
                this.assignbrushes();
            }
            Cons.println("Calculating lightmap resolutions");
            this.m.calclightmapscale();
            this.twait();
            Cons.println("\nWorld ");
            this.vmfheader();
            this.twait();
            this.vmfworldspawn();
            this.twait();
            switch (this.dmode) {
                case 0: {
                    this.vmforigfaces();
                    break;
                }
                case 1: {
                    this.vmffaces();
                    break;
                }
                case 2: {
                    this.vmforigfacesplus();
                    break;
                }
                case 3: {
                    this.vmfbrushes();
                }
            }
            this.twait();
            if (this.disps) {
                Cons.println("\nDisplacements ");
                this.vmfdisplacements();
            }
            this.twait();
            Cons.println("\nEntities ");
            this.vmfentities();
            this.twait();
            if (this.details) {
                Cons.println("\nFunc_details ");
                this.vmfdetails();
                this.twait();
            }
            if (this.olays) {
                Cons.println("\nOverlays ");
                this.vmfoverlays();
                this.twait();
            }
            if (this.props) {
                Cons.println("\nProp_statics ");
                this.vmfstatics();
                this.twait();
            }
            if (this.envmaps > 0) {
                Cons.println("\nEnv_cubmaps ");
                this.vmfcubemaps();
                this.twait();
            }
            this.vmftrailer();
            this.twait();
            if (this.dmode == 2) {
                Cons.println("\n" + this.oucount + " original faces were written as split faces");
            }
            ofw.close();
            Cons.println("\nWritten: " + outfile.getName());
            long duration = System.currentTimeMillis() - starttime;
            DecimalFormat tf = new DecimalFormat("0.#");
            Cons.println("\nDone in " + tf.format((float)duration / 1000.0f) + " seconds");
        }
        catch (Exception excession) {
            Cons.println(excession);
            return;
        }
    }

    public void vmfdisplacements() {
        int i = 0;
        while (i < this.m.faces) {
            short disp = this.m.face[i].dispinfo;
            if (disp >= 0) {
                Dispvert dv;
                Vec ev13;
                Face f = this.m.face[i];
                Dispinfo di = this.m.dinfo[disp];
                Cons.print(".");
                Vec org = new Vec();
                Vec[] svec = new Vec[f.numedge];
                int[] vert = new int[f.numedge];
                int sedge = this.m.sedge[f.fstedge];
                int v0 = sedge < 0 ? this.m.vi2[-sedge] : this.m.vi1[sedge];
                float x0 = this.m.x[v0];
                float y0 = this.m.y[v0];
                float z0 = this.m.z[v0];
                int j = 0;
                while (j < f.numedge) {
                    sedge = this.m.sedge[f.fstedge + j];
                    vert[j] = sedge < 0 ? this.m.vi2[-sedge] : this.m.vi1[sedge];
                    svec[j] = new Vec(this.m.x[vert[j]] - x0, this.m.y[vert[j]] - y0, this.m.z[vert[j]] - z0);
                    ++j;
                }
                float maxmcp = -1.0f;
                int jmax = -1;
                short kmax = -1;
                int j2 = 1;
                while (j2 < f.numedge) {
                    short k = j2 + 1;
                    while (k < f.numedge) {
                        float mcp = svec[j2].cross(svec[k]).modulus();
                        if (!(mcp <= maxmcp)) {
                            maxmcp = mcp;
                            jmax = j2;
                            kmax = k;
                        }
                        ++k;
                    }
                    ++j2;
                }
                int v1 = vert[0];
                int v2 = vert[jmax];
                int v3 = vert[kmax];
                Vec e1 = new Vec(this.m.x[v1], this.m.y[v1], this.m.z[v1]);
                Vec e2 = new Vec(this.m.x[v2], this.m.y[v2], this.m.z[v2]);
                Vec e3 = new Vec(this.m.x[v3], this.m.y[v3], this.m.z[v3]);
                Vec ev12 = e2.subtract(e1);
                Vec norm = ev12.cross(ev13 = e3.subtract(e1)).norm();
                if (norm.notvalid()) {
                    Cons.print("\nBad normal in displacement! " + ev12 + "x" + ev13);
                }
                String sv1 = this.strpvec(e1);
                String sv2 = this.strpvec(e2);
                String sv3 = this.strpvec(e3);
                Texture tex = this.m.gettex(f.texinfo, org, this.fp);
                String texture = "NULL";
                if (this.ttexmode == 0) {
                    texture = "SKYBOX/SKYFAKEWHITE";
                }
                if (this.ttexmode == 1) {
                    texture = "TOOLS/TOOLSBLACK";
                }
                if (this.ttexmode == 2) {
                    texture = "DEV/DEV_MEASUREGENERIC01";
                }
                if (this.ttexmode == 3) {
                    texture = tex.name;
                }
                String btexture = "NULL";
                if (this.stexmode == 0) {
                    btexture = "SKYBOX/SKYFAKEWHITE";
                }
                if (this.stexmode == 1) {
                    btexture = "TOOLS/TOOLSBLACK";
                }
                if (this.stexmode == 2) {
                    btexture = "TOOLS/TOOLSINVISIBLE";
                }
                if (this.stexmode == 3) {
                    btexture = texture;
                }
                String sua = tex.uaxis;
                String sva = tex.vaxis;
                this.tab(1);
                this.p.println("solid");
                this.tab(1);
                this.p.println("{");
                this.pl(2, "id", String.valueOf(this.brushid++));
                if (this.newdisp) {
                    this.writeprismback(f, 1, norm, org, btexture);
                } else {
                    this.writepyramback(f, 1, norm, org, btexture, sua, sva);
                }
                di.sideid = this.sideid;
                this.tab(2);
                this.p.println("side");
                this.tab(2);
                this.p.println("{");
                this.pl(3, "id", String.valueOf(this.sideid++));
                this.pl(3, "plane", String.valueOf(sv1) + " " + sv2 + " " + sv3);
                this.pl(3, "material", texture);
                this.pl(3, "uaxis", sua);
                this.pl(3, "vaxis", sva);
                this.pl(3, "rotation", "0");
                this.pl(3, "lightmapscale", tex.lmscale);
                this.pl(3, "smoothing_groups", String.valueOf(f.smooth));
                this.tab(3);
                this.p.println("dispinfo");
                this.tab(3);
                this.p.println("{");
                this.pl(4, "power", String.valueOf(di.power));
                this.pl(4, "startposition", "[" + this.strvec(new Vec(di.sx, di.sy, di.sz)) + "]");
                this.pl(4, "elevation", "0");
                this.pl(4, "subdiv", "0");
                this.tab(4);
                this.p.println("normals");
                this.tab(4);
                this.p.println("{");
                int row = 0;
                StringBuffer t = new StringBuffer();
                int j3 = 0;
                while (j3 < di.numverts()) {
                    dv = this.m.dv[di.ivert + j3];
                    t.append(String.valueOf(this.fp.format(dv.x)) + " " + this.fp.format(dv.y) + " " + this.fp.format(dv.z) + " ");
                    if (j3 % (di.psize() + 1) == di.psize()) {
                        this.pl(5, "row" + String.valueOf(row++), t.toString());
                        t = new StringBuffer();
                    }
                    ++j3;
                }
                this.tab(4);
                this.p.println("}");
                this.tab(4);
                this.p.println("distances");
                this.tab(4);
                this.p.println("{");
                row = 0;
                t = new StringBuffer();
                j3 = 0;
                while (j3 < di.numverts()) {
                    dv = this.m.dv[di.ivert + j3];
                    t.append(String.valueOf(this.fp.format(dv.dist)) + " ");
                    if (j3 % (di.psize() + 1) == di.psize()) {
                        this.pl(5, "row" + String.valueOf(row++), t.toString());
                        t = new StringBuffer();
                    }
                    ++j3;
                }
                this.tab(4);
                this.p.println("}");
                String onorm = "0 0 0";
                this.tab(4);
                this.p.println("offset_normals");
                this.tab(4);
                this.p.println("{");
                row = 0;
                t = new StringBuffer();
                int j4 = 0;
                while (j4 < di.numverts()) {
                    dv = this.m.dv[di.ivert + j4];
                    t.append(String.valueOf(onorm) + " ");
                    if (j4 % (di.psize() + 1) == di.psize()) {
                        this.pl(5, "row" + String.valueOf(row++), t.toString());
                        t = new StringBuffer();
                    }
                    ++j4;
                }
                this.tab(4);
                this.p.println("}");
                this.tab(4);
                this.p.println("alphas");
                this.tab(4);
                this.p.println("{");
                row = 0;
                t = new StringBuffer();
                j4 = 0;
                while (j4 < di.numverts()) {
                    dv = this.m.dv[di.ivert + j4];
                    t.append(String.valueOf(this.fp.format(dv.alpha)) + " ");
                    if (j4 % (di.psize() + 1) == di.psize()) {
                        this.pl(5, "row" + String.valueOf(row++), t.toString());
                        t = new StringBuffer();
                    }
                    ++j4;
                }
                this.tab(4);
                this.p.println("}");
                String[] triconvert = new String[]{"0", "0", "1", "0", "0", "0", "9"};
                this.tab(4);
                this.p.println("triangle_tags");
                this.tab(4);
                this.p.println("{");
                row = 0;
                t = new StringBuffer("");
                int j5 = 0;
                while (j5 < di.numtris()) {
                    int dt = this.m.dtri[di.itri + j5];
                    if (dt > 6) {
                        dt = 0;
                    }
                    t.append(String.valueOf(triconvert[dt]) + " ");
                    if (j5 % 2 * di.psize() == 2 * di.psize() - 1) {
                        this.pl(5, "row" + String.valueOf(row++), t.toString());
                        t = new StringBuffer();
                    }
                    ++j5;
                }
                this.tab(4);
                this.p.println("}");
                this.tab(4);
                this.p.println("allowed_verts");
                this.tab(4);
                this.p.println("{");
                this.tab(5);
                this.p.print("\"10\" \"");
                j5 = 0;
                while (j5 < 10) {
                    this.p.print(String.valueOf(di.allow[j5]) + " ");
                    ++j5;
                }
                this.p.println("\"");
                this.tab(4);
                this.p.println("}");
                this.tab(3);
                this.p.println("}");
                this.tab(2);
                this.p.println("}");
                this.tab(1);
                this.p.println("}");
            }
            ++i;
        }
        this.p.println("}");
    }

    public void assignbrushes() {
        Treelimit tl = new Treelimit();
        this.m.treewalk(0, tl);
        if (this.debug) {
            Cons.println("Walked worldspawn tree");
        }
        this.worldbrushes = tl.bmax;
        int i = 1;
        while (i < this.m.models) {
            Model model = this.m.mod[i];
            tl.clear();
            this.m.treewalk(model.headnode, tl);
            model.fstbrush = tl.bmin;
            model.numbrush = tl.bmax - tl.bmin + 1;
            if (this.debug) {
                Cons.println("Model " + i + ": Brush " + tl.bmin + " to " + tl.bmax + "\n");
            }
            ++i;
        }
        Cons.println("\nLargest worldbrush: " + this.worldbrushes++);
    }

    public void vmfbrushes() {
        int i = 0;
        while (i < this.worldbrushes) {
            if (this.debug) {
                Cons.print("\nBrush:" + i);
            }
            if (this.m.br[i].contents != (SOLID | DETAIL) || !this.details) {
                this.writebrush(1, this.m.br[i], this.org, i);
            }
            ++i;
        }
        if (this.disps) {
            return;
        }
        this.p.println("}");
    }

    public void vmfdetails() {
        int i = 0;
        while (i < this.worldbrushes) {
            if (this.m.br[i].contents == (SOLID | DETAIL)) {
                if (this.debug) {
                    Cons.print("\nFDBrush:" + i);
                }
                this.p.println("entity");
                this.p.println("{");
                this.pl(1, "id", String.valueOf(this.brushid++));
                this.pl(1, "classname", "func_detail");
                this.writebrush(1, this.m.br[i], this.org, i);
                this.p.println("}");
            }
            ++i;
        }
    }

    public String contentstr(int v) {
        String[] cont = new String[]{"SOLID", "WINDOW", "AUX", "GRATE", "SLIME", "WATER", "MIST", "OPAQUE", "TESTFOG", "U3", "U4", "U5", "U6", "U7", "MOVABLE", "AREAPORTAL", "PLAYERCLIP", "MONSTERCLIP", "CUR0", "CUR90", "CUR180", "CUR270", "CURUP", "CURDN", "ORIGIN", "MONSTER", "DEBRIS", "DETAIL", "TRANSLUCENT", "LADDER", "HITBOX"};
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < 32) {
            if ((v & 1) == 1) {
                s.append(String.valueOf(cont[i]) + " ");
            }
            v >>>= 1;
            ++i;
        }
        return s.toString();
    }

    public void writebrush(int td, Brush b, Vec o, int bid) {
        int visgrp = 0;
        this.tab(td);
        this.p.println("solid");
        this.tab(td);
        this.p.println("{");
        this.pl(td + 1, "id", String.valueOf(this.brushid++));
        if (this.debug) {
            this.pl(td + 1, "brushnum", String.valueOf(bid));
        }
        if (this.debug) {
            Cons.print(" " + this.contentstr(b.contents) + " " + b.fstside + " (" + b.numside + ")");
        }
        int nullsides = 0;
        int i = 0;
        while (i < b.numside) {
            Brushside bside = this.m.bsd[b.fstside + i];
            if (bside.bevel != 1) {
                Wind w = Wind.windfromside(this.m, b, i);
                if (this.crunch) {
                    w.removedegenerate();
                }
                if (w.ishuge()) {
                    Cons.println("Side " + i + " of brush " + b + " is huge");
                }
                if (w.isnull()) {
                    ++nullsides;
                } else if (w.size() < 3) {
                    if (this.debug) {
                        Cons.println("Side " + i + " of brush " + b + " was overcrunched");
                    } else {
                        Cons.print("!");
                    }
                    ++nullsides;
                } else {
                    int surf = this.writeside(2, this.m.bsd[b.fstside + i], w, o, b.contents);
                    if (surf > 0) {
                        visgrp = surf;
                    }
                }
            }
            ++i;
        }
        if (nullsides == b.numside) {
            Cons.println("Brush " + b + " is null");
        }
        if (visgrp > 0) {
            this.tab(2);
            this.p.println("editor");
            this.tab(2);
            this.p.println("{");
            this.pl(3, "color", "200 100 100");
            this.pl(3, "visgroupid", String.valueOf(5 + visgrp));
            this.pl(3, "visgroupshown", "1");
            this.tab(2);
            this.p.println("}");
        }
        this.tab(td);
        this.p.println("}");
    }

    public int writeside(int td, Brushside bs, Wind w, Vec origin, int cont) {
        String texture;
        int surface = 0;
        if (bs.bevel == 1) {
            Cons.print("!");
            return 0;
        }
        Cons.print(".");
        int verts = w.size();
        Vec[] svec = new Vec[verts];
        Vec v0 = (Vec)w.v.get(0);
        int i = 0;
        while (i < verts) {
            svec[i] = ((Vec)w.v.get(i)).subtract(v0);
            ++i;
        }
        float maxmcp = -1.0f;
        int imax = -1;
        int jmax = -1;
        int i2 = 1;
        while (i2 < verts) {
            int j = i2 + 1;
            while (j < verts) {
                float mcp = svec[i2].cross(svec[j]).modulus();
                if (!(mcp <= maxmcp)) {
                    maxmcp = mcp;
                    imax = i2;
                    jmax = j;
                }
                ++j;
            }
            ++i2;
        }
        Vec e1 = v0;
        Vec e2 = (Vec)w.v.get(imax);
        Vec e3 = (Vec)w.v.get(jmax);
        e1 = e1.add(origin);
        e2 = e2.add(origin);
        e3 = e3.add(origin);
        if (e1.notvalid() || e2.notvalid() || e3.notvalid()) {
            Cons.println("\nBrushside with wind " + w + " is invalid");
        }
        String sv1 = this.strpvec(e1);
        String sv2 = this.strpvec(e2);
        String sv3 = this.strpvec(e3);
        boolean genvec = false;
        Texture tex = this.m.gettex(bs.texinfo, origin, this.fp);
        Vec n = this.m.pl[bs.pnum].getvec();
        Vec tn = new Vec();
        String sua = tex.uaxis;
        String sva = tex.vaxis;
        if (tex.texinfo != null && (double)Math.abs(n.dot(tn = tex.texinfo.tnorm())) < 0.02) {
            genvec = true;
        }
        if (tex.texinfo == null || genvec) {
            Vec udir = new Vec(0.0f, 0.0f, 1.0f);
            if ((double)Math.abs(udir.dot(n)) > 0.707) {
                udir = new Vec(1.0f, 0.0f, 0.0f);
            }
            Vec tv1 = udir.cross(n).norm();
            Vec tv2 = tv1.cross(n).norm();
            sua = "[" + this.strvec(tv1) + " 0] 0.25";
            sva = "[" + this.strvec(tv2) + " 0] 0.25";
        }
        if (tex.texinfo == null) {
            texture = "TOOLS/TOOLSSKIP";
            surface = 1;
        } else {
            int envmapid;
            texture = "NULL";
            if (this.ttexmode == 0) {
                texture = "SKYBOX/SKYFAKEWHITE";
            }
            if (this.ttexmode == 1) {
                texture = "TOOLS/TOOLSBLACK";
            }
            if (this.ttexmode == 2) {
                texture = "DEV/DEV_MEASUREGENERIC01";
            }
            if (this.ttexmode == 3) {
                texture = tex.name;
            }
            if (tex.name.equalsIgnoreCase("TOOLS/TOOLSHINT")) {
                surface = 2;
            }
            if (tex.name.equalsIgnoreCase("TOOLS/TOOLSPLAYERCLIP")) {
                surface = 1;
            }
            if (tex.name.equalsIgnoreCase("TOOLS/TOOLSNPCRCLIP")) {
                surface = 1;
            }
            if (tex.name.equalsIgnoreCase("TOOLS/TOOLSCLIP")) {
                surface = 1;
            }
            if (this.envmaps > 1 && (envmapid = tex.envmap) != -1) {
                this.m.cm[envmapid].sides.add(new Integer(this.sideid));
            }
            if (!genvec) {
                sua = tex.uaxis;
                sva = tex.vaxis;
            }
        }
        if ((cont & CLIP) == PLAYERCLIP) {
            texture = "TOOLS/TOOLSPLAYERCLIP";
        }
        if ((cont & CLIP) == NPCCLIP) {
            texture = "TOOLS/TOOLSNPCCLIP";
        }
        if ((cont & CLIP) == CLIP) {
            texture = "TOOLS/TOOLSCLIP";
        }
        if ((cont & CLIP) != 0) {
            surface = 1;
        }
        if (genvec && this.debug) {
            Cons.println(String.valueOf(texture) + " was perp: " + n.dot(tn) + " " + this.contentstr(cont));
        }
        bs.sideid = this.sideid;
        this.tab(td);
        this.p.println("side");
        this.tab(td);
        this.p.println("{");
        this.pl(td + 1, "id", String.valueOf(this.sideid++));
        this.pl(td + 1, "plane", String.valueOf(sv1) + " " + sv2 + " " + sv3);
        this.pl(td + 1, "material", texture);
        this.pl(td + 1, "uaxis", sua);
        this.pl(td + 1, "vaxis", sva);
        this.pl(td + 1, "rotation", "0");
        this.pl(td + 1, "lightmapscale", tex.lmscale);
        this.pl(td + 1, "smoothing_groups", "0");
        this.tab(td);
        this.p.println("}");
        return surface;
    }

    public void buildfacemaps() {
        Cons.println("Building split face to original face maps");
        this.origmap = new HashSet[this.m.ofaces];
        int i = 0;
        while (i < this.m.ofaces) {
            this.origmap[i] = new HashSet();
            ++i;
        }
        i = 0;
        while (i < this.m.faces) {
            int o = this.m.face[i].orig;
            if (o >= 0) {
                this.origmap[o].add(i);
            }
            ++i;
        }
        Cons.println("Building original face areas");
        i = 0;
        while (i < this.m.ofaces) {
            Face of = this.m.oface[i];
            Vec[] svec = new Vec[of.numedge];
            int[] vert = new int[of.numedge];
            int sedge = this.m.sedge[of.fstedge];
            int v0 = sedge < 0 ? this.m.vi2[-sedge] : this.m.vi1[sedge];
            float x0 = this.m.x[v0];
            float y0 = this.m.y[v0];
            float z0 = this.m.z[v0];
            int j = 0;
            while (j < of.numedge) {
                sedge = this.m.sedge[of.fstedge + j];
                vert[j] = sedge < 0 ? this.m.vi2[-sedge] : this.m.vi1[sedge];
                svec[j] = new Vec(this.m.x[vert[j]] - x0, this.m.y[vert[j]] - y0, this.m.z[vert[j]] - z0);
                ++j;
            }
            j = 1;
            while (j < of.numedge - 1) {
                of.area += 0.5f * svec[j].cross(svec[j + 1]).modulus();
                ++j;
            }
            if (this.debug) {
                Cons.println("OF " + i + " : area " + of.area);
            }
            float carea = 0.0f;
            Iterator faceit = this.origmap[i].iterator();
            while (faceit.hasNext()) {
                carea += this.m.face[((Integer)faceit.next()).intValue()].area;
            }
            if (!(carea <= of.area + this.area_eps)) {
                of.undersize = true;
                if (this.debug) {
                    Cons.println("OF " + i + " is undersized: " + carea + ">" + of.area);
                }
            }
            ++i;
        }
    }

    public void vmfcubemaps() {
        int i = 0;
        while (i < this.m.cubemaps) {
            Cubemap cube = this.m.cm[i];
            Cons.print(".");
            this.p.println("entity");
            this.p.println("{");
            this.pl(1, "id", String.valueOf(this.brushid++));
            this.pl(1, "classname", "env_cubemap");
            this.pl(1, "origin", this.strvec(new Vec(cube.x, cube.y, cube.z)));
            this.pl(1, "cubemapsize", String.valueOf(cube.size));
            if (this.envmaps > 1) {
                if (cube.sides.size() > this.envmaps || cube.sides.size() == 0) {
                    this.pl(1, "sides", "");
                } else {
                    Iterator<Object> sideit = cube.sides.iterator();
                    StringBuffer sstr = new StringBuffer(((Integer)sideit.next()).toString());
                    while (sideit.hasNext()) {
                        sstr.append(" " + ((Integer)sideit.next()).toString());
                    }
                    this.pl(1, "sides", sstr.toString());
                }
            } else {
                this.pl(1, "sides", "");
            }
            this.p.println("}");
            ++i;
        }
    }

    public void vmfstatics() {
        int i = 0;
        while (i < this.m.propstatics) {
            Pstatic pst = this.m.ps[i];
            Cons.print(".");
            this.p.println("entity");
            this.p.println("{");
            this.pl(1, "id", String.valueOf(this.brushid++));
            this.pl(1, "classname", "prop_static");
            this.pl(1, "origin", this.strvec(new Vec(pst.ox, pst.oy, pst.oz)));
            this.pl(1, "angles", this.strvec(new Vec(pst.ax, pst.ay, pst.az)));
            this.pl(1, "skin", String.valueOf(pst.skin));
            this.pl(1, "fademindist", String.valueOf(pst.fademin));
            this.pl(1, "fademaxdist", String.valueOf(pst.fademax));
            this.pl(1, "solid", String.valueOf(pst.solid));
            this.pl(1, "model", this.m.psname[pst.type]);
            this.p.println("}");
            ++i;
        }
    }

    public void vmfoverlays() {
        this.m.owind = new Wind[this.m.ofaces];
        this.m.bwind = new Wind[this.m.brushsides];
        int i = 0;
        while (i < this.m.overlays) {
            Cons.print(".");
            Overlay o = this.m.ov[i];
            Texture tex = this.m.gettex(o.texinfo);
            this.p.println("entity");
            this.p.println("{");
            this.pl(1, "id", String.valueOf(this.brushid++));
            this.pl(1, "classname", "info_overlay");
            this.pl(1, "material", tex.name);
            this.pl(1, "StartU", this.fp.format(o.u0));
            this.pl(1, "EndU", this.fp.format(o.u1));
            this.pl(1, "StartV", this.fp.format(o.v0));
            this.pl(1, "EndV", this.fp.format(o.v1));
            this.pl(1, "BasisOrigin", this.strvec(o.origin));
            this.pl(1, "BasisU", this.strvec(o.ubasis));
            this.pl(1, "BasisV", this.strvec(o.vbasis));
            this.pl(1, "BasisNormal", this.strvec(o.normal));
            int j = 0;
            while (j < 4) {
                this.pl(1, "uv" + j, this.strvec(o.uv[j]));
                ++j;
            }
            int order = (o.faces & 0xC000) >> 14;
            this.pl(1, "RenderOrder", String.valueOf(order));
            StringBuffer sstr = new StringBuffer();
            HashSet<Integer> sides = new HashSet<Integer>();
            int j2 = 0;
            while (j2 < (0x3FFF & o.faces)) {
                int sid = this.findbrushmatches(i, o.face[j2]);
                if (sid >= 0) {
                    sides.add(sid);
                }
                ++j2;
            }
            Iterator sit = sides.iterator();
            while (sit.hasNext()) {
                sstr.append(String.valueOf(String.valueOf(sit.next())) + " ");
            }
            this.pl(1, "sides", sstr.toString());
            this.pl(1, "origin", this.strvec(o.origin));
            this.p.println("}");
            ++i;
        }
    }

    public int findbrushmatches(int over, int iface) {
        Face f = this.m.face[iface];
        int ioface = f.orig;
        Face of = this.m.oface[ioface];
        if (f.dispinfo != -1) {
            if (this.debug) {
                Cons.println("O: " + over + " D: " + f.dispinfo + " id: " + this.m.dinfo[f.dispinfo].sideid);
            }
            return this.m.dinfo[f.dispinfo].sideid;
        }
        if (this.m.owind[ioface] == null) {
            this.m.owind[ioface] = Wind.windfromface(this.m, of);
        }
        int i = 0;
        while (i < this.m.brushes) {
            Brush b = this.m.br[i];
            int j = 0;
            while (j < b.numside) {
                int ibs = b.fstside + j;
                Brushside s = this.m.bsd[ibs];
                if (this.m.bwind[ibs] == null) {
                    this.m.bwind[ibs] = Wind.windfromside(this.m, b, j);
                }
                if (f.pnum == s.pnum && f.texinfo == s.texinfo && this.m.bwind[ibs].matches(this.m.owind[ioface])) {
                    if (this.debug) {
                        Cons.println("O: " + over + " F: " + iface + " B:" + i + " BS: " + ibs + " id:" + s.sideid);
                    }
                    return s.sideid;
                }
                ++j;
            }
            ++i;
        }
        if (this.debug) {
            Cons.println("O: " + over + " F: " + iface + " no match");
        }
        return -1;
    }

    public void vmfentities() {
        int i = 1;
        while (i < this.m.entities) {
            Entity e = this.m.ent[i];
            this.p.println("entity");
            this.p.println("{");
            this.pl(1, "id", String.valueOf(this.brushid++));
            int numkeyvals = e.key.size();
            boolean connector = false;
            int j = 0;
            while (j < numkeyvals) {
                String skey = (String)e.key.get(j);
                String sval = (String)e.value.get(j);
                if (((Boolean)e.con.get(j)).booleanValue()) {
                    connector = true;
                } else if (!skey.equals("model") || e.model < 0) {
                    this.pl(1, skey, sval);
                }
                ++j;
            }
            if (connector) {
                this.tab(1);
                this.p.println("connections");
                this.tab(1);
                this.p.println("{");
                j = 0;
                while (j < numkeyvals) {
                    if (((Boolean)e.con.get(j)).booleanValue()) {
                        this.pl(2, (String)e.key.get(j), (String)e.value.get(j));
                    }
                    ++j;
                }
                this.tab(1);
                this.p.println("}");
            }
            if (e.model > 0) {
                this.writemodel(e.model, new Vec(e.ox, e.oy, e.oz));
            }
            this.p.println("}");
            ++i;
        }
    }

    public void writeempty(int td, Vec o) {
        String texture = "TOOLS/TOOLSINVISIBLE";
        this.tab(td);
        this.p.println("solid");
        this.tab(td);
        this.p.println("{");
        this.pl(td + 1, "id", String.valueOf(this.brushid++));
        int i = 0;
        while (i < 3) {
            int j = -1;
            while (j <= 1) {
                Vec n = new Vec(0.0f, 0.0f, 0.0f);
                n.setcomp(i, j);
                float d = 8.0f;
                Vec e1 = n.scalar(d);
                Vec udir = new Vec(0.0f, 0.0f, 1.0f);
                if (i == 2) {
                    udir = new Vec(1.0f, 0.0f, 0.0f);
                }
                Vec v1 = udir.cross(n).norm();
                Vec v2 = v1.cross(n).norm();
                v1 = v1.scalar(8.0f);
                v2 = v2.scalar(8.0f);
                Vec e2 = e1.add(v1);
                Vec e3 = e1.add(v2);
                e1 = e1.add(o);
                e2 = e2.add(o);
                e3 = e3.add(o);
                String sv1 = this.strpvec(e1);
                String sv2 = this.strpvec(e2);
                String sv3 = this.strpvec(e3);
                Vec u = new Vec(0.0f, 0.0f, 0.0f);
                Vec v = new Vec(0.0f, 0.0f, 0.0f);
                if (i == 0) {
                    u.y = 1.0f;
                    v.z = -1.0f;
                } else if (i == 1) {
                    u.x = 1.0f;
                    v.z = -1.0f;
                } else if (i == 2) {
                    u.x = 1.0f;
                    v.y = -1.0f;
                }
                String sua = "[" + this.strvec(u) + " 0] 0.25";
                String sva = "[" + this.strvec(v) + " 0] 0.25";
                this.tab(td + 1);
                this.p.println("side");
                this.tab(td + 1);
                this.p.println("{");
                this.pl(td + 2, "id", String.valueOf(this.sideid++));
                this.pl(td + 2, "plane", String.valueOf(sv1) + " " + sv2 + " " + sv3);
                this.pl(td + 2, "material", texture);
                this.pl(td + 2, "uaxis", sua);
                this.pl(td + 2, "vaxis", sva);
                this.pl(td + 2, "rotation", "0");
                this.pl(td + 2, "lightmapscale", "12939");
                this.pl(td + 2, "smoothing_groups", "0");
                this.tab(td + 1);
                this.p.println("}");
                j += 2;
            }
            ++i;
        }
        this.tab(td);
        this.p.println("}");
    }

    public void writemodel(int modelindex, Vec entorg) {
        Model model = this.m.mod[modelindex];
        int mfirst = model.fstface;
        int mnum = model.numface;
        if (!this.fixorg) {
            entorg = new Vec(0.0f, 0.0f, 0.0f);
        }
        if (this.dmode != 3) {
            if (model.numface == 0) {
                this.writeempty(1, entorg);
            } else {
                int i = 0;
                while (i < mnum) {
                    Face wf = this.m.face[mfirst + i];
                    this.writeflat(1, wf, entorg);
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < model.numbrush) {
                Brush b = this.m.br[model.fstbrush + i];
                this.writebrush(1, b, entorg, model.fstbrush + i);
                ++i;
            }
        }
    }

    public void writeflat(int td, Face f, Vec origin) {
        int envmapid;
        int v3;
        int v2;
        int v1;
        Cons.print(".");
        if (f.numedge < 2) {
            return;
        }
        if (this.disps && f.dispinfo > -1) {
            return;
        }
        if (this.checkverts) {
            Vec[] svec = new Vec[f.numedge];
            int[] vert = new int[f.numedge];
            int sedge = this.m.sedge[f.fstedge];
            int v0 = sedge < 0 ? this.m.vi2[-sedge] : this.m.vi1[sedge];
            float x0 = this.m.x[v0];
            float y0 = this.m.y[v0];
            float z0 = this.m.z[v0];
            int i = 0;
            while (i < f.numedge) {
                sedge = this.m.sedge[f.fstedge + i];
                vert[i] = sedge < 0 ? this.m.vi2[-sedge] : this.m.vi1[sedge];
                svec[i] = new Vec(this.m.x[vert[i]] - x0, this.m.y[vert[i]] - y0, this.m.z[vert[i]] - z0);
                ++i;
            }
            float maxmcp = -1.0f;
            int imax = -1;
            short jmax = -1;
            int i2 = 1;
            while (i2 < f.numedge) {
                short j = i2 + 1;
                while (j < f.numedge) {
                    float mcp = svec[i2].cross(svec[j]).modulus();
                    if (!(mcp <= maxmcp)) {
                        maxmcp = mcp;
                        imax = i2;
                        jmax = j;
                    }
                    ++j;
                }
                ++i2;
            }
            v1 = vert[0];
            v2 = vert[imax];
            v3 = vert[jmax];
        } else {
            int sedge1 = this.m.sedge[f.fstedge];
            if (sedge1 < 0) {
                v1 = this.m.vi2[-sedge1];
                v2 = this.m.vi1[-sedge1];
            } else {
                v1 = this.m.vi1[sedge1];
                v2 = this.m.vi2[sedge1];
            }
            int sedge2 = this.m.sedge[f.fstedge + 1];
            v3 = sedge2 < 0 ? this.m.vi1[-sedge2] : this.m.vi2[sedge2];
        }
        Vec e1 = new Vec(this.m.vert(v1)).add(origin);
        Vec e2 = new Vec(this.m.vert(v2)).add(origin);
        Vec e3 = new Vec(this.m.vert(v3)).add(origin);
        Vec ev12 = e2.subtract(e1);
        Vec ev13 = e3.subtract(e1);
        Vec norm = ev12.cross(ev13).norm();
        if (norm.notvalid()) {
            if (this.debug) {
                Cons.print("\nBad normal! " + ev12 + "x" + ev13);
            }
            return;
        }
        String sv1 = this.strpvec(e1);
        String sv2 = this.strpvec(e2);
        String sv3 = this.strpvec(e3);
        Texture tex = this.m.gettex(f.texinfo, origin, this.fp);
        String texture = "NULL";
        if (this.ttexmode == 0) {
            texture = "SKYBOX/SKYFAKEWHITE";
        }
        if (this.ttexmode == 1) {
            texture = "TOOLS/TOOLSBLACK";
        }
        if (this.ttexmode == 2) {
            texture = "DEV/DEV_MEASUREGENERIC01";
        }
        if (this.ttexmode == 3) {
            texture = tex.name;
        }
        if (this.envmaps > 1 && (envmapid = tex.envmap) != -1) {
            this.m.cm[envmapid].sides.add(new Integer(this.sideid));
        }
        String sua = tex.uaxis;
        String sva = tex.vaxis;
        this.tab(td);
        this.p.println("solid");
        this.tab(td);
        this.p.println("{");
        this.pl(td + 1, "id", String.valueOf(this.brushid++));
        this.tab(td + 1);
        this.p.println("side");
        this.tab(td + 1);
        this.p.println("{");
        this.pl(td + 2, "id", String.valueOf(this.sideid++));
        this.pl(td + 2, "plane", String.valueOf(sv1) + " " + sv2 + " " + sv3);
        this.pl(td + 2, "material", texture);
        this.pl(td + 2, "uaxis", sua);
        this.pl(td + 2, "vaxis", sva);
        this.pl(td + 2, "rotation", "0");
        this.pl(td + 2, "lightmapscale", tex.lmscale);
        this.pl(td + 2, "smoothing_groups", String.valueOf(f.smooth));
        this.tab(td + 1);
        this.p.println("}");
        if (this.stexmode == 0) {
            texture = "SKYBOX/SKYFAKEWHITE";
        }
        if (this.stexmode == 1) {
            texture = "TOOLS/TOOLSBLACK";
        }
        if (this.stexmode == 2) {
            texture = "TOOLS/TOOLSINVISIBLE";
        }
        switch (this.bmode) {
            case 0: {
                this.writepyramback(f, td, norm, origin, texture, sua, sva);
                break;
            }
            case 1: {
                this.writeprismback(f, td, norm, origin, texture);
            }
        }
        this.tab(td);
        this.p.println("}");
    }

    public void writeflatback(Face f, int td, Vec origin, String tex, String sua, String sva) {
        int v2;
        int v1;
        if (f.numedge < 2) {
            return;
        }
        int sedge1 = this.m.sedge[f.fstedge];
        if (sedge1 < 0) {
            v1 = this.m.vi2[-sedge1];
            v2 = this.m.vi1[-sedge1];
        } else {
            v1 = this.m.vi1[sedge1];
            v2 = this.m.vi2[sedge1];
        }
        int sedge2 = this.m.sedge[f.fstedge + 1];
        int v3 = sedge2 < 0 ? this.m.vi1[-sedge2] : this.m.vi2[sedge2];
        Vec e1 = new Vec(this.m.vert(v1)).add(origin);
        Vec e2 = new Vec(this.m.vert(v2)).add(origin);
        Vec e3 = new Vec(this.m.vert(v3)).add(origin);
        String sv1 = this.strpvec(e1);
        String sv2 = this.strpvec(e2);
        String sv3 = this.strpvec(e3);
        this.tab(td + 1);
        this.p.println("side");
        this.tab(td + 1);
        this.p.println("{");
        this.pl(td + 2, "id", String.valueOf(this.sideid++));
        this.pl(td + 2, "plane", String.valueOf(sv1) + " " + sv2 + " " + sv3);
        this.pl(td + 2, "material", tex);
        this.pl(td + 2, "uaxis", sua);
        this.pl(td + 2, "vaxis", sva);
        this.pl(td + 2, "rotation", "0");
        this.pl(td + 2, "lightmapscale", "16");
        this.pl(td + 2, "smoothing_groups", String.valueOf(f.smooth));
        this.tab(td + 1);
        this.p.println("}");
    }

    public void writepyramback(Face f, int t, Vec norm, Vec o, String tex, String sua, String sva) {
        float nx = 0.0f;
        float ny = 0.0f;
        float nz = 0.0f;
        int i = 0;
        while (i < f.numedge) {
            int se = this.m.sedge[f.fstedge + i];
            int vertex = se < 0 ? this.m.vi2[-se] : this.m.vi1[se];
            nx += this.m.x[vertex];
            ny += this.m.y[vertex];
            nz += this.m.z[vertex];
            ++i;
        }
        nx /= (float)f.numedge;
        ny /= (float)f.numedge;
        nz /= (float)f.numedge;
        nx += norm.x * this.depth;
        ny += norm.y * this.depth;
        nz += norm.z * this.depth;
        i = 0;
        while (i < f.numedge) {
            int v2;
            int v1;
            int se = this.m.sedge[f.fstedge + i];
            if (se < 0) {
                v1 = this.m.vi2[-se];
                v2 = this.m.vi1[-se];
            } else {
                v1 = this.m.vi1[se];
                v2 = this.m.vi2[se];
            }
            Vec e1 = new Vec(this.m.x[v1], this.m.y[v1], this.m.z[v1]).add(o);
            Vec e2 = new Vec(this.m.x[v2], this.m.y[v2], this.m.z[v2]).add(o);
            Vec e3 = new Vec(nx, ny, nz).add(o);
            this.writebackface(t, e1, e2, e3, tex, sua, sva);
            ++i;
        }
    }

    public void writeprismback(Face f, int t, Vec norm, Vec o, String tex) {
        Vec bedge = norm.scalar(this.depth);
        int i = 0;
        while (i < f.numedge) {
            int v2;
            int v1;
            int se = this.m.sedge[f.fstedge + i];
            if (se < 0) {
                v1 = this.m.vi2[-se];
                v2 = this.m.vi1[-se];
            } else {
                v1 = this.m.vi1[se];
                v2 = this.m.vi2[se];
            }
            Vec e1 = this.m.vert(v1).add(o);
            Vec e2 = this.m.vert(v2).add(o);
            Vec e3 = e1.add(bedge);
            Vec tv1 = e2.subtract(e1).norm();
            Vec tv2 = bedge.norm();
            String sua = "[" + this.strvec(tv1) + " 0] 0.25";
            String sva = "[" + this.strvec(tv2) + " 0] 0.25";
            this.writebackface(t, e1, e2, e3, tex, sua, sva);
            ++i;
        }
        Vec[] svec = new Vec[f.numedge];
        int[] vert = new int[f.numedge];
        int sedge = this.m.sedge[f.fstedge];
        int v0 = sedge < 0 ? this.m.vi2[-sedge] : this.m.vi1[sedge];
        float x0 = this.m.x[v0];
        float y0 = this.m.y[v0];
        float z0 = this.m.z[v0];
        int i2 = 0;
        while (i2 < f.numedge) {
            sedge = this.m.sedge[f.fstedge + i2];
            vert[i2] = sedge < 0 ? this.m.vi2[-sedge] : this.m.vi1[sedge];
            svec[i2] = new Vec(this.m.x[vert[i2]] - x0, this.m.y[vert[i2]] - y0, this.m.z[vert[i2]] - z0);
            ++i2;
        }
        float maxmcp = -1.0f;
        int imax = -1;
        short jmax = -1;
        int i3 = 1;
        while (i3 < f.numedge) {
            short j = i3 + 1;
            while (j < f.numedge) {
                float mcp = svec[i3].cross(svec[j]).modulus();
                if (!(mcp <= maxmcp)) {
                    maxmcp = mcp;
                    imax = i3;
                    jmax = j;
                }
                ++j;
            }
            ++i3;
        }
        Vec e1 = this.m.vert(vert[0]).add(bedge);
        Vec e2 = this.m.vert(vert[imax]).add(bedge);
        Vec e3 = this.m.vert(vert[jmax]).add(bedge);
        Vec udir = new Vec(0.0f, 0.0f, 1.0f);
        if ((double)Math.abs(udir.dot(norm)) > 0.707) {
            udir = new Vec(1.0f, 0.0f, 0.0f);
        }
        Vec tv1 = udir.cross(norm).norm();
        Vec tv2 = tv1.cross(norm).norm();
        String sua = "[" + this.strvec(tv1) + " 0] 0.25";
        String sva = "[" + this.strvec(tv2) + " 0] 0.25";
        this.writebackface(t, e1, e2, e3, tex, sua, sva);
    }

    public void writebackface(int td, Vec v1, Vec v2, Vec v3, String tex, String sua, String sva) {
        this.tab(td + 1);
        this.p.println("side");
        this.tab(td + 1);
        this.p.println("{");
        String sv1 = this.strpvec(v1);
        String sv2 = this.strpvec(v3);
        String sv3 = this.strpvec(v2);
        this.pl(td + 2, "id", String.valueOf(this.sideid++));
        this.pl(td + 2, "plane", String.valueOf(sv1) + " " + sv2 + " " + sv3);
        this.pl(td + 2, "material", tex);
        this.pl(td + 2, "uaxis", sua);
        this.pl(td + 2, "vaxis", sva);
        this.pl(td + 2, "rotation", "0");
        this.pl(td + 2, "lightmapscale", "16");
        this.pl(td + 2, "smoothing_groups", "0");
        this.tab(td + 1);
        this.p.println("}");
    }

    public void vmforigfaces() {
        Model M0 = this.m.mod[0];
        int wfirst = M0.fstface;
        int wnum = M0.numface;
        int i = 0;
        while (i < wnum) {
            Face wf = this.m.face[wfirst + i];
            if (wf.orig >= 0) {
                Face owf = this.m.oface[wf.orig];
                if (!owf.written) {
                    this.writeflat(1, owf, this.org);
                    owf.written = true;
                }
            }
            ++i;
        }
        if (this.disps) {
            return;
        }
        this.p.println("}");
    }

    public void vmforigfacesplus() {
        Model M0 = this.m.mod[0];
        int wfirst = M0.fstface;
        int wnum = M0.numface;
        int i = 0;
        while (i < wnum) {
            Face wf = this.m.face[wfirst + i];
            if (wf.orig >= 0) {
                Face owf = this.m.oface[wf.orig];
                if (!owf.written) {
                    if (owf.undersize) {
                        ++this.oucount;
                        Iterator fit = this.origmap[wf.orig].iterator();
                        if (this.debug) {
                            Cons.print("\n OF " + wf.orig + ": ");
                        }
                        while (fit.hasNext()) {
                            int findex = (Integer)fit.next();
                            this.writeflat(1, this.m.face[findex], this.org);
                            if (!this.debug) continue;
                            Cons.print(String.valueOf(findex) + " ");
                        }
                        owf.written = true;
                    } else {
                        this.writeflat(1, owf, this.org);
                        owf.written = true;
                    }
                }
            } else {
                this.writeflat(1, wf, this.org);
            }
            ++i;
        }
        if (this.disps) {
            return;
        }
        this.p.println("}");
    }

    public void vmffaces() {
        Model M0 = this.m.mod[0];
        int wfirst = M0.fstface;
        int wnum = M0.numface;
        int i = 0;
        while (i < wnum) {
            Face wf = this.m.face[wfirst + i];
            this.writeflat(1, wf, this.org);
            ++i;
        }
        if (this.disps) {
            return;
        }
        this.p.println("}");
    }

    public void vmfworldspawn() {
        Entity ws = this.m.ent[0];
        this.p.println("world");
        this.p.println("{");
        this.pl(1, "id", "1");
        this.pl(1, "mapversion", "2");
        Iterator<Object> kit = ws.key.iterator();
        Iterator<Object> vit = ws.value.iterator();
        while (kit.hasNext()) {
            String skey = (String)kit.next();
            String sval = (String)vit.next();
            if (skey.equals("world_maxs") || skey.equals("world_mins")) continue;
            this.pl(1, skey, sval);
        }
        this.pl(1, "comment", "Decompiled by VMEX " + VERSION + " from " + this.filename);
    }

    public void vmfheader() {
        this.p.println("versioninfo");
        this.p.println("{");
        this.pl(1, "editorvesion", "400");
        this.pl(1, "editorbuild", "2978");
        this.pl(1, "mapversion", "2");
        this.pl(1, "formatversion", "100");
        this.pl(1, "prefab", "0");
        this.p.println("}");
        this.p.println("visgroups");
        this.p.println("{");
        this.tab(1);
        this.p.println("visgroup");
        this.tab(1);
        this.p.println("{");
        this.pl(2, "name", "Auto");
        this.pl(2, "visgroupid", "1");
        this.pl(2, "color", "152 185 142");
        this.tab(2);
        this.p.println("visgroup");
        this.tab(2);
        this.p.println("{");
        this.pl(3, "name", "Entities");
        this.pl(3, "visgroupid", "3");
        this.pl(3, "color", "104 137 238");
        this.tab(2);
        this.p.println("}");
        this.tab(2);
        this.p.println("visgroup");
        this.tab(2);
        this.p.println("{");
        this.pl(3, "name", "Detail Brushes");
        this.pl(3, "visgroupid", "2");
        this.pl(3, "color", "240 25 150");
        this.tab(2);
        this.p.println("}");
        this.tab(2);
        this.p.println("visgroup");
        this.tab(2);
        this.p.println("{");
        this.pl(3, "name", "Brush Entities");
        this.pl(3, "visgroupid", "4");
        this.pl(3, "color", "231 148 165");
        this.tab(2);
        this.p.println("}");
        this.tab(2);
        this.p.println("visgroup");
        this.tab(2);
        this.p.println("{");
        this.pl(3, "name", "Clip Brushes");
        this.pl(3, "visgroupid", "6");
        this.pl(3, "color", "255 128 128");
        this.tab(2);
        this.p.println("}");
        this.tab(2);
        this.p.println("visgroup");
        this.tab(2);
        this.p.println("{");
        this.pl(3, "name", "Hint Brushes");
        this.pl(3, "visgroupid", "7");
        this.pl(3, "color", "100 120 190");
        this.tab(2);
        this.p.println("}");
        this.tab(1);
        this.p.println("}");
        this.p.println("}");
        this.p.println("viewsettings");
        this.p.println("{");
        this.pl(1, "bSnapToGrid", "0");
        this.pl(1, "bShowGrid", "1");
        this.pl(1, "nGridSpacing", "128");
        this.pl(1, "bShow3DGrid", "0");
        this.p.println("}");
    }

    public void vmftrailer() {
        this.p.println("cameras");
        this.p.println("{");
        this.pl(1, "activecamera", "-1");
        this.p.println("}");
        this.p.println("cordon");
        this.p.println("{");
        this.pl(1, "mins", "(99999 99999 99999)");
        this.pl(1, "maxs", "(-99999 -99999 -99999)");
        this.pl(1, "active", "0");
        this.p.println("}");
    }

    public String strpvec(Vec v) {
        return "(" + this.strvec(v) + ")";
    }

    public String strvec(Vec v) {
        return String.valueOf(this.fp.format(v.x)) + " " + this.fp.format(v.y) + " " + this.fp.format(v.z);
    }

    public void pl(int tabdepth, String a, String b) {
        this.tab(tabdepth);
        this.p.println("\"" + a + "\" \"" + b + "\"");
    }

    public void pl(int tabdepth, String a, int b) {
        this.pl(tabdepth, a, "" + b);
    }

    public void tab(int depth) {
        int i = 0;
        while (i < depth) {
            this.p.print("\t");
            ++i;
        }
    }

    public void fixtexturenames() {
        if (this.fixtex) {
            Cons.println("Fixing envmapped texture names");
        }
        int i = 0;
        while (i < this.m.texname.length) {
            String tex = this.m.texname[i];
            if (this.debug) {
                Cons.println("Fixup: " + tex);
            }
            if (tex.equalsIgnoreCase("tools/locked")) {
                this.m.ebspval = true;
            }
            if (this.fixtex) {
                String[] token = tex.split("/");
                int tokens = token.length;
                if (token[0].equalsIgnoreCase("maps")) {
                    int utokens;
                    int cx = 0;
                    int cy = 0;
                    int cz = 0;
                    String ftex = token[tokens - 1];
                    String[] utex = ftex.split("_");
                    int endtoken = utokens = utex.length;
                    boolean deporg = Pattern.matches(".+_-?\\d+_-?\\d+_-?\\d+_depth_-?\\d+$", ftex);
                    boolean deponly = Pattern.matches(".+_depth_-?\\d+$", ftex);
                    boolean orgonly = Pattern.matches(".+_-?\\d+_-?\\d+_-?\\d+$", ftex);
                    boolean wvtpatch = ftex.endsWith("_wvt_patch");
                    if (this.debug) {
                        Cons.print("do:" + deporg + " d:" + deponly + " o:" + orgonly);
                    }
                    if (deponly) {
                        endtoken = utokens - 2;
                    }
                    if (deporg) {
                        cx = Integer.parseInt(utex[utokens - 5]);
                        cy = Integer.parseInt(utex[utokens - 4]);
                        cz = Integer.parseInt(utex[utokens - 3]);
                        endtoken = utokens - 5;
                    }
                    if (orgonly) {
                        cx = Integer.parseInt(utex[utokens - 3]);
                        cy = Integer.parseInt(utex[utokens - 2]);
                        cz = Integer.parseInt(utex[utokens - 1]);
                        endtoken = utokens - 3;
                    }
                    if (wvtpatch) {
                        endtoken = utokens - 2;
                    }
                    if (!(deponly || deporg || orgonly || wvtpatch)) {
                        Cons.println("Unknown texture type: " + ftex + " from " + this.m.texname[i]);
                    }
                    StringBuffer otex = new StringBuffer(utex[0]);
                    int j = 1;
                    while (j < endtoken) {
                        otex.append("_" + utex[j]);
                        ++j;
                    }
                    if (this.debug) {
                        Cons.println(" -> " + otex.toString());
                    }
                    if (this.envmaps > 1 && !deponly) {
                        j = 0;
                        while (j < this.m.cubemaps) {
                            if (cx == this.m.cm[j].x && cy == this.m.cm[j].y && cz == this.m.cm[j].z) {
                                this.m.texenv[i] = j;
                                break;
                            }
                            ++j;
                        }
                    }
                    StringBuffer outtex = new StringBuffer();
                    if (tokens > 2) {
                        int stok = 2;
                        if (token[2].equalsIgnoreCase("maps")) {
                            stok = 4;
                        }
                        int j2 = stok;
                        while (j2 < tokens - 1) {
                            outtex.append(token[j2]).append("/");
                            ++j2;
                        }
                        outtex.append(otex);
                    }
                    this.m.texname[i] = outtex.toString();
                }
            }
            ++i;
        }
    }

    public void protbrushcheck() {
        boolean m1 = false;
        boolean m2 = false;
        boolean m3 = false;
        float Eps_size = 0.01f;
        int i = 0;
        while (i < this.m.brushes) {
            Brush b = this.m.br[i];
            if (this.alignedbrush(b) && this.sametexbrush(b)) {
                Vec bsize = this.getsize(i);
                Vec vec = new Vec(1.0f, 4.0f, 9.0f);
                if (vec.subtract(bsize).modulus() < Eps_size) {
                    m1 = true;
                }
                Vec vec2 = new Vec(4.0f, 9.0f, 1.0f);
                if (vec2.subtract(bsize).modulus() < Eps_size) {
                    m2 = true;
                }
                Vec vec3 = new Vec(9.0f, 1.0f, 4.0f);
                if (vec3.subtract(bsize).modulus() < Eps_size) {
                    m3 = true;
                }
            }
            ++i;
        }
        if (!(m1 && m2 && m3)) {
            return;
        }
        this.m.ebspval = true;
    }

    public Vec getsize(int brindex) {
        Vec mins = new Vec(56756.0f, 56756.0f, 56756.0f);
        Vec maxs = new Vec(-56756.0f, -56756.0f, -56756.0f);
        Brush brush = this.m.br[brindex];
        int i = 0;
        while (i < brush.numside) {
            Wind wside = Wind.windfromside(this.m, brush, i);
            int j = 0;
            while (j < wside.size()) {
                Vec v = (Vec)wside.v.get(j);
                mins = v.minbound(mins);
                maxs = v.maxbound(maxs);
                ++j;
            }
            ++i;
        }
        return maxs.subtract(mins);
    }

    public boolean alignedbrush(Brush brush) {
        float Aligned_alpha = 0.99f;
        if (brush.numside != 6) {
            return false;
        }
        int i = 0;
        while (i < 6) {
            Plane bpl = this.m.pl[this.m.bsd[brush.fstside + i].pnum];
            Vec pnorm = bpl.getvec();
            boolean axis = false;
            int j = 0;
            while (j < 3) {
                if (Math.abs(pnorm.comp(j)) > Aligned_alpha) {
                    axis = true;
                }
                ++j;
            }
            if (!axis) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean sametexbrush(Brush brush) {
        Brushside brsd = this.m.bsd[brush.fstside];
        Texture tex = this.m.gettex(brsd.texinfo);
        String texname = tex.name;
        if (tex == null) {
            return false;
        }
        boolean pass = true;
        int i = 1;
        while (i < brush.numside) {
            brsd = this.m.bsd[brush.fstside + i];
            String nexttexname = this.m.gettex((short)brsd.texinfo).name;
            if (!texname.equalsIgnoreCase(nexttexname)) {
                pass = false;
            }
            ++i;
        }
        return pass;
    }

    public void twait() {
        try {
            Thread.sleep(10L);
        }
        catch (Exception ex) {
            Cons.println(ex);
        }
    }

    public void args(String[] args) {
        if (args.length == 0) {
            this.usage();
        }
        try {
            int i = 0;
            while (i < args.length - 1) {
                block25: {
                    block26: {
                        if (args[i].length() <= 1) break block25;
                        if (args[i].charAt(0) != '-') break block26;
                        char c = args[i].charAt(1);
                        switch (c) {
                            case 'x': {
                                this.fixtex = false;
                                break;
                            }
                            case 'p': {
                                this.props = false;
                                break;
                            }
                            case 'o': {
                                this.fixorg = false;
                                break;
                            }
                            case 'd': {
                                this.depth = Float.parseFloat(args[i].substring(2));
                                break;
                            }
                            case 'r': {
                                this.prec = Integer.parseInt(args[i].substring(2));
                                if (this.prec < 0) {
                                    this.prec = 0;
                                    break;
                                }
                                break block25;
                            }
                            case 'c': {
                                this.envmaps = Integer.parseInt(args[i].substring(2));
                                if (this.envmaps < 0) {
                                    this.envmaps = 0;
                                    break;
                                }
                                break block25;
                            }
                            case 's': {
                                this.stexmode = Integer.parseInt(args[i].substring(2));
                                if (this.stexmode < 0 || this.stexmode > 3) {
                                    this.stexmode = 2;
                                    break;
                                }
                                break block25;
                            }
                            case 't': {
                                this.ttexmode = Integer.parseInt(args[i].substring(2));
                                if (this.ttexmode < 0 || this.ttexmode > 3) {
                                    this.ttexmode = 3;
                                    break;
                                }
                                break block25;
                            }
                            case 'D': {
                                this.debug = true;
                                Cons.println("Debugging output on");
                                break;
                            }
                            case 'm': {
                                this.dmode = Integer.parseInt(args[i].substring(2));
                                if (this.dmode < 0 || this.dmode > 3) {
                                    this.dmode = 3;
                                    break;
                                }
                                break block25;
                            }
                            case 'v': {
                                this.olays = false;
                                break;
                            }
                            case 'h': {
                                this.disps = false;
                                break;
                            }
                            case 'w': {
                                this.crunch = false;
                                break;
                            }
                            case 'u': {
                                this.newdisp = false;
                                break;
                            }
                            default: {
                                Cons.println("Unrecognised argument " + args[i]);
                                this.usage();
                                break;
                            }
                        }
                        break block25;
                    }
                    Cons.println("Unrecognised argument " + args[i]);
                    this.usage();
                }
                ++i;
            }
        }
        catch (NumberFormatException nfe) {
            Cons.println(nfe);
            this.usage();
        }
        this.filename = args[args.length - 1];
    }

    public void usage() {
        Cons.println("Usage: VMEX [options] filename\nwhere option are:\n  -m<mode>\tDecompiling mode: 0 original faces, 1 split faces,\n  \t\t2 orig and split faces, 3 brushes and planes (default)\n  -d<value>\tThickness of created brushes (default 1.0)\n  -t<mode>\tFace texture: 0 white, 1 black, 2 orange, 3 original (default)\n  -s<mode>\tBack texture: 0 white, 1 black, 2 invis (default), 3 as face\n  -r<value>\tDecimal precision of output floating point values (default 8)\n  -o\t\tDon't fixup origins of brush models\n  -p\t\tDon't output prop_statics\n  -x\t\tDon't fixup envmapped texture names\n  -c<value>\tCubemaps: 0 none, 1 origin only, n Up to n sides (default 8)\n  -v\t\tDon't output overlays\n  -h\t\tDon't output displacement surfaces\n  -w\t\tDon't crunch face windings\n  -u\t\tUse old pyramid-style displacement brushes\n\n");
    }

    public void gui() {
        JFrame frame = new JFrame("VMEX do what you want , cause pirates are free ;)");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel fpanel = new JPanel();
        fpanel.setLayout(new BorderLayout());
        fpanel.add((Component)new JLabel(" File "), "West");
        final JTextField fname = new JTextField("");
        fpanel.add((Component)fname, "Center");
        JButton fset = new JButton("Browse");
        fpanel.add((Component)fset, "East");
        panel.add((Component)fpanel, "North");
        JPanel cpanel = new JPanel();
        cpanel.setLayout(new BorderLayout());
        JPanel bpanel = new JPanel();
        JButton resetbt = new JButton("Defaults");
        JButton closebt = new JButton("Exit");
        JButton runbt = new JButton("ZOMG");
        bpanel.add(runbt);
        cpanel.add((Component)bpanel, "East");
        panel.add((Component)cpanel, "South");
        JGBPanel opanel = new JGBPanel();
        String[] dmodes = new String[]{"Original faces", "Split faces", "Orig and split faces", "Brushes and planes"};
        final JComboBox<String> dmodecb = new JComboBox<String>(dmodes);
        dmodecb.setSelectedIndex(3);
        opanel.add(new JLabel("You are a pirate"), 0, 0, 0);
        opanel.add((Component)new JLabel("    "), 0, 1);
        final JCheckBox origxb = new JCheckBox("Fixup origins", true);
        final JCheckBox textxb = new JCheckBox("Fixup texture names", true);
        final JCheckBox propxb = new JCheckBox("Prop_statics", true);
        final JCheckBox overxb = new JCheckBox("Overlays", true);
        final JCheckBox dispxb = new JCheckBox("Displacements", true);
        final JCheckBox crunxb = new JCheckBox("Crunch faces", true);
        final JCheckBox ndspxb = new JCheckBox("New disp. brushes", true);
        opanel.add((Component)new JLabel("    "), 2, 1);
        final JFormattedTextField precff = new JFormattedTextField(new Integer(8));
        int h = precff.getPreferredSize().height;
        precff.setPreferredSize(new Dimension(80, h));
        final JCheckBox cubexb = new JCheckBox("Cubemaps ", true);
        final JFormattedTextField cubeff = new JFormattedTextField(new Integer(8));
        h = cubeff.getPreferredSize().height;
        cubeff.setPreferredSize(new Dimension(80, h));
        String[] smodes = new String[]{"White", "Black", "Invisible", "Face"};
        String[] tmodes = new String[]{"White", "Black", "Orange", "Original"};
        final JComboBox<String> stexcb = new JComboBox<String>(smodes);
        stexcb.setSelectedIndex(3);
        final JComboBox<String> ttexcb = new JComboBox<String>(tmodes);
        ttexcb.setSelectedIndex(3);
        panel.add((Component)opanel, "Center");
        frame.setSize(600, 290);
        frame.setLocation(100, 100);
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)panel, "Center");
        frame.setVisible(true);
        cubexb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (cubexb.isSelected()) {
                    cubeff.setEnabled(true);
                } else {
                    cubeff.setEnabled(false);
                }
            }
        });
        closebt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        resetbt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dmodecb.setSelectedIndex(3);
                textxb.setSelected(true);
                origxb.setSelected(true);
                propxb.setSelected(true);
                overxb.setSelected(true);
                dispxb.setSelected(true);
                crunxb.setSelected(true);
                ndspxb.setSelected(true);
                stexcb.setSelectedIndex(3);
                ttexcb.setSelectedIndex(3);
                precff.setText("8");
                cubeff.setText("8");
                cubeff.setEnabled(true);
                cubexb.setSelected(true);
            }
        });
        runbt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int cubemaps;
                Vmex.this.filename = fname.getText();
                Vmex.this.dmode = dmodecb.getSelectedIndex();
                Vmex.this.fixorg = origxb.isSelected();
                Vmex.this.fixtex = textxb.isSelected();
                Vmex.this.props = propxb.isSelected();
                Vmex.this.disps = dispxb.isSelected();
                Vmex.this.olays = overxb.isSelected();
                Vmex.this.crunch = crunxb.isSelected();
                Vmex.this.newdisp = ndspxb.isSelected();
                Vmex.this.ttexmode = ttexcb.getSelectedIndex();
                Vmex.this.stexmode = stexcb.getSelectedIndex();
                Vmex.this.prec = (Integer)precff.getValue();
                Vmex.this.envmaps = cubexb.isSelected() ? ((cubemaps = ((Integer)cubeff.getValue()).intValue()) > 1 ? cubemaps : 1) : 0;
                if (Vmex.this.dmode == 3) {
                    Vmex.this.depth = 4.0f;
                }
                Vmex.this.exec();
            }
        });
        fset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String currentdir = System.getProperty("user.dir");
                    JFileChooser chooser = new JFileChooser(currentdir);
                    chooser.setDialogTitle("Choose a map file to decompile");
                    chooser.setFileFilter(new BspFileFilter());
                    int result = chooser.showOpenDialog(null);
                    if (result == 1) {
                        return;
                    }
                    String infile = chooser.getSelectedFile().getPath();
                    fname.setText(infile);
                }
                catch (Exception ex) {
                    Cons.println(ex);
                }
            }
        });
    }

    public static void main(String[] args) {
        Vmex inst = new Vmex();
        System.out.println("Valve Map Extractor " + VERSION + " - by Rof (rof@mellish.org.uk)");
        inst.gui();
    }
}

