
TOOL.Category		= "RT's STOOLs"
TOOL.Name			= "#Anti Noclip"
TOOL.Command		= nil
TOOL.ConfigName		= ""

TOOL.ClientConVar[ "action" ] = "1"

// DON'T change these!
actions = {
	{ "Make 'em walk.", 1 },
	{ "Kill them.", 2 },
	{ "Send them on a long journey downwards.", 3 },
	{ "Send them on a long journey upwards.", 4 }
}

if ( CLIENT ) then
	language.Add( "AntiNoclip", "Anti Noclip" )
	language.Add( "Tool_rt_antinoclip_name", "RT's Anti Noclip" )
	language.Add( "Tool_rt_antinoclip_desc", "Makes a prop un-noclip-through-able." )
	language.Add( "Tool_rt_antinoclip_0", "Left click on an entity to make it un-noclip-through-able. Right click to undo." )
end

include( "lib/lib.antinoclip.lua" )

function TOOL:LeftClick( trace )

	local entity = trace.Entity
	if entity:IsValid() then
		
		return AN.AddProp( entity, tonumber( self:GetClientInfo( "action" ) ) )
		
	end
	
end

function TOOL:RightClick( trace )

	local entity = trace.Entity
	if entity:IsValid() then
		
		return AN.RemoveProp( entity )
		
	end
	
end

function TOOL.BuildCPanel( cp )

	cp:AddControl( "Header", { Text = "#Tool_rt_antinoclip_name", Description	= "#Tool_rt_antinoclip_desc" }  )
	
	// Action combo box
	
	combo = {}
	combo.Label = "Action:"
	combo.MenuButton = 1
	combo.Folder = "settings/menu/main/construct/antinoclip/"
	combo.Options = {}
	
	for k, v in pairs( actions ) do
	  combo.Options[ v[ 1 ] ] = { rt_antinoclip_action = v[ 2 ] }
	end
	
	cp:AddControl( "ComboBox", combo )
	
end
	
