
TOOL.Category		= "RT's STOOLs"
TOOL.Name			= "#Anti Noclip - Mass"
TOOL.Command		= nil
TOOL.ConfigName		= ""

TOOL.ClientConVar[ "action" ] = "1"

// DON'T change these!
actions = {
	{ "Make 'em walk.", 1 },
	{ "Kill them.", 2 },
	{ "Send them on a long journey downwards.", 3 },
	{ "Send them on a long journey upwards.", 4 }
}

if ( CLIENT ) then
	language.Add( "AntiNoclip-Mass", "Anti Noclip - Mass" )
	language.Add( "Tool_rt_antinoclip_mass_name", "RT's Anti Noclip - Mass" )
	language.Add( "Tool_rt_antinoclip_mass_desc", "Makes a group of props un-noclip-through-able." )
	language.Add( "Tool_rt_antinoclip_mass_0", "Left click on an entity to make it and anything constrained to it un-noclip-through-able. Right click to undo." )
end

include( "lib/lib.antinoclip.lua" )

function TOOL:LeftClick( trace )

	local entity = trace.Entity
	if ( entity:IsValid() ) then
		
		local actionID = tonumber( self:GetClientInfo( "action" ) )
		
		local ents, constraints = duplicator.Copy( self:GetOwner(), entity, Vector( 0, 0, 0 ) )
		
		local result = false
		for k, v in pairs( ents ) do
			if ( AN.AddProp( v, actionID ) ) then result = true end
		end
		
		return result
		
	end
	
end

function TOOL:RightClick( trace )

	local entity = trace.Entity
	if ( entity:IsValid() ) then
		
		local ents, constraints = duplicator.Copy( self:GetOwner(), entity, Vector( 0, 0, 0 ) )
		
		local result = false
		for k, v in pairs( ents ) do
			if ( AN.RemoveProp( v ) ) then result = true end
		end
		
		return result
		
	end
	
end

function TOOL.BuildCPanel( cp )

	cp:AddControl( "Header", { Text = "#Tool_rt_antinoclip_mass_name", Description	= "#Tool_rt_antinoclip_mass_desc" }  )
	
	// Action combo box
	
	combo = {}
	combo.Label = "Action:"
	combo.MenuButton = 1
	combo.Folder = "settings/menu/main/construct/antinoclip_mass/"
	combo.Options = {}
	
	for k, v in pairs( actions ) do
	  combo.Options[ v[ 1 ] ] = { rt_antinoclip_mass_action = v[ 2 ] }
	end
	
	cp:AddControl( "ComboBox", combo )
	
end
	
