/*
	Anti Noclip Library
	By RabidToaster
*/

// Get the tables ready
AN = {}
AN.Props = {}

/*
	Anti Noclip core functions
*/

function AN.AddProp( entity, actionID )
	// Check that it isn't already added
	for k, v in pairs( AN.Props ) do
		if ( v.Entity == entity ) then
			return false
		end
	end

	// Add it to the table of anti-noclipped props.
	local entId = table.getn( AN.Props ) + 1
	AN.Props[ entId ] = {}
	AN.Props[ entId ].Entity = entity
	AN.Props[ entId ].ActionID = actionID
	
	// All went well, return true.
	return true
	
end

function AN.RemoveProp( entity )

	// Loop through the table of anti-noclipped props, if the entity is found, remove it from the table, and return true
	for k, v in pairs( AN.Props ) do
		if ( v.Entity == entity ) then
			table.remove( AN.Props, k )
			return true
		end
	end
	
	// It wasn't  anti-noclipped! Return false.
	return false
	
end

function AN.CheckProps()

	// If there's nothing anti-noclipped, there's no point in checking.
	if ( table.getn( AN.Props ) == 0 ) then return end
	
	local allPlayers = player.GetAll()
	
	// Loop through the table of anti-noclipped props.
	for k, prop in pairs( AN.Props ) do
		// If the entity still exists...
		if ( prop.Entity:IsValid() ) then
			
			for _, player in pairs( allPlayers ) do
				if ( player:Alive() && player:GetMoveType() == MOVETYPE_NOCLIP && isInBoundingBox( prop.Entity, player ) ) then
					
					local actionID = prop.ActionID
					
					if ( actionID == 1 ) then
						player:SetMoveType( MOVETYPE_WALK )
					elseif ( actionID == 2 ) then
						player:Kill()
					elseif ( actionID == 3 ) then
						player:SetVelocity( Vector( 0, 0, -7500 ) )
					elseif ( actionID == 4 ) then
						player:SetVelocity( Vector( 0, 0, 7500 ) )
					end
					
				end
			end
			
		else
		
			// It's not a valid entity anymore, no need to try and keep it anti-noclipped.
			table.remove( AN.Props, k )
			
		end
	end
	
end

hook.Add( "Think", "AN_checkProps", AN.CheckProps )


/*
	Other useful functions
*/

function isInBoundingBox( entity, other )
	
	local entPos = entity:GetPos()
	local otherPos = other:GetPos()
			
	local otherEdge = other:NearestPoint( entPos )
	local otherEdgeDir = ( otherEdge - entPos ):Normalize()
	local otherEdgeLength = ( otherEdge - entPos ):Length()
	
	local entityEdge = entity:NearestPoint( otherEdgeDir * 10000 )
	local entityEdgeLength = ( entityEdge - entPos ):Length()
	
	if ( otherEdgeLength < entityEdgeLength ) then
		return true
	end
	
	return false
	
end
