AllowEveryone = true -- Allow anyone to save / load?
	
if CLIENT then
	GhostEntities = {}
	GhostActive = false
	AddedHeight = 50
	
	function UpdateGhost ( filename )
		for k, v in pairs(GhostEntities) do
			k:Remove()
			GhostEntities[k] = nil
		end
		GhostActive = true
		TempStuff = util.KeyValuesToTable(file.Read("Copy Gun/" .. filename .. ".txt"))
		for k, v in pairs(TempStuff["entities"]) do
			local tr = LocalPlayer():GetEyeTrace()
			local ent = ents.Create("prop_physics")
			if ent:IsValid() then
				ent:SetPos(Vector(0, 0, AddedHeight) + tr.HitPos + Vector(TempStuff["entities"][k]["position"]["x"], TempStuff["entities"][k]["position"]["y"], TempStuff["entities"][k]["position"]["z"]))
				ent:SetAngles(Angle(TempStuff["entities"][k]["angles"]["x"], TempStuff["entities"][k]["angles"]["y"], TempStuff["entities"][k]["angles"]["z"]))
				ent:SetRenderMode(RENDERMODE_TRANSCOLOR)
				ent:SetColor(255, 255, 255, 100)
				ent:SetModel(TempStuff["entities"][k]["model"])
				ent:Spawn()
				GhostEntities[ent] = k
			end
		end
	end

	function RemoveGhost ( )
		for k, v in pairs(GhostEntities) do
			k:Remove()
			GhostEntities[k] = nil
		end
		GhostActive = false
	end
	
	function MoveGhost ( )
		if not GhostActive then return end
		if LocalPlayer():GetInfo("gmod_toolmode") ~= "loader" then RemoveGhost() return end
		for k, v in pairs(GhostEntities) do
			AddAngle = Angle(0, AddedRotation, 0)
			local tr = LocalPlayer():GetEyeTrace()
			k:SetPos(Vector(0, 0, AddedHeight) + tr.HitPos + Vector(TempStuff["entities"][v]["position"]["x"], TempStuff["entities"][v]["position"]["y"], TempStuff["entities"][v]["position"]["z"]))
			k:SetAngles(Angle(TempStuff["entities"][v]["angles"]["x"], TempStuff["entities"][v]["angles"]["y"], TempStuff["entities"][v]["angles"]["z"]))
		end
	end
	
	hook.Add("Think", "CopyGun_GhostThink", MoveGhost)
	
	function SpawnPattern ( )
		if not GhostActive then return end
		LocalPlayer():ConCommand("SpawnPattern\n")
		SetGlobalString("AddedHeight", AddedHeight)
	end
	
	function RebuildSpawnMenu ( )
		spawnmenu.AddContext( "Options", "ACG", Localize( "ACG", "Advanced CG Options"), Localize( "ACGDescription", "Allows you to change a few things.") )
		
		local cp = GetControlPanel( "ACG" )
		
		if cp then

			cp:ClearControls()
			cp:AddHeader()
			
			cp:AddControl("TextBox", {Label = "File Name", Description = "The file name used for saving and loading.", Command = "cg_pickedfile", MaxLength = "20"})
			
			cp:AddControl("Button", {Label = "Save File", Description = "Saves the file to the above filename.", Command = "SaveFile", Text = "Save"})
			
			cp:AddControl("Button", {Label = "Load File", Description = "Load the above filename.", Command = "gmod_tool; gmod_toolmode loader; LoadFile", Text = "Load"})
			
			cp:AddControl("Button", {Label = "Display List", Description = "Shows a list of files in the console.", Command = "DisplayList", Text = "In The Console"})

			cp:AddControl("Button", {Label = "Open Selector", Description = "Opens the saving toolgun.", Command = "gmod_toolmode selector", Text = "Toolgun"})
			
			cp:AddControl(  "Slider", { Label = "Height", Description = "Changes the height of the save.", Type = "Integer", Min = "0", Max = "500", Command = "ChangeAddedHeight" } )
		
		end
	end
	
	RebuildSpawnMenu ( )
end

if not SERVER then return end
AddCSLuaFile("autorun/save_load.lua")

CG = {}
CG.Entities = {}
CG.EntitiesTemp = {}
CG.Constraints = {}
CG.TempStuff = {}
AddedHeight = {}
CG.PickedFile = {}
CG.ConstraintTypes = {"Axis", "Ballsocket", "AdvancedBallsocket", "Elastic", "Hydraulic", "KeepUpright", "Motor", "Muscle", "Pulley", "Rope", "Slider", "Weld", "Winch", "NoCollide"}

function CG.DisplayList ( user, cmd, args )
	user:PrintMessage(HUD_PRINTCONSOLE, "----------\nFile List\n----------")
	for k, v in pairs(file.Find("Copy Gun/*.txt")) do
		user:PrintMessage(HUD_PRINTCONSOLE, string.gsub(v, ".txt", ""))
	end
	user:PrintMessage(HUD_PRINTCONSOLE, "----------")
end

concommand.Add("DisplayList", CG.DisplayList)

function CG.AddDummyFunc ( RealFunc, Hook )
    local function DummyFunc ( ... )
		Hook(unpack(arg))
        RealFuncResults = RealFunc(unpack(arg))
        return RealFuncResults
    end

    return DummyFunc
end

for k, v in pairs(CG.ConstraintTypes) do
	CG.Constraints[v] = {}
end

function CG.PlayerSetup ( user )
	CG = CG or {}
	CG.PickedFile = CG.PickedFile or {}
	CG.Entities = CG.Entities or {}
	CG.EntitiesTemp = CG.EntitiesTemp or {}
	AddedHeight = AddedHeight or {}
	
	user:SendLua("include(\"autorun/save_load.lua\")")
	CG.Entities[user:UniqueID()] = {}
	CG.EntitiesTemp[user:UniqueID()] = {}
	AddedHeight[user] = 50
	CG.PickedFile[user] = "Untitled"
end

hook.Add("PlayerInitialSpawn", "CopyGun_InitialSpawn", CG.PlayerSetup)

function CG.PickedFiles ( user, cmd, args )
	CG.PickedFile[user] = ""
	for k, v in pairs(args) do
		if k == table.getn(args) then
			CG.PickedFile[user] = CG.PickedFile[user] .. v
		else
			CG.PickedFile[user] = CG.PickedFile[user] .. v .. " "
		end
	end
end

concommand.Add("cg_pickedfile", CG.PickedFiles)

for k, v in pairs(player.GetAll()) do
	CG.PlayerSetup(v)
end

function CG.SaveFile ( User, cmd, args )
	FileName = CG.PickedFile[User]
	if not User:IsAdmin() and not AllowEveryone and not User:IsListenServerHost() then return end
	if FileName == "" or FileName == nil then return false end
	CG.SaveTable = {}
	CG.SaveTable["Entities"] = CG.Entities[User:UniqueID()]
	CG.SaveTable["Constraints"] = CG.Constraints
	CG.IsAllowable = {}
	
	local self_id = User:UniqueID()	
	
	if CG.EntitiesTemp[self_id][1] == nil then return end
	
	local LowestPos = 9999
	for k, v in pairs(CG.Entities[self_id]) do	
		if CG.Entities[self_id][k]["Position"]["X"] < LowestPos then
			LowestPos = CG.Entities[self_id][k]["Position"]["Z"]
		end
	end
	
	local TempPosBase = CG.EntitiesTemp[self_id][1]:GetPos()
	local TempStartX = TempPosBase.x
	local TempStartY = TempPosBase.y
		
	for k, v in pairs(CG.SaveTable["Entities"]) do
		CG.SaveTable["Entities"][k]["Position"]["X"] = CG.SaveTable["Entities"][k]["Position"]["X"] - TempStartX
		CG.SaveTable["Entities"][k]["Position"]["Y"] = CG.SaveTable["Entities"][k]["Position"]["Y"] - TempStartY
		CG.SaveTable["Entities"][k]["Position"]["Z"] = CG.SaveTable["Entities"][k]["Position"]["Z"] - LowestPos
		CG.IsAllowable[k] = true
	end
	
	for k, v in pairs(CG.ConstraintTypes) do
		for j, c in pairs(CG.Constraints[v]) do
			if v == "KeepUpright" then
				if not CG.IsAllowable[CG.Constraints[v][j]["Entity"]] then
					CG.SaveTable["Constraints"][v][j] = nil
				end
			else
				if not CG.IsAllowable[CG.Constraints[v][j]["Entities"]["One"]] or not CG.IsAllowable[CG.Constraints[v][j]["Entities"]["Two"]] then
					CG.SaveTable["Constraints"][v][j] = nil
				elseif v == "Pulley" then
					CG.SaveTable["Constraints"][v][j]["Positions"]["Two"]["X"] = CG.SaveTable["Constraints"][v][j]["Positions"]["Two"]["X"] - TempStartX
					CG.SaveTable["Constraints"][v][j]["Positions"]["Two"]["Y"] = CG.SaveTable["Constraints"][v][j]["Positions"]["Two"]["Y"] - TempStartY
					CG.SaveTable["Constraints"][v][j]["Positions"]["Two"]["Z"] = CG.SaveTable["Constraints"][v][j]["Positions"]["Two"]["Z"] - LowestPos
					CG.SaveTable["Constraints"][v][j]["Positions"]["Three"]["X"] = CG.SaveTable["Constraints"][v][j]["Positions"]["Three"]["X"] - TempStartX
					CG.SaveTable["Constraints"][v][j]["Positions"]["Three"]["Y"] = CG.SaveTable["Constraints"][v][j]["Positions"]["Three"]["Y"] - TempStartY
					CG.SaveTable["Constraints"][v][j]["Positions"]["Three"]["Z"] = CG.SaveTable["Constraints"][v][j]["Positions"]["Three"]["Z"] - LowestPos
					CG.SaveTable["Constraints"][v][j]["EntitiesTrue"] = nil
					CG.SaveTable["Constraints"][v][j]["EntityTrue"] = nil
				else
					CG.SaveTable["Constraints"][v][j]["EntitiesTrue"] = nil
					CG.SaveTable["Constraints"][v][j]["EntityTrue"] = nil
				end
			end
		end	
	end

	for k, v in pairs(CG.EntitiesTemp[self_id]) do
		v:SetColor(255, 255, 255, 255)
	end
	CG.EntitiesTemp[self_id] = {}
	CG.Entities[self_id] = {}
	
	if file.Exists("Copy Gun/" .. FileName .. ".txt") then
		local TempNumb = 0
		while TempNumb ~= nil do
			TempNumb = TempNumb + 1
			if not file.Exists("Copy Gun/" .. FileName .. tostring(TempNumb) .. ".txt") then
				file.Write("Copy Gun/" .. FileName .. tostring(TempNumb) .. ".txt", util.TableToKeyValues(CG.SaveTable))
				User:PrintMessage(HUD_PRINTTALK, "Your file has been saved as \"" .. FileName .. "\".")
				User:PrintMessage(HUD_PRINTCONSOLE, "Your file has been saved as \"" .. FileName .. "\".")
				TempNumb = nil
			end
		end
	else
		file.Write("Copy Gun/" .. FileName .. ".txt", util.TableToKeyValues(CG.SaveTable))
		User:PrintMessage(HUD_PRINTTALK, "Your file has been saved as \"" .. FileName .. "\".")
		User:PrintMessage(HUD_PRINTCONSOLE, "Your file has been saved as \"" .. FileName .. "\".")
	end
end

concommand.Add("SaveFile", CG.SaveFile)

function CG.AddAxisConstraint ( Ent1, Ent2, Bone1, Bone2, LPos1, LPos2, forcelimit, torquelimit, friction, nocollide )
	if stop then return end
	local CallID = math.random(0, 99999999)
	
	CG.Constraints["Axis"][CallID] = {}
	CG.Constraints["Axis"][CallID]["Entities"] = {}
	CG.Constraints["Axis"][CallID]["Entities"]["One"] = Ent1:EntIndex()
	CG.Constraints["Axis"][CallID]["Entities"]["Two"] = Ent2:EntIndex()
	CG.Constraints["Axis"][CallID]["EntitiesTrue"] = {}
	CG.Constraints["Axis"][CallID]["EntitiesTrue"]["One"] = Ent1
	CG.Constraints["Axis"][CallID]["EntitiesTrue"]["Two"] = Ent2
	CG.Constraints["Axis"][CallID]["Bones"] = {}
	CG.Constraints["Axis"][CallID]["Bones"]["One"] = Bone1
	CG.Constraints["Axis"][CallID]["Bones"]["Two"] = Bone2
	CG.Constraints["Axis"][CallID]["Positions"] = {}
	CG.Constraints["Axis"][CallID]["Positions"]["One"] = {}
	CG.Constraints["Axis"][CallID]["Positions"]["One"]["X"] = LPos1.x
	CG.Constraints["Axis"][CallID]["Positions"]["One"]["Y"] = LPos1.y
	CG.Constraints["Axis"][CallID]["Positions"]["One"]["Z"] = LPos1.z
	CG.Constraints["Axis"][CallID]["Positions"]["Two"] = {}
	CG.Constraints["Axis"][CallID]["Positions"]["Two"]["X"] = LPos2.x
	CG.Constraints["Axis"][CallID]["Positions"]["Two"]["Y"] = LPos2.y
	CG.Constraints["Axis"][CallID]["Positions"]["Two"]["Z"] = LPos2.z
	CG.Constraints["Axis"][CallID]["ForceLimit"] = forcelimit
	CG.Constraints["Axis"][CallID]["TorqueLimit"] = torquelimit
	CG.Constraints["Axis"][CallID]["Friction"] = friction
	CG.Constraints["Axis"][CallID]["NoCollide"] = nocollide
end

constraint.Axis = CG.AddDummyFunc ( constraint.Axis, CG.AddAxisConstraint )

function CG.AddBallsocketConstraint ( Ent1, Ent2, Bone1, Bone2, LPos, forcelimit, torquelimit, nocollide, systemmanager )
	if stop then return end
	local CallID = math.random(0, 99999999)
	
	CG.Constraints["Ballsocket"][CallID] = {}
	CG.Constraints["Ballsocket"][CallID]["Entities"] = {}
	CG.Constraints["Ballsocket"][CallID]["Entities"]["One"] = Ent1:EntIndex()
	CG.Constraints["Ballsocket"][CallID]["Entities"]["Two"] = Ent2:EntIndex()
	CG.Constraints["Ballsocket"][CallID]["EntitiesTrue"] = {}
	CG.Constraints["Ballsocket"][CallID]["EntitiesTrue"]["One"] = Ent1
	CG.Constraints["Ballsocket"][CallID]["EntitiesTrue"]["Two"] = Ent2
	CG.Constraints["Ballsocket"][CallID]["Bones"] = {}
	CG.Constraints["Ballsocket"][CallID]["Bones"]["One"] = Bone1
	CG.Constraints["Ballsocket"][CallID]["Bones"]["Two"] = Bone2
	CG.Constraints["Ballsocket"][CallID]["Position"] = {}
	CG.Constraints["Ballsocket"][CallID]["Position"]["X"] = LPos.x
	CG.Constraints["Ballsocket"][CallID]["Position"]["Y"] = LPos.y
	CG.Constraints["Ballsocket"][CallID]["Position"]["Z"] = LPos.z
	CG.Constraints["Ballsocket"][CallID]["ForceLimit"] = forcelimit
	CG.Constraints["Ballsocket"][CallID]["TorqueLimit"] = torquelimit
	CG.Constraints["Ballsocket"][CallID]["SystemManager"] = systemmanager
	CG.Constraints["Ballsocket"][CallID]["NoCollide"] = nocollide
end

constraint.Ballsocket = CG.AddDummyFunc ( constraint.Ballsocket, CG.AddBallsocketConstraint )

function CG.AddAdvBallsocketConstraint ( Ent1, Ent2, Bone1, Bone2, LPos1, LPos2, _forcelimit, _torquelimit, _xmin, _ymin, _zmin, _xmax, _ymax, _zmax, _xfric, _yfric, _zfric, _onlyrotation, _nocollide, systemmanager )
	if stop then return end
	local CallID = math.random(0, 99999999)
	
	CG.Constraints["AdvancedBallsocket"][CallID] = {}
	CG.Constraints["AdvancedBallsocket"][CallID]["Entities"] = {}
	CG.Constraints["AdvancedBallsocket"][CallID]["Entities"]["One"] = Ent1:EntIndex()
	CG.Constraints["AdvancedBallsocket"][CallID]["Entities"]["Two"] = Ent2:EntIndex()
	CG.Constraints["AdvancedBallsocket"][CallID]["EntitiesTrue"] = {}
	CG.Constraints["AdvancedBallsocket"][CallID]["EntitiesTrue"]["One"] = Ent1
	CG.Constraints["AdvancedBallsocket"][CallID]["EntitiesTrue"]["Two"] = Ent2
	CG.Constraints["AdvancedBallsocket"][CallID]["Bones"] = {}
	CG.Constraints["AdvancedBallsocket"][CallID]["Bones"]["One"] = Bone1
	CG.Constraints["AdvancedBallsocket"][CallID]["Bones"]["Two"] = Bone2
	CG.Constraints["AdvancedBallsocket"][CallID]["Positions"] = {}
	CG.Constraints["AdvancedBallsocket"][CallID]["Positions"]["One"] = {}
	CG.Constraints["AdvancedBallsocket"][CallID]["Positions"]["One"]["X"] = LPos1.x
	CG.Constraints["AdvancedBallsocket"][CallID]["Positions"]["One"]["Y"] = LPos1.y
	CG.Constraints["AdvancedBallsocket"][CallID]["Positions"]["One"]["Z"] = LPos1.z
	CG.Constraints["AdvancedBallsocket"][CallID]["Positions"]["Two"] = {}
	CG.Constraints["AdvancedBallsocket"][CallID]["Positions"]["Two"]["X"] = LPos2.x
	CG.Constraints["AdvancedBallsocket"][CallID]["Positions"]["Two"]["Y"] = LPos2.y
	CG.Constraints["AdvancedBallsocket"][CallID]["Positions"]["Two"]["Z"] = LPos2.z
	CG.Constraints["AdvancedBallsocket"][CallID]["ForceLimit"] = _forcelimit
	CG.Constraints["AdvancedBallsocket"][CallID]["TorqueLimit"] = _torquelimit
	CG.Constraints["AdvancedBallsocket"][CallID]["Minimum"] = {}
	CG.Constraints["AdvancedBallsocket"][CallID]["Minimum"]["X"] = _xmin
	CG.Constraints["AdvancedBallsocket"][CallID]["Minimum"]["Y"] = _ymin
	CG.Constraints["AdvancedBallsocket"][CallID]["Minimum"]["Z"] = _zmin
	CG.Constraints["AdvancedBallsocket"][CallID]["Maximum"] = {}
	CG.Constraints["AdvancedBallsocket"][CallID]["Maximum"]["X"] = _xmax
	CG.Constraints["AdvancedBallsocket"][CallID]["Maximum"]["Y"] = _ymax
	CG.Constraints["AdvancedBallsocket"][CallID]["Maximum"]["Z"] = _zmax
	CG.Constraints["AdvancedBallsocket"][CallID]["Friction"] = {}
	CG.Constraints["AdvancedBallsocket"][CallID]["Friction"]["X"] = _xfric
	CG.Constraints["AdvancedBallsocket"][CallID]["Friction"]["Y"] = _yfric
	CG.Constraints["AdvancedBallsocket"][CallID]["Friction"]["Z"] = _zfric
	CG.Constraints["AdvancedBallsocket"][CallID]["OnlyRotation"] = _onlyrotation
	CG.Constraints["AdvancedBallsocket"][CallID]["SystemManager"] = systemmanager
	CG.Constraints["AdvancedBallsocket"][CallID]["NoCollide"] = nocollide
end

constraint.AdvBallsocket = CG.AddDummyFunc ( constraint.AdvBallsocket, CG.AddAdvBallsocketConstraint )

function CG.AddElasticConstraint ( Ent1, Ent2, Bone1, Bone2, LPos1, LPos2, constant, damping, rdamping, material, width, stretchonly, systemmanager )
	if stop then return end
	local CallID = math.random(0, 99999999)
	
	CG.Constraints["Elastic"][CallID] = {}
	CG.Constraints["Elastic"][CallID]["Entities"] = {}
	CG.Constraints["Elastic"][CallID]["Entities"]["One"] = Ent1:EntIndex()
	CG.Constraints["Elastic"][CallID]["Entities"]["Two"] = Ent2:EntIndex()
	CG.Constraints["Elastic"][CallID]["EntitiesTrue"] = {}
	CG.Constraints["Elastic"][CallID]["EntitiesTrue"]["One"] = Ent1
	CG.Constraints["Elastic"][CallID]["EntitiesTrue"]["Two"] = Ent2
	CG.Constraints["Elastic"][CallID]["Bones"] = {}
	CG.Constraints["Elastic"][CallID]["Bones"]["One"] = Bone1
	CG.Constraints["Elastic"][CallID]["Bones"]["Two"] = Bone2
	CG.Constraints["Elastic"][CallID]["Positions"] = {}
	CG.Constraints["Elastic"][CallID]["Positions"]["One"] = {}
	CG.Constraints["Elastic"][CallID]["Positions"]["One"]["X"] = LPos1.x
	CG.Constraints["Elastic"][CallID]["Positions"]["One"]["Y"] = LPos1.y
	CG.Constraints["Elastic"][CallID]["Positions"]["One"]["Z"] = LPos1.z
	CG.Constraints["Elastic"][CallID]["Positions"]["Two"] = {}
	CG.Constraints["Elastic"][CallID]["Positions"]["Two"]["X"] = LPos2.x
	CG.Constraints["Elastic"][CallID]["Positions"]["Two"]["Y"] = LPos2.y
	CG.Constraints["Elastic"][CallID]["Positions"]["Two"]["Z"] = LPos2.z
	CG.Constraints["Elastic"][CallID]["Constant"] = constant
	CG.Constraints["Elastic"][CallID]["Damping"] = damping
	CG.Constraints["Elastic"][CallID]["RDamping"] = rdamping
	CG.Constraints["Elastic"][CallID]["Material"] = material
	CG.Constraints["Elastic"][CallID]["Width"] = width
	CG.Constraints["Elastic"][CallID]["StretchOnly"] = stretchonly
	CG.Constraints["Elastic"][CallID]["SystemManager"] = systemmanager
end

constraint.Elastic = CG.AddDummyFunc ( constraint.Elastic, CG.AddElasticConstraint )

function CG.AddHydraulicConstraint ( owner, Ent1, Ent2, Bone1, Bone2, LPos1, LPos2, Length1, Length2, width, bind, fixed, speed )
	if stop then return end
	local CallID = math.random(0, 99999999)
	
	CG.Constraints["Hydraulic"][CallID] = {}
	CG.Constraints["Hydraulic"][CallID]["Entities"] = {}
	CG.Constraints["Hydraulic"][CallID]["Entities"]["One"] = Ent1:EntIndex()
	CG.Constraints["Hydraulic"][CallID]["Entities"]["Two"] = Ent2:EntIndex()
	CG.Constraints["Hydraulic"][CallID]["EntitiesTrue"] = {}
	CG.Constraints["Hydraulic"][CallID]["EntitiesTrue"]["One"] = Ent1
	CG.Constraints["Hydraulic"][CallID]["EntitiesTrue"]["Two"] = Ent2
	CG.Constraints["Hydraulic"][CallID]["Bones"] = {}
	CG.Constraints["Hydraulic"][CallID]["Bones"]["One"] = Bone1
	CG.Constraints["Hydraulic"][CallID]["Bones"]["Two"] = Bone2
	CG.Constraints["Hydraulic"][CallID]["Positions"] = {}
	CG.Constraints["Hydraulic"][CallID]["Positions"]["One"] = {}
	CG.Constraints["Hydraulic"][CallID]["Positions"]["One"]["X"] = LPos1.x
	CG.Constraints["Hydraulic"][CallID]["Positions"]["One"]["Y"] = LPos1.y
	CG.Constraints["Hydraulic"][CallID]["Positions"]["One"]["Z"] = LPos1.z
	CG.Constraints["Hydraulic"][CallID]["Positions"]["Two"] = {}
	CG.Constraints["Hydraulic"][CallID]["Positions"]["Two"]["X"] = LPos2.x
	CG.Constraints["Hydraulic"][CallID]["Positions"]["Two"]["Y"] = LPos2.y
	CG.Constraints["Hydraulic"][CallID]["Positions"]["Two"]["Z"] = LPos2.z
	CG.Constraints["Hydraulic"][CallID]["Lengths"] = {}
	CG.Constraints["Hydraulic"][CallID]["Lengths"]["One"] = Length1
	CG.Constraints["Hydraulic"][CallID]["Lengths"]["Two"] = Length2
	CG.Constraints["Hydraulic"][CallID]["Width"] = width
	CG.Constraints["Hydraulic"][CallID]["Key"] = bind
	CG.Constraints["Hydraulic"][CallID]["Fixed"] = fixed
	CG.Constraints["Hydraulic"][CallID]["Speed"] = speed
	
	stop = true
	timer.Simple(.01, function () stop = false end)
end

constraint.Hydraulic = CG.AddDummyFunc ( constraint.Hydraulic, CG.AddHydraulicConstraint )

function CG.AddKeepUprightConstraint ( Ent, Ang, Bone, angularlimit, systemmanager )
	if stop then return end
	local CallID = math.random(0, 99999999)
	
	CG.Constraints["KeepUpright"][CallID] = {}
	CG.Constraints["KeepUpright"][CallID]["Entity"] = Ent:EntIndex()
	CG.Constraints["KeepUpright"][CallID]["EntityTrue"] = Ent
	CG.Constraints["KeepUpright"][CallID]["Bone"] = Bone
	CG.Constraints["KeepUpright"][CallID]["Angles"] = {}
	CG.Constraints["KeepUpright"][CallID]["Angles"]["X"] = string.Explode(" ", Ang:__tostring())[1]
	CG.Constraints["KeepUpright"][CallID]["Angles"]["Y"] = string.Explode(" ", Ang:__tostring())[1]
	CG.Constraints["KeepUpright"][CallID]["Angles"]["Z"] = string.Explode(" ", Ang:__tostring())[1]
	CG.Constraints["KeepUpright"][CallID]["AngularLimit"] = angularlimit
	CG.Constraints["KeepUpright"][CallID]["SystemManager"] = systemmanager
end

constraint.Keepupright = CG.AddDummyFunc ( constraint.Keepupright, CG.AddKeepUprightConstraint )

function CG.AddMotorConstraint ( Ent1, Ent2, Bone1, Bone2, LPos1, LPos2, friction, torque, time, nocollide, toggle, owner, limit, forekey, backkey )
	if stop then return end
	local CallID = math.random(0, 99999999)
	
	CG.Constraints["Motor"][CallID] = {}
	CG.Constraints["Motor"][CallID]["Entities"] = {}
	CG.Constraints["Motor"][CallID]["Entities"]["One"] = Ent1:EntIndex()
	CG.Constraints["Motor"][CallID]["Entities"]["Two"] = Ent2:EntIndex()
	CG.Constraints["Motor"][CallID]["EntitiesTrue"] = {}
	CG.Constraints["Motor"][CallID]["EntitiesTrue"]["One"] = Ent1
	CG.Constraints["Motor"][CallID]["EntitiesTrue"]["Two"] = Ent2
	CG.Constraints["Motor"][CallID]["Bones"] = {}
	CG.Constraints["Motor"][CallID]["Bones"]["One"] = Bone1
	CG.Constraints["Motor"][CallID]["Bones"]["Two"] = Bone2
	CG.Constraints["Motor"][CallID]["Positions"] = {}
	CG.Constraints["Motor"][CallID]["Positions"]["One"] = {}
	CG.Constraints["Motor"][CallID]["Positions"]["One"]["X"] = LPos1.x
	CG.Constraints["Motor"][CallID]["Positions"]["One"]["Y"] = LPos1.y
	CG.Constraints["Motor"][CallID]["Positions"]["One"]["Z"] = LPos1.z
	CG.Constraints["Motor"][CallID]["Positions"]["Two"] = {}
	CG.Constraints["Motor"][CallID]["Positions"]["Two"]["X"] = LPos2.x
	CG.Constraints["Motor"][CallID]["Positions"]["Two"]["Y"] = LPos2.y
	CG.Constraints["Motor"][CallID]["Positions"]["Two"]["Z"] = LPos2.z
	CG.Constraints["Motor"][CallID]["Keys"] = {}
	CG.Constraints["Motor"][CallID]["Keys"]["Forward"] = forekey
	CG.Constraints["Motor"][CallID]["Keys"]["Backward"] = backkey
	CG.Constraints["Motor"][CallID]["Friction"] = friction
	CG.Constraints["Motor"][CallID]["Torque"] = torque
	CG.Constraints["Motor"][CallID]["Time"] = time
	CG.Constraints["Motor"][CallID]["NoCollide"] = nocollide
	CG.Constraints["Motor"][CallID]["Toggle"] = toggle
	CG.Constraints["Motor"][CallID]["Limit"] = limit
end

constraint.Motor = CG.AddDummyFunc ( constraint.Motor, CG.AddMotorConstraint )

function CG.AddMuscleConstraint ( owner, Ent1, Ent2, Bone1, Bone2, LPos1, LPos2, Length1, Length2, width, bind, fixed, period, amp, systemmanager )
	if stop then return end
	local CallID = math.random(0, 99999999)
	
	CG.Constraints["Muscle"][CallID] = {}
	CG.Constraints["Muscle"][CallID]["Entities"] = {}
	CG.Constraints["Muscle"][CallID]["Entities"]["One"] = Ent1:EntIndex()
	CG.Constraints["Muscle"][CallID]["Entities"]["Two"] = Ent2:EntIndex()
	CG.Constraints["Muscle"][CallID]["EntitiesTrue"] = {}
	CG.Constraints["Muscle"][CallID]["EntitiesTrue"]["One"] = Ent1
	CG.Constraints["Muscle"][CallID]["EntitiesTrue"]["Two"] = Ent2
	CG.Constraints["Muscle"][CallID]["Bones"] = {}
	CG.Constraints["Muscle"][CallID]["Bones"]["One"] = Bone1
	CG.Constraints["Muscle"][CallID]["Bones"]["Two"] = Bone2
	CG.Constraints["Muscle"][CallID]["Positions"] = {}
	CG.Constraints["Muscle"][CallID]["Positions"]["One"] = {}
	CG.Constraints["Muscle"][CallID]["Positions"]["One"]["X"] = LPos1.x
	CG.Constraints["Muscle"][CallID]["Positions"]["One"]["Y"] = LPos1.y
	CG.Constraints["Muscle"][CallID]["Positions"]["One"]["Z"] = LPos1.z
	CG.Constraints["Muscle"][CallID]["Positions"]["Two"] = {}
	CG.Constraints["Muscle"][CallID]["Positions"]["Two"]["X"] = LPos2.x
	CG.Constraints["Muscle"][CallID]["Positions"]["Two"]["Y"] = LPos2.y
	CG.Constraints["Muscle"][CallID]["Positions"]["Two"]["Z"] = LPos2.z
	CG.Constraints["Muscle"][CallID]["Lengths"] = {}
	CG.Constraints["Muscle"][CallID]["Lengths"]["One"] = Length1
	CG.Constraints["Muscle"][CallID]["Lengths"]["Two"] = Length2
	CG.Constraints["Muscle"][CallID]["Width"] = width
	CG.Constraints["Muscle"][CallID]["Key"] = bind
	CG.Constraints["Muscle"][CallID]["Fixed"] = fixed
	CG.Constraints["Muscle"][CallID]["Period"] = Period
	CG.Constraints["Muscle"][CallID]["Amp"] = amp
	CG.Constraints["Muscle"][CallID]["SystemManager"] = systemmanager
	
	stop = true
	timer.Simple(.01, function () stop = false end)
end

constraint.Muscle = CG.AddDummyFunc ( constraint.Muscle, CG.AddMuscleConstraint )

function CG.AddPulleyConstraint ( Ent1, Ent4, Bone1, Bone4, LPos1, LPos4, WPos2, WPos3, forcelimit, rigid, width, material )
	if stop then return end
	local CallID = math.random(0, 99999999)
	
	CG.Constraints["Pulley"][CallID] = {}
	CG.Constraints["Pulley"][CallID]["Entities"] = {}
	CG.Constraints["Pulley"][CallID]["Entities"]["One"] = Ent1:EntIndex()
	CG.Constraints["Pulley"][CallID]["Entities"]["Two"] = Ent4:EntIndex()
	CG.Constraints["Pulley"][CallID]["EntitiesTrue"] = {}
	CG.Constraints["Pulley"][CallID]["EntitiesTrue"]["One"] = Ent1
	CG.Constraints["Pulley"][CallID]["EntitiesTrue"]["Two"] = Ent4
	CG.Constraints["Pulley"][CallID]["Bones"] = {}
	CG.Constraints["Pulley"][CallID]["Bones"]["One"] = Bone1
	CG.Constraints["Pulley"][CallID]["Bones"]["Two"] = Bone4
	CG.Constraints["Pulley"][CallID]["Positions"] = {}
	CG.Constraints["Pulley"][CallID]["Positions"]["One"] = {}
	CG.Constraints["Pulley"][CallID]["Positions"]["One"]["X"] = LPos1.x
	CG.Constraints["Pulley"][CallID]["Positions"]["One"]["Y"] = LPos1.y
	CG.Constraints["Pulley"][CallID]["Positions"]["One"]["Z"] = LPos1.z
	CG.Constraints["Pulley"][CallID]["Positions"]["Two"] = {}
	CG.Constraints["Pulley"][CallID]["Positions"]["Two"]["X"] = WPos2.x
	CG.Constraints["Pulley"][CallID]["Positions"]["Two"]["Y"] = WPos2.y
	CG.Constraints["Pulley"][CallID]["Positions"]["Two"]["Z"] = WPos2.z
	CG.Constraints["Pulley"][CallID]["Positions"]["Three"] = {}
	CG.Constraints["Pulley"][CallID]["Positions"]["Three"]["X"] = WPos3.x
	CG.Constraints["Pulley"][CallID]["Positions"]["Three"]["Y"] = WPos3.y
	CG.Constraints["Pulley"][CallID]["Positions"]["Three"]["Z"] = WPos3.z
	CG.Constraints["Pulley"][CallID]["Positions"]["Four"] = {}
	CG.Constraints["Pulley"][CallID]["Positions"]["Four"]["X"] = LPos4.x
	CG.Constraints["Pulley"][CallID]["Positions"]["Four"]["Y"] = LPos4.y
	CG.Constraints["Pulley"][CallID]["Positions"]["Four"]["Z"] = LPos4.z
	CG.Constraints["Pulley"][CallID]["Width"] = width
	CG.Constraints["Pulley"][CallID]["Rigid"] = rigit
	CG.Constraints["Pulley"][CallID]["ForceLimit"] = forcelimit
	CG.Constraints["Pulley"][CallID]["Material"] = material
end

constraint.Pulley = CG.AddDummyFunc ( constraint.Pulley, CG.AddPulleyConstraint )

function CG.AddRopeConstraint ( Ent1, Ent2, Bone1, Bone2, LPos1, LPos2, length, addlength, forcelimit, width, material, rigid, systemmanager )
	if stop then return end
	local CallID = math.random(0, 99999999)
	
	CG.Constraints["Rope"][CallID] = {}
	CG.Constraints["Rope"][CallID]["Entities"] = {}
	CG.Constraints["Rope"][CallID]["Entities"]["One"] = Ent1:EntIndex()
	CG.Constraints["Rope"][CallID]["Entities"]["Two"] = Ent2:EntIndex()
	CG.Constraints["Rope"][CallID]["EntitiesTrue"] = {}
	CG.Constraints["Rope"][CallID]["EntitiesTrue"]["One"] = Ent1
	CG.Constraints["Rope"][CallID]["EntitiesTrue"]["Two"] = Ent2
	CG.Constraints["Rope"][CallID]["Bones"] = {}
	CG.Constraints["Rope"][CallID]["Bones"]["One"] = Bone1
	CG.Constraints["Rope"][CallID]["Bones"]["Two"] = Bone2
	CG.Constraints["Rope"][CallID]["Positions"] = {}
	CG.Constraints["Rope"][CallID]["Positions"]["One"] = {}
	CG.Constraints["Rope"][CallID]["Positions"]["One"]["X"] = LPos1.x
	CG.Constraints["Rope"][CallID]["Positions"]["One"]["Y"] = LPos1.y
	CG.Constraints["Rope"][CallID]["Positions"]["One"]["Z"] = LPos1.z
	CG.Constraints["Rope"][CallID]["Positions"]["Two"] = {}
	CG.Constraints["Rope"][CallID]["Positions"]["Two"]["X"] = LPos2.x
	CG.Constraints["Rope"][CallID]["Positions"]["Two"]["Y"] = LPos2.y
	CG.Constraints["Rope"][CallID]["Positions"]["Two"]["Z"] = LPos2.z
	CG.Constraints["Rope"][CallID]["Length"] = length
	CG.Constraints["Rope"][CallID]["AddLength"] = addlength
	CG.Constraints["Rope"][CallID]["ForceLimit"] = forcelimit
	CG.Constraints["Rope"][CallID]["Width"] = width
	CG.Constraints["Rope"][CallID]["Material"] = material
	CG.Constraints["Rope"][CallID]["Rigid"] = tostring(rigid)
	CG.Constraints["Rope"][CallID]["SystemManager"] = systemmanager
end

constraint.Rope = CG.AddDummyFunc ( constraint.Rope, CG.AddRopeConstraint )

function CG.AddSliderConstraint ( Ent1, Ent2, Bone1, Bone2, LPos1, LPos2, width, systemmanager )
	if stop then return end
	local CallID = math.random(0, 99999999)
	
	CG.Constraints["Slider"][CallID] = {}
	CG.Constraints["Slider"][CallID]["Entities"] = {}
	CG.Constraints["Slider"][CallID]["Entities"]["One"] = Ent1:EntIndex()
	CG.Constraints["Slider"][CallID]["Entities"]["Two"] = Ent2:EntIndex()
	CG.Constraints["Slider"][CallID]["EntitiesTrue"] = {}
	CG.Constraints["Slider"][CallID]["EntitiesTrue"]["One"] = Ent1
	CG.Constraints["Slider"][CallID]["EntitiesTrue"]["Two"] = Ent2
	CG.Constraints["Slider"][CallID]["Bones"] = {}
	CG.Constraints["Slider"][CallID]["Bones"]["One"] = Bone1
	CG.Constraints["Slider"][CallID]["Bones"]["Two"] = Bone2
	CG.Constraints["Slider"][CallID]["Positions"] = {}
	CG.Constraints["Slider"][CallID]["Positions"]["One"] = {}
	CG.Constraints["Slider"][CallID]["Positions"]["One"]["X"] = LPos1.x
	CG.Constraints["Slider"][CallID]["Positions"]["One"]["Y"] = LPos1.y
	CG.Constraints["Slider"][CallID]["Positions"]["One"]["Z"] = LPos1.z
	CG.Constraints["Slider"][CallID]["Positions"]["Two"] = {}
	CG.Constraints["Slider"][CallID]["Positions"]["Two"]["X"] = LPos2.x
	CG.Constraints["Slider"][CallID]["Positions"]["Two"]["Y"] = LPos2.y
	CG.Constraints["Slider"][CallID]["Positions"]["Two"]["Z"] = LPos2.z
	CG.Constraints["Slider"][CallID]["Width"] = width
	CG.Constraints["Slider"][CallID]["SystemManager"] = systemmanager
end

constraint.Slider = CG.AddDummyFunc ( constraint.Slider, CG.AddSliderConstraint )

function CG.AddWeldConstraint ( Ent1, Ent2, Bone1, Bone2, forcelimit )
	if stop then return end
	local CallID = math.random(0, 99999999)
	
	CG.Constraints["Weld"][CallID] = {}
	CG.Constraints["Weld"][CallID]["Entities"] = {}
	CG.Constraints["Weld"][CallID]["Entities"]["One"] = Ent1:EntIndex()
	CG.Constraints["Weld"][CallID]["Entities"]["Two"] = Ent2:EntIndex()
	CG.Constraints["Weld"][CallID]["EntitiesTrue"] = {}
	CG.Constraints["Weld"][CallID]["EntitiesTrue"]["One"] = Ent1
	CG.Constraints["Weld"][CallID]["EntitiesTrue"]["Two"] = Ent2
	CG.Constraints["Weld"][CallID]["Bones"] = {}
	CG.Constraints["Weld"][CallID]["Bones"]["One"] = Bone1
	CG.Constraints["Weld"][CallID]["Bones"]["Two"] = Bone2
	CG.Constraints["Weld"][CallID]["ForceLimit"] = forcelimit
end

constraint.Weld = CG.AddDummyFunc ( constraint.Weld, CG.AddWeldConstraint )

function CG.AddWinchConstraint ( user, Ent1, Ent2, Bone1, Bone2, LPos1, LPos2, width, fwd_bind, bwd_bind, fwd_speed, bwd_speed, material, toggle, systemmanager )
	if stop then return end
	local CallID = math.random(0, 99999999)
	
	CG.Constraints["Winch"][CallID] = {}
	CG.Constraints["Winch"][CallID]["Entities"] = {}
	CG.Constraints["Winch"][CallID]["Entities"]["One"] = Ent1:EntIndex()
	CG.Constraints["Winch"][CallID]["Entities"]["Two"] = Ent2:EntIndex()
	CG.Constraints["Winch"][CallID]["EntitiesTrue"] = {}
	CG.Constraints["Winch"][CallID]["EntitiesTrue"]["One"] = Ent1
	CG.Constraints["Winch"][CallID]["EntitiesTrue"]["Two"] = Ent2
	CG.Constraints["Winch"][CallID]["Bones"] = {}
	CG.Constraints["Winch"][CallID]["Bones"]["One"] = Bone1
	CG.Constraints["Winch"][CallID]["Bones"]["Two"] = Bone2
	CG.Constraints["Winch"][CallID]["Positions"] = {}
	CG.Constraints["Winch"][CallID]["Positions"]["One"] = {}
	CG.Constraints["Winch"][CallID]["Positions"]["One"]["X"] = LPos1.x
	CG.Constraints["Winch"][CallID]["Positions"]["One"]["Y"] = LPos1.y
	CG.Constraints["Winch"][CallID]["Positions"]["One"]["Z"] = LPos1.z
	CG.Constraints["Winch"][CallID]["Positions"]["Two"] = {}
	CG.Constraints["Winch"][CallID]["Positions"]["Two"]["X"] = LPos2.x
	CG.Constraints["Winch"][CallID]["Positions"]["Two"]["Y"] = LPos2.y
	CG.Constraints["Winch"][CallID]["Positions"]["Two"]["Z"] = LPos2.z
	CG.Constraints["Winch"][CallID]["Keys"] = {}
	CG.Constraints["Winch"][CallID]["Keys"]["Forward"] = fwd_bind
	CG.Constraints["Winch"][CallID]["Keys"]["Backward"] = bwd_bind
	CG.Constraints["Winch"][CallID]["Speeds"] = {}
	CG.Constraints["Winch"][CallID]["Speeds"]["Forward"] = fwd_speed
	CG.Constraints["Winch"][CallID]["Speeds"]["Backward"] = bwd_speed
	CG.Constraints["Winch"][CallID]["Material"] = material
	CG.Constraints["Winch"][CallID]["Toggle"] = toggle
	CG.Constraints["Winch"][CallID]["SystemManager"] = systemmanager
	
	stop = true
	timer.Simple(.01, function () stop = false end)
end

constraint.Winch = CG.AddDummyFunc ( constraint.Winch, CG.AddWinchConstraint )

function CG.AddNoCollideConstraint ( Ent1, Ent2, Bone1, Bone2 )
	if stop then return end
	local CallID = math.random(0, 99999999)
	
	CG.Constraints["NoCollide"][CallID] = {}
	CG.Constraints["NoCollide"][CallID]["Entities"] = {}
	CG.Constraints["NoCollide"][CallID]["Entities"]["One"] = Ent1:EntIndex()
	CG.Constraints["NoCollide"][CallID]["Entities"]["Two"] = Ent2:EntIndex()
	CG.Constraints["NoCollide"][CallID]["EntitiesTrue"] = {}
	CG.Constraints["NoCollide"][CallID]["EntitiesTrue"]["One"] = Ent1
	CG.Constraints["NoCollide"][CallID]["EntitiesTrue"]["Two"] = Ent2
	CG.Constraints["NoCollide"][CallID]["Bones"] = {}
	CG.Constraints["NoCollide"][CallID]["Bones"]["One"] = Bone1
	CG.Constraints["NoCollide"][CallID]["Bones"]["Two"] = Bone2
	
	stop = true
	timer.Simple(.01, function () stop = false end)
end

constraint.NoCollide = CG.AddDummyFunc ( constraint.NoCollide, CG.AddNoCollideConstraint )

function CG.LoadFile ( user, cmd, args )
	if not user:IsAdmin() and not AllowEveryone and not user:IsListenServerHost() then return end
	local filename = CG.PickedFile[user]
	if not file.Exists("Copy Gun/" .. filename .. ".txt") then
		Msg("Error: \"" .. filename .. "\" does not exist.\n")
		return
	end
	
	user:ConCommand("gmod_tool; gmod_toolmode loader")
	CG.TempStuff[user] = util.KeyValuesToTable(file.Read("Copy Gun/" .. filename .. ".txt"))
	user:SendLua("UpdateGhost(\"" .. filename .. "\")")
end

concommand.Add("LoadFile", CG.LoadFile)

function CG.SetVariable ( user, cmd, args)
	if cmd == "ChangeAddedHeight" then
		AddedHeight[user] = tonumber(args[1])
		user:SendLua("AddedHeight = " .. args[1])
	end
end

concommand.Add("ChangeAddedHeight", CG.SetVariable)

function CG.SpawnPattern ( user, cmd, arguments )
	if CG.TempStuff[user] == nil then return end
	
	SpawnedEntities = {}
		
	user:SendLua("RemoveGhost ( )")

	local tr = user:GetEyeTrace()
	
	for k, v in pairs(CG.TempStuff[user]["entities"]) do
		Entity = ents.Create(CG.TempStuff[user]["entities"][k]["class"])
		if Entity:IsValid() then
			Entity:SetPos(tr.HitPos + Vector(0, 0, AddedHeight[user]) + Vector(tonumber(CG.TempStuff[user]["entities"][k]["position"]["x"]), tonumber(CG.TempStuff[user]["entities"][k]["position"]["y"]), tonumber(CG.TempStuff[user]["entities"][k]["position"]["z"])))
			Entity:SetAngles(Angle(tonumber(CG.TempStuff[user]["entities"][k]["angles"]["x"]), tonumber(CG.TempStuff[user]["entities"][k]["angles"]["y"]), tonumber(CG.TempStuff[user]["entities"][k]["angles"]["z"])))
			Entity:SetModel(CG.TempStuff[user]["entities"][k]["model"])
			Entity:Spawn()
			
			
			table.Merge(Entity:GetTable(), CG.TempStuff[user]["entities"][k]["table"])
			
			if CG.TempStuff[user]["entities"][k]["class"] == "gmod_balloon" then
				Entity:GetTable():SetForce(tonumber(CG.TempStuff[user]["entities"][k]["table"]["force"]))
				Entity:GetTable():SetPlayer(user)
			elseif CG.TempStuff[user]["entities"][k]["class"] == "gmod_button" then
				Entity:GetTable():SetPlayer( user )
				Entity:GetTable():SetKey( CG.TempStuff[user]["entities"][k]["table"]["key"] )
				Entity:GetTable():SetLabel( CG.TempStuff[user]["entities"][k]["table"]["description"] )
			elseif CG.TempStuff[user]["entities"][k]["class"] == "gmod_dynamite" then
				local Dyna = MakeDynamite(user, Entity:GetPos(), Entity:GetAngles(), CG.TempStuff[user]["entities"][k]["table"]["key"], tonumber(CG.TempStuff[user]["entities"][k]["table"]["damage"]), 0, 0, false )
				table.Merge(Dyna:GetTable(), CG.TempStuff[user]["entities"][k]["table"])
				
				Entity:Remove()
				Entity = Dyna
			elseif CG.TempStuff[user]["entities"][k]["class"] == "gmod_hoverball" then
				local Ball = MakeHoverBall(user, Entity:GetPos(), CG.TempStuff[user]["entities"][k]["table"]["key_d"], CG.TempStuff[user]["entities"][k]["table"]["key_u"], CG.TempStuff[user]["entities"][k]["table"]["speed"], CG.TempStuff[user]["entities"][k]["table"]["airresistance"], CG.TempStuff[user]["entities"][k]["table"]["strength"])
				table.Merge(Ball:GetTable(), CG.TempStuff[user]["entities"][k]["table"])
				
				Entity:Remove()
				Entity = Ball
			elseif CG.TempStuff[user]["entities"][k]["class"] == "gmod_thruster" then
				local toggle = CG.TempStuff[user]["entities"][k]["table"]["force"] or "0"
				local damageable = CG.TempStuff[user]["entities"][k]["table"]["damageable"] or "0"
				local nocollide = CG.TempStuff[user]["entities"][k]["table"]["nocollide"] or "0"
				local Thruster = MakeThruster(user, CG.TempStuff[user]["entities"][k]["model"], Entity:GetAngles(), Entity:GetPos(), CG.TempStuff[user]["entities"][k]["table"]["key"], CG.TempStuff[user]["entities"][k]["table"]["key_bck"], CG.TempStuff[user]["entities"][k]["table"]["force"], toggle, CG.TempStuff[user]["entities"][k]["table"]["effect"], damageable, nocollide, 0, 0, false )
				table.Merge(Thruster:GetTable(), CG.TempStuff[user]["entities"][k]["table"])
				
				Entity:Remove()
				Entity = Thruster
			elseif CG.TempStuff[user]["entities"][k]["class"] == "gmod_emitter" then
				local Emmiter = MakeEmitter(user, Entity:GetPos(), CG.TempStuff[user]["entities"][k]["table"]["key"], CG.TempStuff[user]["entities"][k]["table"]["delay"], "1", CG.TempStuff[user]["entities"][k]["table"]["effect"], "0", 0, 0, false, "0")
				table.Merge(Emmiter:GetTable(), CG.TempStuff[user]["entities"][k]["table"])
				
				Emmiter:SetAngles(Entity:GetAngles())
				
				Entity:Remove()
				Entity = Emmiter
			end
			
			SpawnedEntities[k] = Entity
			
			Entity:Fire("disablemotion", "", 0)
						
			if Entity:IsValid() then
				
				if Entity:GetPhysicsObject():IsValid() then
					Entity:GetPhysicsObject():Sleep()
				end
				Entity:SetMoveType(tonumber(CG.TempStuff[user]["entities"][k]["movetype"]))
				Entity:SetMoveCollide(tonumber(CG.TempStuff[user]["entities"][k]["movecollide"]))
				Entity:SetMaxHealth(tonumber(CG.TempStuff[user]["entities"][k]["maxhealth"]))
				Entity:SetHealth(tonumber(CG.TempStuff[user]["entities"][k]["health"]))
				Entity:SetColor(tonumber(CG.TempStuff[user]["entities"][k]["color"]["red"]), tonumber(CG.TempStuff[user]["entities"][k]["color"]["green"]), tonumber(CG.TempStuff[user]["entities"][k]["color"]["blue"]), tonumber(CG.TempStuff[user]["entities"][k]["color"]["alpha"]))
				if CG.TempStuff[user]["entities"][k]["name"] ~= nil then
					Entity:SetName(CG.TempStuff[user]["entities"][k]["name"])
				end
				if CG.TempStuff[user]["entities"][k]["material"] ~= nil then
					Entity:SetMaterial(CG.TempStuff[user]["entities"][k]["material"])
				end
				if CG.TempStuff[user]["entities"][k]["skin"] ~= nil then
					Entity:SetSkin(CG.TempStuff[user]["entities"][k]["skin"])
				end
				if CG.TempStuff[user]["entities"][k]["name"] ~= nil then
					Entity:SetName(CG.TempStuff[user]["entities"][k]["name"])
				end
			
			end
		end
	end
	
	ConstraintsToRemove = {}
	
	if CG.TempStuff[user]["constraints"]["axis"] ~= nil then
		for k, v in pairs(CG.TempStuff[user]["constraints"]["axis"]) do
			local Entity1Value = tostring(CG.TempStuff[user]["constraints"]["axis"][k]["entities"]["one"])
			local Entity2Value = tostring(CG.TempStuff[user]["constraints"]["axis"][k]["entities"]["two"])
			local Bone1Value = CG.TempStuff[user]["constraints"]["axis"][k]["bones"]["one"]
			local Bone2Value = CG.TempStuff[user]["constraints"]["axis"][k]["bones"]["two"]
			local Pos1 = Vector(tonumber(CG.TempStuff[user]["constraints"]["axis"][k]["positions"]["one"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["axis"][k]["positions"]["one"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["axis"][k]["positions"]["one"]["z"]))
			local Pos2 = Vector(tonumber(CG.TempStuff[user]["constraints"]["axis"][k]["positions"]["two"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["axis"][k]["positions"]["two"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["axis"][k]["positions"]["two"]["z"]))
			local ForceLimit = CG.TempStuff[user]["constraints"]["axis"][k]["forcelimit"]
			local TorqueLimit = CG.TempStuff[user]["constraints"]["axis"][k]["torquelimit"]
			local Friction = CG.TempStuff[user]["constraints"]["axis"][k]["friction"]
			local NoCollide = CG.TempStuff[user]["constraints"]["axis"][k]["nocollide"]
			
			if SpawnedEntities[Entity1Value] ~= nil and SpawnedEntities[Entity2Value] ~= nil then
				table.insert(ConstraintsToRemove, constraint.Axis(SpawnedEntities[Entity1Value], SpawnedEntities[Entity2Value], Bone1Value, Bone2Value, Pos1, Pos2, ForceLimit, TorqueLimit, Friction, NoCollide ))
			end
		end
	end
	
	if CG.TempStuff[user]["constraints"]["ballsocket"] ~= nil then
		for k, v in pairs(CG.TempStuff[user]["constraints"]["ballsocket"]) do
			local Entity1Value = tostring(CG.TempStuff[user]["constraints"]["ballsocket"][k]["entities"]["one"])
			local Entity2Value = tostring(CG.TempStuff[user]["constraints"]["ballsocket"][k]["entities"]["two"])
			local Bone1Value = CG.TempStuff[user]["constraints"]["ballsocket"][k]["bones"]["one"]
			local Bone2Value = CG.TempStuff[user]["constraints"]["ballsocket"][k]["bones"]["two"]
			local Pos1 = Vector(tonumber(CG.TempStuff[user]["constraints"]["ballsocket"][k]["position"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["ballsocket"][k]["position"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["ballsocket"][k]["position"]["z"]))
			local ForceLimit = CG.TempStuff[user]["constraints"]["ballsocket"][k]["forcelimit"]
			local TorqueLimit = CG.TempStuff[user]["constraints"]["ballsocket"][k]["torquelimit"]
			local Friction = CG.TempStuff[user]["constraints"]["ballsocket"][k]["friction"]
			
			if SpawnedEntities[Entity1Value] ~= nil and SpawnedEntities[Entity2Value] ~= nil then
				table.insert(ConstraintsToRemove, constraint.Ballsocket(SpawnedEntities[Entity1Value], SpawnedEntities[Entity2Value], Bone1Value, Bone2Value, Pos1, ForceLimit, TorqueLimit, NoCollide, "0" ))
			end
		end
	end

	if CG.TempStuff[user]["constraints"]["advancedballsocket"] ~= nil then
		for k, v in pairs(CG.TempStuff[user]["constraints"]["advancedballsocket"]) do
			local Entity1Value = tostring(CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["entities"]["one"])
			local Entity2Value = tostring(CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["entities"]["two"])
			local Bone1Value = CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["bones"]["one"]
			local Bone2Value = CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["bones"]["two"]
			local Pos1 = Vector(tonumber(CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["positions"]["one"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["positions"]["one"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["positions"]["one"]["z"]))
			local Pos2 = Vector(tonumber(CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["positions"]["two"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["positions"]["two"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["positions"]["two"]["z"]))
			local ForceLimit = CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["forcelimit"]
			local TorqueLimit = CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["torquelimit"]
			local XMin = CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["minimum"]["x"]
			local YMin = CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["minimum"]["y"]
			local ZMin = CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["minimum"]["z"]
			local XMax = CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["maximum"]["x"]
			local YMax = CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["maximum"]["y"]
			local ZMax = CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["maximum"]["z"]
			local XFric = CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["friction"]["x"]
			local YFric = CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["friction"]["y"]
			local ZFric = CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["friction"]["z"]
			local OnlyRotation = CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["onlyrotation"]
			local NoCollide = CG.TempStuff[user]["constraints"]["advancedballsocket"][k]["nocollide"]
			
			if SpawnedEntities[Entity1Value] ~= nil and SpawnedEntities[Entity2Value] ~= nil then
				table.insert(ConstraintsToRemove, constraint.AdvBallsocket(SpawnedEntities[Entity1Value], SpawnedEntities[Entity2Value], Bone1Value, Bone2Value, Pos1, Pos2, ForceLimit, TorqueLimit, XMin, YMin, ZMin, XMax, YMax, ZMax, XFric, YFric, ZFric, OnlyRotation, NoCollide, "0"))
			end
		end
	end
	
	if CG.TempStuff[user]["constraints"]["elastic"] ~= nil then
		for k, v in pairs(CG.TempStuff[user]["constraints"]["elastic"]) do
			local Entity1Value = tostring(CG.TempStuff[user]["constraints"]["elastic"][k]["entities"]["one"])
			local Entity2Value = tostring(CG.TempStuff[user]["constraints"]["elastic"][k]["entities"]["two"])
			local Bone1Value = CG.TempStuff[user]["constraints"]["elastic"][k]["bones"]["one"]
			local Bone2Value = CG.TempStuff[user]["constraints"]["elastic"][k]["bones"]["two"]
			local Pos1 = Vector(tonumber(CG.TempStuff[user]["constraints"]["elastic"][k]["positions"]["one"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["elastic"][k]["positions"]["one"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["elastic"][k]["positions"]["one"]["z"]))
			local Pos2 = Vector(tonumber(CG.TempStuff[user]["constraints"]["elastic"][k]["positions"]["two"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["elastic"][k]["positions"]["two"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["elastic"][k]["positions"]["two"]["z"]))
			local Constant = CG.TempStuff[user]["constraints"]["elastic"][k]["constant"]
			local Damping = CG.TempStuff[user]["constraints"]["elastic"][k]["damping"]
			local RDamping = CG.TempStuff[user]["constraints"]["elastic"][k]["rdamping"]
			local Material = CG.TempStuff[user]["constraints"]["elastic"][k]["material"]
			local Width = CG.TempStuff[user]["constraints"]["elastic"][k]["width"]
			local StretchOnly = CG.TempStuff[user]["constraints"]["elastic"][k]["stretchonly"]
			local Width = CG.TempStuff[user]["constraints"]["elastic"][k]["width"]

			if SpawnedEntities[Entity1Value] ~= nil and SpawnedEntities[Entity2Value] ~= nil then
				table.insert(ConstraintsToRemove, constraint.Elastic(SpawnedEntities[Entity1Value], SpawnedEntities[Entity2Value], Bone1Value, Bone2Value, Pos1, Pos2, Constant, Damping, RDamping, Material, Width, StretchOnly, "0"))
			end
		end
	end
	
	
	if CG.TempStuff[user]["constraints"]["hydraulic"] ~= nil then
		for k, v in pairs(CG.TempStuff[user]["constraints"]["hydraulic"]) do
			local Entity1Value = tostring(CG.TempStuff[user]["constraints"]["hydraulic"][k]["entities"]["one"])
			local Entity2Value = tostring(CG.TempStuff[user]["constraints"]["hydraulic"][k]["entities"]["two"])
			local Bone1Value = CG.TempStuff[user]["constraints"]["hydraulic"][k]["bones"]["one"]
			local Bone2Value = CG.TempStuff[user]["constraints"]["hydraulic"][k]["bones"]["two"]
			local Pos1 = Vector(tonumber(CG.TempStuff[user]["constraints"]["hydraulic"][k]["positions"]["one"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["hydraulic"][k]["positions"]["one"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["hydraulic"][k]["positions"]["one"]["z"]))
			local Pos2 = Vector(tonumber(CG.TempStuff[user]["constraints"]["hydraulic"][k]["positions"]["two"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["hydraulic"][k]["positions"]["two"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["hydraulic"][k]["positions"]["two"]["z"]))
			local Length1 = CG.TempStuff[user]["constraints"]["hydraulic"][k]["lengths"]["one"]
			local Length2 = CG.TempStuff[user]["constraints"]["hydraulic"][k]["lengths"]["two"]
			local Width = CG.TempStuff[user]["constraints"]["hydraulic"][k]["width"]
			local Bind = CG.TempStuff[user]["constraints"]["hydraulic"][k]["key"]
			local Fixed = CG.TempStuff[user]["constraints"]["hydraulic"][k]["fixed"]
			local Speed = CG.TempStuff[user]["constraints"]["hydraulic"][k]["speed"]

			if SpawnedEntities[Entity1Value] ~= nil and SpawnedEntities[Entity2Value] ~= nil then
				table.insert(ConstraintsToRemove, constraint.Hydraulic( user, SpawnedEntities[Entity1Value], SpawnedEntities[Entity2Value], Bone1Value, Bone2Value, Pos1, Pos2, Length1, Length2, Width, Bind, Fixed, Speed ))
			end
		end
	end
	
	if CG.TempStuff[user]["constraints"]["keepupright"] ~= nil then
		for k, v in pairs(CG.TempStuff[user]["constraints"]["keepupright"]) do
			local Entity1Value = tostring(CG.TempStuff[user]["constraints"]["keepupright"][k]["entity"])
			local Bone = CG.TempStuff[user]["constraints"]["keepupright"][k]["bone"]
			local Ang = Angle(tonumber(CG.TempStuff[user]["constraints"]["keepupright"][k]["angles"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["keepupright"][k]["angles"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["keepupright"][k]["angles"]["z"]))
			local AngularLimit = CG.TempStuff[user]["constraints"]["keepupright"][k]["angularlimit"]
			
			if SpawnedEntities[Entity1Value] ~= nil then
				table.insert(ConstraintsToRemove, constraint.Keepupright( SpawnedEntities[Entity1Value], Ang, Bone, AngularLimit, "0" ))
			end
		end
	end
	
	if CG.TempStuff[user]["constraints"]["motor"] ~= nil then
		for k, v in pairs(CG.TempStuff[user]["constraints"]["motor"]) do
			local Entity1Value = tostring(CG.TempStuff[user]["constraints"]["motor"][k]["entities"]["one"])
			local Entity2Value = tostring(CG.TempStuff[user]["constraints"]["motor"][k]["entities"]["two"])
			local Bone1Value = CG.TempStuff[user]["constraints"]["motor"][k]["bones"]["one"]
			local Bone2Value = CG.TempStuff[user]["constraints"]["motor"][k]["bones"]["two"]
			local Pos1 = Vector(tonumber(CG.TempStuff[user]["constraints"]["motor"][k]["positions"]["one"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["motor"][k]["positions"]["one"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["motor"][k]["positions"]["one"]["z"]))
			local Pos2 = Vector(tonumber(CG.TempStuff[user]["constraints"]["motor"][k]["positions"]["two"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["motor"][k]["positions"]["two"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["motor"][k]["positions"]["two"]["z"]))
			local Key_F = CG.TempStuff[user]["constraints"]["motor"][k]["keys"]["forward"]
			local Key_B = CG.TempStuff[user]["constraints"]["motor"][k]["keys"]["backward"]
			local Friction = CG.TempStuff[user]["constraints"]["motor"][k]["friction"]
			local Torque = CG.TempStuff[user]["constraints"]["motor"][k]["torque"]
			local Limit = CG.TempStuff[user]["constraints"]["motor"][k]["limit"]
			local Time = CG.TempStuff[user]["constraints"]["motor"][k]["time"]
			local Toggle = CG.TempStuff[user]["constraints"]["motor"][k]["toggle"]
			local NoCollide = CG.TempStuff[user]["constraints"]["motor"][k]["nocollide"]
			
			if SpawnedEntities[Entity1Value] ~= nil and SpawnedEntities[Entity2Value] ~= nil then
				table.insert(ConstraintsToRemove, constraint.Motor(SpawnedEntities[Entity1Value], SpawnedEntities[Entity2Value], Bone1Value, Bone2Value, Pos1, Pos2, Friction, Torque, Time, NoCollide, Toggle, user, Limit, Key_F, Key_B ))
			end
		end
	end
	
	if CG.TempStuff[user]["constraints"]["muscle"] ~= nil then
		for k, v in pairs(CG.TempStuff[user]["constraints"]["muscle"]) do
			local Entity1Value = tostring(CG.TempStuff[user]["constraints"]["muscle"][k]["entities"]["one"])
			local Entity2Value = tostring(CG.TempStuff[user]["constraints"]["muscle"][k]["entities"]["two"])
			local Bone1Value = CG.TempStuff[user]["constraints"]["muscle"][k]["bones"]["one"]
			local Bone2Value = CG.TempStuff[user]["constraints"]["muscle"][k]["bones"]["two"]
			local Pos1 = Vector(tonumber(CG.TempStuff[user]["constraints"]["muscle"][k]["positions"]["one"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["muscle"][k]["positions"]["one"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["muscle"][k]["positions"]["one"]["z"]))
			local Pos2 = Vector(tonumber(CG.TempStuff[user]["constraints"]["muscle"][k]["positions"]["two"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["muscle"][k]["positions"]["two"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["muscle"][k]["positions"]["two"]["z"]))
			local Width = CG.TempStuff[user]["constraints"]["muscle"][k]["width"]
			local Bind = CG.TempStuff[user]["constraints"]["muscle"][k]["key"]
			local Length1 = CG.TempStuff[user]["constraints"]["muscle"][k]["lengths"]["one"]
			local Length2 = CG.TempStuff[user]["constraints"]["muscle"][k]["lengths"]["two"]
			local Amp = CG.TempStuff[user]["constraints"]["muscle"][k]["amp"]
			local Fixed = CG.TempStuff[user]["constraints"]["muscle"][k]["fixed"]
			
			if SpawnedEntities[Entity1Value] ~= nil and SpawnedEntities[Entity2Value] ~= nil then
				table.insert(ConstraintsToRemove, constraint.Muscle(user, SpawnedEntities[Entity1Value], SpawnedEntities[Entity2Value], Bone1Value, Bone2Value, Pos1, Pos2, Length1, Length2, Width, Bind, Fixed, "0", Amp, "0" ))
			end
		end
	end
	
	if CG.TempStuff[user]["constraints"]["pulley"] ~= nil then
		for k, v in pairs(CG.TempStuff[user]["constraints"]["pulley"]) do
			local Entity1Value = tostring(CG.TempStuff[user]["constraints"]["pulley"][k]["entities"]["one"])
			local Entity2Value = tostring(CG.TempStuff[user]["constraints"]["pulley"][k]["entities"]["two"])
			local Bone1Value = CG.TempStuff[user]["constraints"]["pulley"][k]["bones"]["one"]
			local Bone2Value = CG.TempStuff[user]["constraints"]["pulley"][k]["bones"]["two"]
			local Pos1 = Vector(tonumber(CG.TempStuff[user]["constraints"]["pulley"][k]["positions"]["one"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["pulley"][k]["positions"]["one"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["pulley"][k]["positions"]["one"]["z"]))
			local Pos2 = tr.HitPos + Vector(0, 0, AddedHeight[user]) + Vector(tonumber(CG.TempStuff[user]["constraints"]["pulley"][k]["positions"]["two"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["pulley"][k]["positions"]["two"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["pulley"][k]["positions"]["two"]["z"]))
			local Pos3 = tr.HitPos + Vector(0, 0, AddedHeight[user]) + Vector(tonumber(CG.TempStuff[user]["constraints"]["pulley"][k]["positions"]["three"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["pulley"][k]["positions"]["three"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["pulley"][k]["positions"]["three"]["z"]))
			local Pos4 = Vector(tonumber(CG.TempStuff[user]["constraints"]["pulley"][k]["positions"]["four"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["pulley"][k]["positions"]["four"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["pulley"][k]["positions"]["four"]["z"]))
			local Width = CG.TempStuff[user]["constraints"]["pulley"][k]["width"]
			local Material = CG.TempStuff[user]["constraints"]["pulley"][k]["material"]
			local ForceLimit = CG.TempStuff[user]["constraints"]["pulley"][k]["forcelimit"]
			
			if SpawnedEntities[Entity1Value] ~= nil and SpawnedEntities[Entity2Value] ~= nil then
				table.insert(ConstraintsToRemove, constraint.Pulley(SpawnedEntities[Entity1Value], SpawnedEntities[Entity2Value], Bone1Value, Bone2Value, Pos1, Pos4, Pos2, Pos3, ForceLimit, "0", Width, Material ))
			end
		end
	end
	
	if CG.TempStuff[user]["constraints"]["rope"] ~= nil then
		for k, v in pairs(CG.TempStuff[user]["constraints"]["rope"]) do
			local Entity1Value = tostring(CG.TempStuff[user]["constraints"]["rope"][k]["entities"]["one"])
			local Entity2Value = tostring(CG.TempStuff[user]["constraints"]["rope"][k]["entities"]["two"])
			local Bone1Value = CG.TempStuff[user]["constraints"]["rope"][k]["bones"]["one"]
			local Bone2Value = CG.TempStuff[user]["constraints"]["rope"][k]["bones"]["two"]
			local Pos1 = Vector(tonumber(CG.TempStuff[user]["constraints"]["rope"][k]["positions"]["one"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["rope"][k]["positions"]["one"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["rope"][k]["positions"]["one"]["z"]))
			local Pos2 = Vector(tonumber(CG.TempStuff[user]["constraints"]["rope"][k]["positions"]["two"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["rope"][k]["positions"]["two"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["rope"][k]["positions"]["two"]["z"]))
			
			local Width = CG.TempStuff[user]["constraints"]["rope"][k]["width"]
			local Material = CG.TempStuff[user]["constraints"]["rope"][k]["material"]
			local ForceLimit = CG.TempStuff[user]["constraints"]["rope"][k]["forcelimit"]
			local Length = CG.TempStuff[user]["constraints"]["rope"][k]["length"]
			local AddLength = CG.TempStuff[user]["constraints"]["rope"][k]["addlength"]
			local Rigid = CG.TempStuff[user]["constraints"]["rope"][k]["rigid"] or false
			
			if SpawnedEntities[Entity1Value] ~= nil and SpawnedEntities[Entity2Value] ~= nil then
				table.insert(ConstraintsToRemove, constraint.Rope(SpawnedEntities[Entity1Value], SpawnedEntities[Entity2Value], Bone1Value, Bone2Value, Pos1, Pos2, Length, AddLength, ForceLimit, Width, Material, Rigid, "0" ))
			end
		end
	end
	
	if CG.TempStuff[user]["constraints"]["slider"] ~= nil then
		for k, v in pairs(CG.TempStuff[user]["constraints"]["slider"]) do
			local Entity1Value = tostring(CG.TempStuff[user]["constraints"]["slider"][k]["entities"]["one"])
			local Entity2Value = tostring(CG.TempStuff[user]["constraints"]["slider"][k]["entities"]["two"])
			local Bone1Value = CG.TempStuff[user]["constraints"]["slider"][k]["bones"]["one"]
			local Bone2Value = CG.TempStuff[user]["constraints"]["slider"][k]["bones"]["two"]
			local Pos1 = Vector(tonumber(CG.TempStuff[user]["constraints"]["slider"][k]["positions"]["one"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["slider"][k]["positions"]["one"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["slider"][k]["positions"]["one"]["z"]))
			local Pos2 = Vector(tonumber(CG.TempStuff[user]["constraints"]["slider"][k]["positions"]["two"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["slider"][k]["positions"]["two"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["slider"][k]["positions"]["two"]["z"]))
			local Width = CG.TempStuff[user]["constraints"]["slider"][k]["width"]
			
			if SpawnedEntities[Entity1Value] ~= nil and SpawnedEntities[Entity2Value] ~= nil then
				table.insert(ConstraintsToRemove, constraint.Slider(SpawnedEntities[Entity1Value], SpawnedEntities[Entity2Value], Bone1Value, Bone2Value, Pos1, Pos2, Width, "0" ))
			end
		end
	end
	
	if CG.TempStuff[user]["constraints"]["weld"] ~= nil then
		for k, v in pairs(CG.TempStuff[user]["constraints"]["weld"]) do
			local Entity1Value = tostring(CG.TempStuff[user]["constraints"]["weld"][k]["entities"]["one"])
			local Entity2Value = tostring(CG.TempStuff[user]["constraints"]["weld"][k]["entities"]["two"])
			local Bone1Value = CG.TempStuff[user]["constraints"]["weld"][k]["bones"]["one"]
			local Bone2Value = CG.TempStuff[user]["constraints"]["weld"][k]["bones"]["two"]
			local ForceLimit = CG.TempStuff[user]["constraints"]["weld"][k]["force"]
			
			if SpawnedEntities[Entity1Value] ~= nil and SpawnedEntities[Entity2Value] ~= nil then
				table.insert(ConstraintsToRemove, constraint.Weld(SpawnedEntities[Entity1Value], SpawnedEntities[Entity2Value], Bone1Value, Bone2Value, ForceLimit ))
			end
		end
	end
	
	if CG.TempStuff[user]["constraints"]["winch"] ~= nil then
		for k, v in pairs(CG.TempStuff[user]["constraints"]["winch"]) do
			local Entity1Value = tostring(CG.TempStuff[user]["constraints"]["winch"][k]["entities"]["one"])
			local Entity2Value = tostring(CG.TempStuff[user]["constraints"]["winch"][k]["entities"]["two"])
			local Bone1Value = CG.TempStuff[user]["constraints"]["winch"][k]["bones"]["one"]
			local Bone2Value = CG.TempStuff[user]["constraints"]["winch"][k]["bones"]["two"]
			local Material = CG.TempStuff[user]["constraints"]["winch"][k]["material"]
			local Key_F = CG.TempStuff[user]["constraints"]["winch"][k]["keys"]["forward"]
			local Key_B = CG.TempStuff[user]["constraints"]["winch"][k]["keys"]["backward"]
			local Speed_F = CG.TempStuff[user]["constraints"]["winch"][k]["speeds"]["forward"]
			local Speed_B = CG.TempStuff[user]["constraints"]["winch"][k]["speeds"]["backward"]
			local Pos1 = Vector(tonumber(CG.TempStuff[user]["constraints"]["winch"][k]["positions"]["one"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["winch"][k]["positions"]["one"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["winch"][k]["positions"]["one"]["z"]))
			local Pos2 = Vector(tonumber(CG.TempStuff[user]["constraints"]["winch"][k]["positions"]["two"]["x"]), tonumber(CG.TempStuff[user]["constraints"]["winch"][k]["positions"]["two"]["y"]), tonumber(CG.TempStuff[user]["constraints"]["winch"][k]["positions"]["two"]["z"]))
			local Width = CG.TempStuff[user]["constraints"]["winch"][k]["width"] or 1
			local Toggle = CG.TempStuff[user]["constraints"]["winch"][k]["toggle"] or "0"
			
			if SpawnedEntities[Entity1Value] ~= nil and SpawnedEntities[Entity2Value] ~= nil then
				table.insert(ConstraintsToRemove, constraint.Winch( user, SpawnedEntities[Entity1Value], SpawnedEntities[Entity2Value], Bone1Value, Bone2Value, Pos1, Pos2, Width, Key_F, Key_B, Speed_F, Speed_B, Material, Toggle, "0" ))
			end
		end
	end
	
	if CG.TempStuff[user]["constraints"]["nocollide"] ~= nil then
		for k, v in pairs(CG.TempStuff[user]["constraints"]["nocollide"]) do
			local Entity1Value = tostring(CG.TempStuff[user]["constraints"]["nocollide"][k]["entities"]["one"])
			local Entity2Value = tostring(CG.TempStuff[user]["constraints"]["nocollide"][k]["entities"]["two"])
			local Bone1Value = CG.TempStuff[user]["constraints"]["nocollide"][k]["bones"]["one"]
			local Bone2Value = CG.TempStuff[user]["constraints"]["nocollide"][k]["bones"]["two"]
			
			if SpawnedEntities[Entity1Value] ~= nil and SpawnedEntities[Entity2Value] ~= nil then
				table.insert(ConstraintsToRemove, constraint.NoCollide( SpawnedEntities[Entity1Value], SpawnedEntities[Entity2Value], Bone1Value, Bone2Value ))
			end
		end
	end
	
	undo.Create("Load")
		for k, v in pairs(ConstraintsToRemove) do
			undo.AddEntity( v )
			user:AddCleanup( "props", v )
		end
		for k, v in pairs(SpawnedEntities) do
			undo.AddEntity( v )
			user:AddCleanup( "props", v )
		end
	undo.SetPlayer( user )
	undo.Finish()

	user:AddCleanup( "props", emitter )
	
	SpawnedEntities = {}
	
	CG.TempStuff[user] = nil
end

concommand.Add("SpawnPattern", CG.SpawnPattern)

function CG.Think_RemoveCons ( )
	for k, v in pairs(CG.Constraints) do
		for j, c in pairs(CG.Constraints[k]) do
			if k == "KeepUpright" then
				if CG.Constraints[k][j]["Entity"] ~= nil then
					if not CG.Constraints[k][j]["Entity"]:IsValid() then
						CG.Constraints[k][j] = nil
					end
				else
					CG.Constraints[k][j] = nil
				end
			else
				if CG.Constraints[k][j]["EntitiesTrue"] ~= nil then
					if not CG.Constraints[k][j]["EntitiesTrue"]["One"]:IsValid() or not CG.Constraints[k][j]["EntitiesTrue"]["Two"]:IsValid() then
						CG.Constraints[k][j] = nil
					end
				else
					CG.Constraints[k][j] = nil
				end
			end
		end
	end
end

hook.Add("Think", "CG_Think_RemoveCons", CG.Think_RemoveCons)