include("shared.lua");
-- Inventory Icon
if(file.Exists("../materials/weapons/hand_inventory.vmt")) then
	SWEP.WepSelectIcon = surface.GetTextureID("weapons/hand_inventory");
end
-- Kill Icon
if(file.Exists("../materials/weapons/hand_killicon.vmt")) then
	killicon.Add("weapon_hand_device","weapons/hand_killicon",Color(255,255,255));
end
language.Add("Battery_ammo","Naquadah");
language.Add("weapon_hand_device","Hand Device");

--################### Positions the viewmodel correctly @aVoN
function SWEP:GetViewModelPosition(p,a)
	p = p - 10*a:Up() - 6*a:Forward() + 1*a:Right();
	a:RotateAroundAxis(a:Right(),30);
	a:RotateAroundAxis(a:Up(),5);
	return p,a;
end

--################### Tell a player how to use this @aVoN
function SWEP:DrawHUD()
	local mode = "Push";
	local int = self.Weapon:GetNWInt("Mode",1);
	if(int == 1) then
		mode = "Push";
	elseif(int == 2) then
		mode = "Cook Brain";
	elseif(int == 3) then
		mode = "Call Nearest Rings";
	elseif(int == 4) then
		mode = "Open Ring Dial Menu";
	end
	draw.WordBox(8,ScrW()-188,ScrH()-120,"Primary: "..mode,"Default",Color(0,0,0,80),Color(255,220,0,220));
end
