/*
	ZPM Spawn Tool for GarrysMod10
	Copyright (C) 2007  aVoN

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

--################# Header
include("weapons/gmod_tool/stargate_base_tool.lua");
TOOL.Category="Energy";
TOOL.Name="#Zero Point Module";

TOOL.ClientConVar["autolink"] = 1;
TOOL.ClientConVar["autoweld"] = 1;
-- The default model for the GhostPreview
TOOL.ClientConVar["model"] = "models/zup/zpm/zpm.mdl";

-- Information about the SENT to spawn
TOOL.Entity.Class = "Zero_Point_Module";
TOOL.Entity.Limit = StarGate.CFG:Get("zpm","limit",3);

-- Add the topic texts, you see in the upper left corner
TOOL.Topic["name"] = "ZPM Spawner";
TOOL.Topic["desc"] = "Creates a Zero Point Module";
TOOL.Topic[0] = "Left click, to spawn a ZPM";
-- Adds additional "language" - To the end of these files, the string "_*classname*" will be added, using TOOL.Entity["class"]. 
-- E.g. TOOL.Language["Undone"] will add the language "Undone_prop_physics" when TOOL.Entity["class"] is "prop_physics"
TOOL.Language["Undone"] = "Zero Point Module removed";
TOOL.Language["Cleanup"] = "Zero Point Modules";
TOOL.Language["Cleaned"] = "Removed all Zero Point Modules";
TOOL.Language["SBoxLimit"] = "Hit the Zero Point Module limit";
--################# Code

--################# LeftClick Toolaction @aVoN
function TOOL:LeftClick(t)
	if(t.Entity and t.Entity:IsPlayer()) then return false end;
	if(t.Entity and t.Entity:GetClass() == self.Entity.Class) then return false end;
	if(CLIENT) then return true end;
	if(not self:CheckLimit()) then return false end;
	local p = self:GetOwner();
	--######## Spawn SENT
	local e = self:SpawnSENT(p,t);
	if(util.tobool(self:GetClientNumber("autolink"))) then
		self:AutoLink(e,t.Entity); -- Link to that energy system, if valid
	end
	--######## Weld things?
	local c = self:Weld(e,t.Entity,util.tobool(self:GetClientNumber("autoweld")));
	--######## Cleanup and undo register
	self:AddUndo(p,e,c);
	self:AddCleanup(p,c,e);
	return true;
end

--################# Controlpanel @aVoN
function TOOL:ControlsPanel(Panel)
	Panel:CheckBox("Autoweld","zpm_autoweld");
	if(StarGate.HasResourceDistribution) then
		Panel:CheckBox("Autolink","zpm_autolink"):SetToolTip("Autolink this to resouce using Entities?");
	else
		Panel:Help("The Zero Point Module perfectly fits into Resource Distribution and LifeSupport.\nYou seem not to have this installed.\nSo the ZPM is quite useless for you :)");
	end
end

--################# Register Stargate hooks. Needs to be called after all functions are loaded!
TOOL:Register();