/*
	Stargate Lib for GarrysMod10
	Copyright (C) 2007  aVoN

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
--################# DEFINES #################
StarGate.Hook = StarGate.Hook or {};
CreateConVar("gmod_stargate_version",StarGate.VERSION); -- Which version?

--################# Init @aVoN
function StarGate.Init()
	-- Resource Distribution Installed?
	if(Dev_Link or #file.FindInLua("weapons/gmod_tool/stools/dev_link.lua") == 1) then
		StarGate.HasResourceDistribution = true;
	else
		StarGate.HasResourceDistribution = false;
	end
	-- Wire?
	if(WireAddon or #file.FindInLua("weapons/gmod_tool/stools/wire.lua") == 1) then
		StarGate.HasWire = true;
	else
		StarGate.HasWire = false;
	end
end
StarGate.Init(); -- Call the Init

-- Add some usefull sounds to Wire Soundemitter
local snd = {
	["SGC Alarm"] = "SGC_alarm.wav",
	["SGC Offworld Alarm"] = "SGC_offworld-alarm.wav",
	["SGA Offworld Alarm"] = "SGA_offworld-alarm.wav",
	["SGA Selfdestruct Alarm"] = "SGA_selfdestruct-alarm.wav",
	["Midway Offworld Alarm"] = "SGA_midway_alarm.wav",
	["Midway Selfdestruct Alarm"] = "SGA_midway_selfdestruct.wav",
	["Walter: Chevron 1 encoded"] = "stargate/walter/c1.mp3",
	["Walter: Chevron 2 encoded"] = "stargate/walter/c2.mp3",
	["Walter: Chevron 3 encoded"] = "stargate/walter/c3.mp3",
	["Walter: Chevron 4 encoded"] = "stargate/walter/c4.mp3",
	["Walter: Chevron 5 encoded"] = "stargate/walter/c5.mp3",
	["Walter: Chevron 6 encoded"] = "stargate/walter/c6.mp3",
	["Walter: Chevron 7 encoded"] = "stargate/walter/c7.mp3",
	["Walter: Chevron 7 locked"] = "stargate/walter/c7_locked.mp3",
	["Walter: Chevron 7 failed"] = "stargate/walter/c7_failed.mp3",
	["Walter: Chevron 8 locked"] = "stargate/walter/c8_locked.mp3",
	["Walter: Unscheduled Offworld Activation"] = "stargate/walter/unscheduled_offworld_activation.mp3",
	["Ring Transporter Button 1"] = "tech/ring_button1.mp3",
	["Ring Transporter Button 2"] = "tech/ring_button2.mp3",
}
for k,v in pairs(snd) do
	list.Set("WireSounds",k,{wire_soundemitter_sound=v});
end
